/*
 * Decompiled with CFR 0.152.
 */
package geb.error;

import geb.error.GebException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SingleElementNavigatorOnlyMethodException
extends GebException {
    SingleElementNavigatorOnlyMethodException(Method singleElementMethod, int navigatorSize) {
        super((Object)SingleElementNavigatorOnlyMethodException.buildMessage(singleElementMethod, navigatorSize));
    }

    private static String buildMessage(Method singleElementMethod, int navigatorSize) {
        return String.format("Method %s can only be called on single element navigators but it was called on a navigator with size %d. Please use the spread operator to call this method on all elements of this navigator or change the selector used to create this navigator to only match a single element.", SingleElementNavigatorOnlyMethodException.methodDescription(singleElementMethod), navigatorSize);
    }

    private static String methodDescription(Method method) {
        ArrayList<String> parameterTypeNames = new ArrayList<String>();
        for (Class<?> parameterType : method.getParameterTypes()) {
            parameterTypeNames.add(parameterType.getName());
        }
        return String.format("%s(%s)", method.getName(), String.join((CharSequence)", ", parameterTypeNames));
    }
}

