/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package de.dwd.cdc.weather;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Station</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.dwd.cdc.weather.Station#getId <em>Id</em>}</li>
 *   <li>{@link de.dwd.cdc.weather.Station#getIcaoCode <em>Icao Code</em>}</li>
 *   <li>{@link de.dwd.cdc.weather.Station#getName <em>Name</em>}</li>
 *   <li>{@link de.dwd.cdc.weather.Station#getLocation <em>Location</em>}</li>
 *   <li>{@link de.dwd.cdc.weather.Station#getCountry <em>Country</em>}</li>
 * </ul>
 *
 * @see de.dwd.cdc.weather.WeatherPackage#getStation()
 * @model
 * @generated
 */
@ProviderType
public interface Station extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The DWD id
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see de.dwd.cdc.weather.WeatherPackage#getStation_Id()
	 * @model id="true" required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link de.dwd.cdc.weather.Station#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Icao Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Internation Civil Aviation Organization code
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Icao Code</em>' attribute.
	 * @see #setIcaoCode(String)
	 * @see de.dwd.cdc.weather.WeatherPackage#getStation_IcaoCode()
	 * @model
	 * @generated
	 */
	String getIcaoCode();

	/**
	 * Sets the value of the '{@link de.dwd.cdc.weather.Station#getIcaoCode <em>Icao Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Icao Code</em>' attribute.
	 * @see #getIcaoCode()
	 * @generated
	 */
	void setIcaoCode(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see de.dwd.cdc.weather.WeatherPackage#getStation_Name()
	 * @model required="true"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link de.dwd.cdc.weather.Station#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Location</em>' containment reference.
	 * @see #setLocation(GeoPosition)
	 * @see de.dwd.cdc.weather.WeatherPackage#getStation_Location()
	 * @model containment="true"
	 * @generated
	 */
	GeoPosition getLocation();

	/**
	 * Sets the value of the '{@link de.dwd.cdc.weather.Station#getLocation <em>Location</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Location</em>' containment reference.
	 * @see #getLocation()
	 * @generated
	 */
	void setLocation(GeoPosition value);

	/**
	 * Returns the value of the '<em><b>Country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Country</em>' attribute.
	 * @see #setCountry(String)
	 * @see de.dwd.cdc.weather.WeatherPackage#getStation_Country()
	 * @model
	 * @generated
	 */
	String getCountry();

	/**
	 * Sets the value of the '{@link de.dwd.cdc.weather.Station#getCountry <em>Country</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Country</em>' attribute.
	 * @see #getCountry()
	 * @generated
	 */
	void setCountry(String value);

} // Station
