/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml;

import java.util.List;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Data Block Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.gml.DataBlockType#getRangeParameters <em>Range Parameters</em>}</li>
 *   <li>{@link net.opengis.gml.DataBlockType#getTupleList <em>Tuple List</em>}</li>
 *   <li>{@link net.opengis.gml.DataBlockType#getDoubleOrNullTupleList <em>Double Or Null Tuple List</em>}</li>
 * </ul>
 *
 * @see net.opengis.gml.GMLPackage#getDataBlockType()
 * @model extendedMetaData="name='DataBlockType' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface DataBlockType extends EObject {
	/**
	 * Returns the value of the '<em><b>Range Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Range Parameters</em>' containment reference.
	 * @see #setRangeParameters(RangeParametersType)
	 * @see net.opengis.gml.GMLPackage#getDataBlockType_RangeParameters()
	 * @model containment="true" required="true"
	 *        extendedMetaData="kind='element' name='rangeParameters' namespace='##targetNamespace'"
	 * @generated
	 */
	RangeParametersType getRangeParameters();

	/**
	 * Sets the value of the '{@link net.opengis.gml.DataBlockType#getRangeParameters <em>Range Parameters</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Range Parameters</em>' containment reference.
	 * @see #getRangeParameters()
	 * @generated
	 */
	void setRangeParameters(RangeParametersType value);

	/**
	 * Returns the value of the '<em><b>Tuple List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Tuple List</em>' containment reference.
	 * @see #setTupleList(CoordinatesType)
	 * @see net.opengis.gml.GMLPackage#getDataBlockType_TupleList()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='tupleList' namespace='##targetNamespace'"
	 * @generated
	 */
	CoordinatesType getTupleList();

	/**
	 * Sets the value of the '{@link net.opengis.gml.DataBlockType#getTupleList <em>Tuple List</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tuple List</em>' containment reference.
	 * @see #getTupleList()
	 * @generated
	 */
	void setTupleList(CoordinatesType value);

	/**
	 * Returns the value of the '<em><b>Double Or Null Tuple List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Double Or Null Tuple List</em>' attribute.
	 * @see #setDoubleOrNullTupleList(List)
	 * @see net.opengis.gml.GMLPackage#getDataBlockType_DoubleOrNullTupleList()
	 * @model dataType="net.opengis.gml.DoubleOrNullList" many="false"
	 *        extendedMetaData="kind='element' name='doubleOrNullTupleList' namespace='##targetNamespace'"
	 * @generated
	 */
	List<Object> getDoubleOrNullTupleList();

	/**
	 * Sets the value of the '{@link net.opengis.gml.DataBlockType#getDoubleOrNullTupleList <em>Double Or Null Tuple List</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Double Or Null Tuple List</em>' attribute.
	 * @see #getDoubleOrNullTupleList()
	 * @generated
	 */
	void setDoubleOrNullTupleList(List<Object> value);

} // DataBlockType
