/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Ref Location Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.gml.RefLocationType#getAffinePlacement <em>Affine Placement</em>}</li>
 * </ul>
 *
 * @see net.opengis.gml.GMLPackage#getRefLocationType()
 * @model extendedMetaData="name='refLocation_._type' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface RefLocationType extends EObject {
	/**
	 * Returns the value of the '<em><b>Affine Placement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The "refLocation" is an affine mapping 
	 *           that places  the curve defined by the Fresnel Integrals  
	 *           into the co-ordinate reference system of this object.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Affine Placement</em>' containment reference.
	 * @see #setAffinePlacement(AffinePlacementType)
	 * @see net.opengis.gml.GMLPackage#getRefLocationType_AffinePlacement()
	 * @model containment="true" required="true"
	 *        extendedMetaData="kind='element' name='AffinePlacement' namespace='##targetNamespace'"
	 * @generated
	 */
	AffinePlacementType getAffinePlacement();

	/**
	 * Sets the value of the '{@link net.opengis.gml.RefLocationType#getAffinePlacement <em>Affine Placement</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Affine Placement</em>' containment reference.
	 * @see #getAffinePlacement()
	 * @generated
	 */
	void setAffinePlacement(AffinePlacementType value);

} // RefLocationType
