/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.ogc.impl;

import java.util.Collection;

import net.opengis.ogc.ArithmeticOperatorsType;
import net.opengis.ogc.FunctionsType;
import net.opengis.ogc.OGCPackage;
import net.opengis.ogc.SimpleArithmeticType;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Arithmetic Operators Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.ogc.impl.ArithmeticOperatorsTypeImpl#getGroup <em>Group</em>}</li>
 *   <li>{@link net.opengis.ogc.impl.ArithmeticOperatorsTypeImpl#getSimpleArithmetic <em>Simple Arithmetic</em>}</li>
 *   <li>{@link net.opengis.ogc.impl.ArithmeticOperatorsTypeImpl#getFunctions <em>Functions</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ArithmeticOperatorsTypeImpl extends MinimalEObjectImpl.Container implements ArithmeticOperatorsType {
	/**
	 * The cached value of the '{@link #getGroup() <em>Group</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGroup()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap group;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArithmeticOperatorsTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return OGCPackage.Literals.ARITHMETIC_OPERATORS_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureMap getGroup() {
		if (group == null) {
			group = new BasicFeatureMap(this, OGCPackage.ARITHMETIC_OPERATORS_TYPE__GROUP);
		}
		return group;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SimpleArithmeticType> getSimpleArithmetic() {
		return getGroup().list(OGCPackage.Literals.ARITHMETIC_OPERATORS_TYPE__SIMPLE_ARITHMETIC);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<FunctionsType> getFunctions() {
		return getGroup().list(OGCPackage.Literals.ARITHMETIC_OPERATORS_TYPE__FUNCTIONS);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__GROUP:
				return ((InternalEList<?>)getGroup()).basicRemove(otherEnd, msgs);
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__SIMPLE_ARITHMETIC:
				return ((InternalEList<?>)getSimpleArithmetic()).basicRemove(otherEnd, msgs);
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__FUNCTIONS:
				return ((InternalEList<?>)getFunctions()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__GROUP:
				if (coreType) return getGroup();
				return ((FeatureMap.Internal)getGroup()).getWrapper();
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__SIMPLE_ARITHMETIC:
				return getSimpleArithmetic();
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__FUNCTIONS:
				return getFunctions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__GROUP:
				((FeatureMap.Internal)getGroup()).set(newValue);
				return;
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__SIMPLE_ARITHMETIC:
				getSimpleArithmetic().clear();
				getSimpleArithmetic().addAll((Collection<? extends SimpleArithmeticType>)newValue);
				return;
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__FUNCTIONS:
				getFunctions().clear();
				getFunctions().addAll((Collection<? extends FunctionsType>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__GROUP:
				getGroup().clear();
				return;
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__SIMPLE_ARITHMETIC:
				getSimpleArithmetic().clear();
				return;
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__FUNCTIONS:
				getFunctions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__GROUP:
				return group != null && !group.isEmpty();
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__SIMPLE_ARITHMETIC:
				return !getSimpleArithmetic().isEmpty();
			case OGCPackage.ARITHMETIC_OPERATORS_TYPE__FUNCTIONS:
				return !getFunctions().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (group: ");
		result.append(group);
		result.append(')');
		return result.toString();
	}

} //ArithmeticOperatorsTypeImpl
