/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml.impl;

import java.util.Collection;

import net.opengis.gml.GMLPackage;
import net.opengis.gml.PolygonPatchArrayPropertyType;
import net.opengis.gml.PolygonPatchType;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Polygon Patch Array Property Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.gml.impl.PolygonPatchArrayPropertyTypeImpl#getPolygonPatch <em>Polygon Patch</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PolygonPatchArrayPropertyTypeImpl extends SurfacePatchArrayPropertyTypeImpl implements PolygonPatchArrayPropertyType {
	/**
	 * The cached value of the '{@link #getPolygonPatch() <em>Polygon Patch</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPolygonPatch()
	 * @generated
	 * @ordered
	 */
	protected EList<PolygonPatchType> polygonPatch;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PolygonPatchArrayPropertyTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GMLPackage.eINSTANCE.getPolygonPatchArrayPropertyType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PolygonPatchType> getPolygonPatch() {
		if (polygonPatch == null) {
			polygonPatch = new EObjectContainmentEList<PolygonPatchType>(PolygonPatchType.class, this, GMLPackage.POLYGON_PATCH_ARRAY_PROPERTY_TYPE__POLYGON_PATCH);
		}
		return polygonPatch;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GMLPackage.POLYGON_PATCH_ARRAY_PROPERTY_TYPE__POLYGON_PATCH:
				return ((InternalEList<?>)getPolygonPatch()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GMLPackage.POLYGON_PATCH_ARRAY_PROPERTY_TYPE__POLYGON_PATCH:
				return getPolygonPatch();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GMLPackage.POLYGON_PATCH_ARRAY_PROPERTY_TYPE__POLYGON_PATCH:
				getPolygonPatch().clear();
				getPolygonPatch().addAll((Collection<? extends PolygonPatchType>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GMLPackage.POLYGON_PATCH_ARRAY_PROPERTY_TYPE__POLYGON_PATCH:
				getPolygonPatch().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GMLPackage.POLYGON_PATCH_ARRAY_PROPERTY_TYPE__POLYGON_PATCH:
				return polygonPatch != null && !polygonPatch.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //PolygonPatchArrayPropertyTypeImpl
