/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.wfs;

import net.opengis.ogc.FeatureIdType;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Inserted Feature Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.wfs.InsertedFeatureType#getFeatureId <em>Feature Id</em>}</li>
 *   <li>{@link net.opengis.wfs.InsertedFeatureType#getHandle <em>Handle</em>}</li>
 * </ul>
 *
 * @see net.opengis.wfs.WFSPackage#getInsertedFeatureType()
 * @model extendedMetaData="name='InsertedFeatureType' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface InsertedFeatureType extends EObject {
	/**
	 * Returns the value of the '<em><b>Feature Id</b></em>' containment reference list.
	 * The list contents are of type {@link net.opengis.ogc.FeatureIdType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 *                   This is the feature identifier for the newly created
	 *                   feature.  The feature identifier may be generated by
	 *                   the WFS or provided by the client (depending on the 
	 *                   value of the idgen attribute).  In all cases of idgen
	 *                   values, the feature id must be reported here.
	 *                
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Feature Id</em>' containment reference list.
	 * @see net.opengis.wfs.WFSPackage#getInsertedFeatureType_FeatureId()
	 * @model containment="true" required="true"
	 *        extendedMetaData="kind='element' name='FeatureId' namespace='http://www.opengis.net/ogc'"
	 * @generated
	 */
	EList<FeatureIdType> getFeatureId();

	/**
	 * Returns the value of the '<em><b>Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 *                If the insert element that generated this feature 
	 *                had a value for the "handle" attribute then a WFS
	 *                may report it using this attribute to correlate
	 *                the feature created with the action that created it.
	 *             
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Handle</em>' attribute.
	 * @see #setHandle(String)
	 * @see net.opengis.wfs.WFSPackage#getInsertedFeatureType_Handle()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='attribute' name='handle'"
	 * @generated
	 */
	String getHandle();

	/**
	 * Sets the value of the '{@link net.opengis.wfs.InsertedFeatureType#getHandle <em>Handle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Handle</em>' attribute.
	 * @see #getHandle()
	 * @generated
	 */
	void setHandle(String value);

} // InsertedFeatureType
