/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.omg.bpmn.bpmn2.impl;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.omg.bpmn.bpmn2.Activity;
import org.omg.bpmn.bpmn2.AdHocSubProcess;
import org.omg.bpmn.bpmn2.Artifact;
import org.omg.bpmn.bpmn2.Assignment;
import org.omg.bpmn.bpmn2.Association;
import org.omg.bpmn.bpmn2.Auditing;
import org.omg.bpmn.bpmn2.BPMNRoot;
import org.omg.bpmn.bpmn2.BaseElement;
import org.omg.bpmn.bpmn2.BoundaryEvent;
import org.omg.bpmn.bpmn2.Bpmn2Package;
import org.omg.bpmn.bpmn2.BusinessRuleTask;
import org.omg.bpmn.bpmn2.CallActivity;
import org.omg.bpmn.bpmn2.CallChoreography;
import org.omg.bpmn.bpmn2.CallConversation;
import org.omg.bpmn.bpmn2.CallableElement;
import org.omg.bpmn.bpmn2.CancelEventDefinition;
import org.omg.bpmn.bpmn2.CatchEvent;
import org.omg.bpmn.bpmn2.Category;
import org.omg.bpmn.bpmn2.CategoryValue;
import org.omg.bpmn.bpmn2.Choreography;
import org.omg.bpmn.bpmn2.ChoreographyActivity;
import org.omg.bpmn.bpmn2.ChoreographyTask;
import org.omg.bpmn.bpmn2.Collaboration;
import org.omg.bpmn.bpmn2.CompensateEventDefinition;
import org.omg.bpmn.bpmn2.ComplexBehaviorDefinition;
import org.omg.bpmn.bpmn2.ComplexGateway;
import org.omg.bpmn.bpmn2.ConditionalEventDefinition;
import org.omg.bpmn.bpmn2.Conversation;
import org.omg.bpmn.bpmn2.ConversationAssociation;
import org.omg.bpmn.bpmn2.ConversationLink;
import org.omg.bpmn.bpmn2.ConversationNode;
import org.omg.bpmn.bpmn2.CorrelationKey;
import org.omg.bpmn.bpmn2.CorrelationProperty;
import org.omg.bpmn.bpmn2.CorrelationPropertyBinding;
import org.omg.bpmn.bpmn2.CorrelationPropertyRetrievalExpression;
import org.omg.bpmn.bpmn2.CorrelationSubscription;
import org.omg.bpmn.bpmn2.DataAssociation;
import org.omg.bpmn.bpmn2.DataInput;
import org.omg.bpmn.bpmn2.DataInputAssociation;
import org.omg.bpmn.bpmn2.DataObject;
import org.omg.bpmn.bpmn2.DataObjectReference;
import org.omg.bpmn.bpmn2.DataOutput;
import org.omg.bpmn.bpmn2.DataOutputAssociation;
import org.omg.bpmn.bpmn2.DataState;
import org.omg.bpmn.bpmn2.DataStore;
import org.omg.bpmn.bpmn2.DataStoreReference;
import org.omg.bpmn.bpmn2.Definitions;
import org.omg.bpmn.bpmn2.Documentation;
import org.omg.bpmn.bpmn2.EndEvent;
import org.omg.bpmn.bpmn2.EndPoint;
import org.omg.bpmn.bpmn2.ErrorEventDefinition;
import org.omg.bpmn.bpmn2.Escalation;
import org.omg.bpmn.bpmn2.EscalationEventDefinition;
import org.omg.bpmn.bpmn2.Event;
import org.omg.bpmn.bpmn2.EventBasedGateway;
import org.omg.bpmn.bpmn2.EventDefinition;
import org.omg.bpmn.bpmn2.ExclusiveGateway;
import org.omg.bpmn.bpmn2.Expression;
import org.omg.bpmn.bpmn2.Extension;
import org.omg.bpmn.bpmn2.ExtensionAttributeValue;
import org.omg.bpmn.bpmn2.FlowElement;
import org.omg.bpmn.bpmn2.FlowNode;
import org.omg.bpmn.bpmn2.FormalExpression;
import org.omg.bpmn.bpmn2.Gateway;
import org.omg.bpmn.bpmn2.GlobalBusinessRuleTask;
import org.omg.bpmn.bpmn2.GlobalChoreographyTask;
import org.omg.bpmn.bpmn2.GlobalConversation;
import org.omg.bpmn.bpmn2.GlobalManualTask;
import org.omg.bpmn.bpmn2.GlobalScriptTask;
import org.omg.bpmn.bpmn2.GlobalTask;
import org.omg.bpmn.bpmn2.GlobalUserTask;
import org.omg.bpmn.bpmn2.Group;
import org.omg.bpmn.bpmn2.HumanPerformer;
import org.omg.bpmn.bpmn2.ImplicitThrowEvent;
import org.omg.bpmn.bpmn2.Import;
import org.omg.bpmn.bpmn2.InclusiveGateway;
import org.omg.bpmn.bpmn2.InputOutputBinding;
import org.omg.bpmn.bpmn2.InputOutputSpecification;
import org.omg.bpmn.bpmn2.InputSet;
import org.omg.bpmn.bpmn2.Interface;
import org.omg.bpmn.bpmn2.IntermediateCatchEvent;
import org.omg.bpmn.bpmn2.IntermediateThrowEvent;
import org.omg.bpmn.bpmn2.ItemDefinition;
import org.omg.bpmn.bpmn2.Lane;
import org.omg.bpmn.bpmn2.LaneSet;
import org.omg.bpmn.bpmn2.LinkEventDefinition;
import org.omg.bpmn.bpmn2.LoopCharacteristics;
import org.omg.bpmn.bpmn2.ManualTask;
import org.omg.bpmn.bpmn2.Message;
import org.omg.bpmn.bpmn2.MessageEventDefinition;
import org.omg.bpmn.bpmn2.MessageFlow;
import org.omg.bpmn.bpmn2.MessageFlowAssociation;
import org.omg.bpmn.bpmn2.Monitoring;
import org.omg.bpmn.bpmn2.MultiInstanceLoopCharacteristics;
import org.omg.bpmn.bpmn2.Operation;
import org.omg.bpmn.bpmn2.OutputSet;
import org.omg.bpmn.bpmn2.ParallelGateway;
import org.omg.bpmn.bpmn2.Participant;
import org.omg.bpmn.bpmn2.ParticipantAssociation;
import org.omg.bpmn.bpmn2.ParticipantMultiplicity;
import org.omg.bpmn.bpmn2.PartnerEntity;
import org.omg.bpmn.bpmn2.PartnerRole;
import org.omg.bpmn.bpmn2.Performer;
import org.omg.bpmn.bpmn2.PotentialOwner;
import org.omg.bpmn.bpmn2.Property;
import org.omg.bpmn.bpmn2.ReceiveTask;
import org.omg.bpmn.bpmn2.Relationship;
import org.omg.bpmn.bpmn2.Rendering;
import org.omg.bpmn.bpmn2.Resource;
import org.omg.bpmn.bpmn2.ResourceAssignmentExpression;
import org.omg.bpmn.bpmn2.ResourceParameter;
import org.omg.bpmn.bpmn2.ResourceParameterBinding;
import org.omg.bpmn.bpmn2.ResourceRole;
import org.omg.bpmn.bpmn2.RootElement;
import org.omg.bpmn.bpmn2.ScriptTask;
import org.omg.bpmn.bpmn2.SendTask;
import org.omg.bpmn.bpmn2.SequenceFlow;
import org.omg.bpmn.bpmn2.ServiceTask;
import org.omg.bpmn.bpmn2.Signal;
import org.omg.bpmn.bpmn2.SignalEventDefinition;
import org.omg.bpmn.bpmn2.StandardLoopCharacteristics;
import org.omg.bpmn.bpmn2.StartEvent;
import org.omg.bpmn.bpmn2.SubChoreography;
import org.omg.bpmn.bpmn2.SubConversation;
import org.omg.bpmn.bpmn2.SubProcess;
import org.omg.bpmn.bpmn2.Task;
import org.omg.bpmn.bpmn2.TerminateEventDefinition;
import org.omg.bpmn.bpmn2.TextAnnotation;
import org.omg.bpmn.bpmn2.ThrowEvent;
import org.omg.bpmn.bpmn2.TimerEventDefinition;
import org.omg.bpmn.bpmn2.Transaction;
import org.omg.bpmn.bpmn2.UserTask;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BPMN Root</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getMixed <em>Mixed</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getXSISchemaLocation <em>XSI Schema Location</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getActivity <em>Activity</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getAdHocSubProcess <em>Ad Hoc Sub Process</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getFlowElement <em>Flow Element</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getArtifact <em>Artifact</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getAssignment <em>Assignment</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getAssociation <em>Association</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getAuditing <em>Auditing</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getBaseElement <em>Base Element</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getBaseElementWithMixedContent <em>Base Element With Mixed Content</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getBoundaryEvent <em>Boundary Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getBusinessRuleTask <em>Business Rule Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCallableElement <em>Callable Element</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCallActivity <em>Call Activity</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCallChoreography <em>Call Choreography</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCallConversation <em>Call Conversation</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getConversationNode <em>Conversation Node</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCancelEventDefinition <em>Cancel Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getEventDefinition <em>Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getRootElement <em>Root Element</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCatchEvent <em>Catch Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCategory <em>Category</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCategoryValue <em>Category Value</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getChoreography <em>Choreography</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCollaboration <em>Collaboration</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getChoreographyActivity <em>Choreography Activity</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getChoreographyTask <em>Choreography Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCompensateEventDefinition <em>Compensate Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getComplexBehaviorDefinition <em>Complex Behavior Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getComplexGateway <em>Complex Gateway</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getConditionalEventDefinition <em>Conditional Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getConversation <em>Conversation</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getConversationAssociation <em>Conversation Association</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getConversationLink <em>Conversation Link</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCorrelationKey <em>Correlation Key</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCorrelationProperty <em>Correlation Property</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCorrelationPropertyBinding <em>Correlation Property Binding</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCorrelationPropertyRetrievalExpression <em>Correlation Property Retrieval Expression</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getCorrelationSubscription <em>Correlation Subscription</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataAssociation <em>Data Association</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataInput <em>Data Input</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataInputAssociation <em>Data Input Association</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataObject <em>Data Object</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataObjectReference <em>Data Object Reference</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataOutput <em>Data Output</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataOutputAssociation <em>Data Output Association</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataState <em>Data State</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataStore <em>Data Store</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDataStoreReference <em>Data Store Reference</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDefinitions <em>Definitions</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getDocumentation <em>Documentation</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getEndEvent <em>End Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getEndPoint <em>End Point</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getError <em>Error</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getErrorEventDefinition <em>Error Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getEscalation <em>Escalation</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getEscalationEventDefinition <em>Escalation Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getEvent <em>Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getEventBasedGateway <em>Event Based Gateway</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getExclusiveGateway <em>Exclusive Gateway</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getExpression <em>Expression</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getExtension <em>Extension</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getExtensionElements <em>Extension Elements</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getFlowNode <em>Flow Node</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getFormalExpression <em>Formal Expression</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGateway <em>Gateway</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGlobalBusinessRuleTask <em>Global Business Rule Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGlobalChoreographyTask <em>Global Choreography Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGlobalConversation <em>Global Conversation</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGlobalManualTask <em>Global Manual Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGlobalScriptTask <em>Global Script Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGlobalTask <em>Global Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGlobalUserTask <em>Global User Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getGroup <em>Group</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getHumanPerformer <em>Human Performer</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getPerformer <em>Performer</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getResourceRole <em>Resource Role</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getImplicitThrowEvent <em>Implicit Throw Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getImport <em>Import</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getInclusiveGateway <em>Inclusive Gateway</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getInputSet <em>Input Set</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getInterface <em>Interface</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getIntermediateCatchEvent <em>Intermediate Catch Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getIntermediateThrowEvent <em>Intermediate Throw Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getIoBinding <em>Io Binding</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getIoSpecification <em>Io Specification</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getItemDefinition <em>Item Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getLane <em>Lane</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getLaneSet <em>Lane Set</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getLinkEventDefinition <em>Link Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getLoopCharacteristics <em>Loop Characteristics</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getManualTask <em>Manual Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getMessage <em>Message</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getMessageEventDefinition <em>Message Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getMessageFlow <em>Message Flow</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getMessageFlowAssociation <em>Message Flow Association</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getMonitoring <em>Monitoring</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getMultiInstanceLoopCharacteristics <em>Multi Instance Loop Characteristics</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getOperation <em>Operation</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getOutputSet <em>Output Set</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getParallelGateway <em>Parallel Gateway</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getParticipant <em>Participant</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getParticipantAssociation <em>Participant Association</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getParticipantMultiplicity <em>Participant Multiplicity</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getPartnerEntity <em>Partner Entity</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getPartnerRole <em>Partner Role</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getPotentialOwner <em>Potential Owner</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getProperty <em>Property</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getReceiveTask <em>Receive Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getRelationship <em>Relationship</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getRendering <em>Rendering</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getResource <em>Resource</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getResourceAssignmentExpression <em>Resource Assignment Expression</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getResourceParameter <em>Resource Parameter</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getResourceParameterBinding <em>Resource Parameter Binding</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getScript <em>Script</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getScriptTask <em>Script Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getSendTask <em>Send Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getSequenceFlow <em>Sequence Flow</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getServiceTask <em>Service Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getSignal <em>Signal</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getSignalEventDefinition <em>Signal Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getStandardLoopCharacteristics <em>Standard Loop Characteristics</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getStartEvent <em>Start Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getSubChoreography <em>Sub Choreography</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getSubConversation <em>Sub Conversation</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getSubProcess <em>Sub Process</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getTask <em>Task</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getTerminateEventDefinition <em>Terminate Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getText <em>Text</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getTextAnnotation <em>Text Annotation</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getThrowEvent <em>Throw Event</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getTimerEventDefinition <em>Timer Event Definition</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getTransaction <em>Transaction</em>}</li>
 *   <li>{@link org.omg.bpmn.bpmn2.impl.BPMNRootImpl#getUserTask <em>User Task</em>}</li>
 * </ul>
 *
 * @generated
 */
public class BPMNRootImpl extends MinimalEObjectImpl.Container implements BPMNRoot {
	/**
	 * The cached value of the '{@link #getMixed() <em>Mixed</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMixed()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap mixed;

	/**
	 * The cached value of the '{@link #getXMLNSPrefixMap() <em>XMLNS Prefix Map</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXMLNSPrefixMap()
	 * @generated
	 * @ordered
	 */
	protected EMap<String, String> xMLNSPrefixMap;

	/**
	 * The cached value of the '{@link #getXSISchemaLocation() <em>XSI Schema Location</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXSISchemaLocation()
	 * @generated
	 * @ordered
	 */
	protected EMap<String, String> xSISchemaLocation;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BPMNRootImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Bpmn2Package.eINSTANCE.getBPMNRoot();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureMap getMixed() {
		if (mixed == null) {
			mixed = new BasicFeatureMap(this, Bpmn2Package.BPMN_ROOT__MIXED);
		}
		return mixed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EMap<String, String> getXMLNSPrefixMap() {
		if (xMLNSPrefixMap == null) {
			xMLNSPrefixMap = new EcoreEMap<String,String>(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, this, Bpmn2Package.BPMN_ROOT__XMLNS_PREFIX_MAP);
		}
		return xMLNSPrefixMap;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EMap<String, String> getXSISchemaLocation() {
		if (xSISchemaLocation == null) {
			xSISchemaLocation = new EcoreEMap<String,String>(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, this, Bpmn2Package.BPMN_ROOT__XSI_SCHEMA_LOCATION);
		}
		return xSISchemaLocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Activity getActivity() {
		return (Activity)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Activity(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetActivity(Activity newActivity, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Activity(), newActivity, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setActivity(Activity newActivity) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Activity(), newActivity);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AdHocSubProcess getAdHocSubProcess() {
		return (AdHocSubProcess)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_AdHocSubProcess(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAdHocSubProcess(AdHocSubProcess newAdHocSubProcess, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_AdHocSubProcess(), newAdHocSubProcess, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAdHocSubProcess(AdHocSubProcess newAdHocSubProcess) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_AdHocSubProcess(), newAdHocSubProcess);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FlowElement getFlowElement() {
		return (FlowElement)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_FlowElement(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFlowElement(FlowElement newFlowElement, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_FlowElement(), newFlowElement, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFlowElement(FlowElement newFlowElement) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_FlowElement(), newFlowElement);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Artifact getArtifact() {
		return (Artifact)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Artifact(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetArtifact(Artifact newArtifact, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Artifact(), newArtifact, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setArtifact(Artifact newArtifact) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Artifact(), newArtifact);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Assignment getAssignment() {
		return (Assignment)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Assignment(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAssignment(Assignment newAssignment, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Assignment(), newAssignment, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAssignment(Assignment newAssignment) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Assignment(), newAssignment);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Association getAssociation() {
		return (Association)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Association(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAssociation(Association newAssociation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Association(), newAssociation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAssociation(Association newAssociation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Association(), newAssociation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Auditing getAuditing() {
		return (Auditing)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Auditing(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAuditing(Auditing newAuditing, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Auditing(), newAuditing, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAuditing(Auditing newAuditing) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Auditing(), newAuditing);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BaseElement getBaseElement() {
		return (BaseElement)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_BaseElement(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBaseElement(BaseElement newBaseElement, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_BaseElement(), newBaseElement, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBaseElement(BaseElement newBaseElement) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_BaseElement(), newBaseElement);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BaseElement getBaseElementWithMixedContent() {
		return (BaseElement)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_BaseElementWithMixedContent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBaseElementWithMixedContent(BaseElement newBaseElementWithMixedContent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_BaseElementWithMixedContent(), newBaseElementWithMixedContent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBaseElementWithMixedContent(BaseElement newBaseElementWithMixedContent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_BaseElementWithMixedContent(), newBaseElementWithMixedContent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BoundaryEvent getBoundaryEvent() {
		return (BoundaryEvent)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_BoundaryEvent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBoundaryEvent(BoundaryEvent newBoundaryEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_BoundaryEvent(), newBoundaryEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBoundaryEvent(BoundaryEvent newBoundaryEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_BoundaryEvent(), newBoundaryEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BusinessRuleTask getBusinessRuleTask() {
		return (BusinessRuleTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_BusinessRuleTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBusinessRuleTask(BusinessRuleTask newBusinessRuleTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_BusinessRuleTask(), newBusinessRuleTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBusinessRuleTask(BusinessRuleTask newBusinessRuleTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_BusinessRuleTask(), newBusinessRuleTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CallableElement getCallableElement() {
		return (CallableElement)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CallableElement(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCallableElement(CallableElement newCallableElement, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CallableElement(), newCallableElement, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCallableElement(CallableElement newCallableElement) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CallableElement(), newCallableElement);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CallActivity getCallActivity() {
		return (CallActivity)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CallActivity(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCallActivity(CallActivity newCallActivity, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CallActivity(), newCallActivity, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCallActivity(CallActivity newCallActivity) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CallActivity(), newCallActivity);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CallChoreography getCallChoreography() {
		return (CallChoreography)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CallChoreography(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCallChoreography(CallChoreography newCallChoreography, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CallChoreography(), newCallChoreography, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCallChoreography(CallChoreography newCallChoreography) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CallChoreography(), newCallChoreography);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CallConversation getCallConversation() {
		return (CallConversation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CallConversation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCallConversation(CallConversation newCallConversation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CallConversation(), newCallConversation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCallConversation(CallConversation newCallConversation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CallConversation(), newCallConversation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConversationNode getConversationNode() {
		return (ConversationNode)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationNode(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConversationNode(ConversationNode newConversationNode, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationNode(), newConversationNode, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setConversationNode(ConversationNode newConversationNode) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationNode(), newConversationNode);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CancelEventDefinition getCancelEventDefinition() {
		return (CancelEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CancelEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCancelEventDefinition(CancelEventDefinition newCancelEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CancelEventDefinition(), newCancelEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCancelEventDefinition(CancelEventDefinition newCancelEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CancelEventDefinition(), newCancelEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EventDefinition getEventDefinition() {
		return (EventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_EventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEventDefinition(EventDefinition newEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_EventDefinition(), newEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEventDefinition(EventDefinition newEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_EventDefinition(), newEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RootElement getRootElement() {
		return (RootElement)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_RootElement(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRootElement(RootElement newRootElement, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_RootElement(), newRootElement, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRootElement(RootElement newRootElement) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_RootElement(), newRootElement);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CatchEvent getCatchEvent() {
		return (CatchEvent)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CatchEvent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCatchEvent(CatchEvent newCatchEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CatchEvent(), newCatchEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCatchEvent(CatchEvent newCatchEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CatchEvent(), newCatchEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Category getCategory() {
		return (Category)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Category(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCategory(Category newCategory, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Category(), newCategory, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCategory(Category newCategory) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Category(), newCategory);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CategoryValue getCategoryValue() {
		return (CategoryValue)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CategoryValue(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCategoryValue(CategoryValue newCategoryValue, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CategoryValue(), newCategoryValue, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCategoryValue(CategoryValue newCategoryValue) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CategoryValue(), newCategoryValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Choreography getChoreography() {
		return (Choreography)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Choreography(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetChoreography(Choreography newChoreography, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Choreography(), newChoreography, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setChoreography(Choreography newChoreography) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Choreography(), newChoreography);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collaboration getCollaboration() {
		return (Collaboration)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Collaboration(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCollaboration(Collaboration newCollaboration, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Collaboration(), newCollaboration, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCollaboration(Collaboration newCollaboration) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Collaboration(), newCollaboration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ChoreographyActivity getChoreographyActivity() {
		return (ChoreographyActivity)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ChoreographyActivity(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetChoreographyActivity(ChoreographyActivity newChoreographyActivity, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ChoreographyActivity(), newChoreographyActivity, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setChoreographyActivity(ChoreographyActivity newChoreographyActivity) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ChoreographyActivity(), newChoreographyActivity);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ChoreographyTask getChoreographyTask() {
		return (ChoreographyTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ChoreographyTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetChoreographyTask(ChoreographyTask newChoreographyTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ChoreographyTask(), newChoreographyTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setChoreographyTask(ChoreographyTask newChoreographyTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ChoreographyTask(), newChoreographyTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CompensateEventDefinition getCompensateEventDefinition() {
		return (CompensateEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CompensateEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCompensateEventDefinition(CompensateEventDefinition newCompensateEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CompensateEventDefinition(), newCompensateEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCompensateEventDefinition(CompensateEventDefinition newCompensateEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CompensateEventDefinition(), newCompensateEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComplexBehaviorDefinition getComplexBehaviorDefinition() {
		return (ComplexBehaviorDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ComplexBehaviorDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetComplexBehaviorDefinition(ComplexBehaviorDefinition newComplexBehaviorDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ComplexBehaviorDefinition(), newComplexBehaviorDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setComplexBehaviorDefinition(ComplexBehaviorDefinition newComplexBehaviorDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ComplexBehaviorDefinition(), newComplexBehaviorDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComplexGateway getComplexGateway() {
		return (ComplexGateway)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ComplexGateway(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetComplexGateway(ComplexGateway newComplexGateway, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ComplexGateway(), newComplexGateway, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setComplexGateway(ComplexGateway newComplexGateway) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ComplexGateway(), newComplexGateway);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConditionalEventDefinition getConditionalEventDefinition() {
		return (ConditionalEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ConditionalEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConditionalEventDefinition(ConditionalEventDefinition newConditionalEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ConditionalEventDefinition(), newConditionalEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setConditionalEventDefinition(ConditionalEventDefinition newConditionalEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ConditionalEventDefinition(), newConditionalEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Conversation getConversation() {
		return (Conversation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Conversation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConversation(Conversation newConversation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Conversation(), newConversation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setConversation(Conversation newConversation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Conversation(), newConversation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConversationAssociation getConversationAssociation() {
		return (ConversationAssociation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationAssociation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConversationAssociation(ConversationAssociation newConversationAssociation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationAssociation(), newConversationAssociation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setConversationAssociation(ConversationAssociation newConversationAssociation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationAssociation(), newConversationAssociation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConversationLink getConversationLink() {
		return (ConversationLink)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationLink(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConversationLink(ConversationLink newConversationLink, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationLink(), newConversationLink, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setConversationLink(ConversationLink newConversationLink) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ConversationLink(), newConversationLink);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CorrelationKey getCorrelationKey() {
		return (CorrelationKey)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationKey(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationKey(CorrelationKey newCorrelationKey, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationKey(), newCorrelationKey, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCorrelationKey(CorrelationKey newCorrelationKey) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationKey(), newCorrelationKey);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CorrelationProperty getCorrelationProperty() {
		return (CorrelationProperty)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationProperty(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationProperty(CorrelationProperty newCorrelationProperty, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationProperty(), newCorrelationProperty, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCorrelationProperty(CorrelationProperty newCorrelationProperty) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationProperty(), newCorrelationProperty);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CorrelationPropertyBinding getCorrelationPropertyBinding() {
		return (CorrelationPropertyBinding)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationPropertyBinding(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationPropertyBinding(CorrelationPropertyBinding newCorrelationPropertyBinding, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationPropertyBinding(), newCorrelationPropertyBinding, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCorrelationPropertyBinding(CorrelationPropertyBinding newCorrelationPropertyBinding) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationPropertyBinding(), newCorrelationPropertyBinding);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CorrelationPropertyRetrievalExpression getCorrelationPropertyRetrievalExpression() {
		return (CorrelationPropertyRetrievalExpression)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationPropertyRetrievalExpression(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationPropertyRetrievalExpression(CorrelationPropertyRetrievalExpression newCorrelationPropertyRetrievalExpression, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationPropertyRetrievalExpression(), newCorrelationPropertyRetrievalExpression, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCorrelationPropertyRetrievalExpression(CorrelationPropertyRetrievalExpression newCorrelationPropertyRetrievalExpression) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationPropertyRetrievalExpression(), newCorrelationPropertyRetrievalExpression);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CorrelationSubscription getCorrelationSubscription() {
		return (CorrelationSubscription)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationSubscription(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationSubscription(CorrelationSubscription newCorrelationSubscription, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationSubscription(), newCorrelationSubscription, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCorrelationSubscription(CorrelationSubscription newCorrelationSubscription) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_CorrelationSubscription(), newCorrelationSubscription);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataAssociation getDataAssociation() {
		return (DataAssociation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataAssociation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataAssociation(DataAssociation newDataAssociation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataAssociation(), newDataAssociation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataAssociation(DataAssociation newDataAssociation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataAssociation(), newDataAssociation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataInput getDataInput() {
		return (DataInput)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataInput(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataInput(DataInput newDataInput, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataInput(), newDataInput, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataInput(DataInput newDataInput) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataInput(), newDataInput);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataInputAssociation getDataInputAssociation() {
		return (DataInputAssociation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataInputAssociation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataInputAssociation(DataInputAssociation newDataInputAssociation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataInputAssociation(), newDataInputAssociation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataInputAssociation(DataInputAssociation newDataInputAssociation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataInputAssociation(), newDataInputAssociation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataObject getDataObject() {
		return (DataObject)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataObject(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataObject(DataObject newDataObject, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataObject(), newDataObject, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataObject(DataObject newDataObject) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataObject(), newDataObject);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataObjectReference getDataObjectReference() {
		return (DataObjectReference)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataObjectReference(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataObjectReference(DataObjectReference newDataObjectReference, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataObjectReference(), newDataObjectReference, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataObjectReference(DataObjectReference newDataObjectReference) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataObjectReference(), newDataObjectReference);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataOutput getDataOutput() {
		return (DataOutput)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataOutput(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataOutput(DataOutput newDataOutput, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataOutput(), newDataOutput, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataOutput(DataOutput newDataOutput) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataOutput(), newDataOutput);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataOutputAssociation getDataOutputAssociation() {
		return (DataOutputAssociation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataOutputAssociation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataOutputAssociation(DataOutputAssociation newDataOutputAssociation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataOutputAssociation(), newDataOutputAssociation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataOutputAssociation(DataOutputAssociation newDataOutputAssociation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataOutputAssociation(), newDataOutputAssociation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataState getDataState() {
		return (DataState)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataState(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataState(DataState newDataState, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataState(), newDataState, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataState(DataState newDataState) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataState(), newDataState);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataStore getDataStore() {
		return (DataStore)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataStore(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataStore(DataStore newDataStore, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataStore(), newDataStore, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataStore(DataStore newDataStore) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataStore(), newDataStore);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataStoreReference getDataStoreReference() {
		return (DataStoreReference)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_DataStoreReference(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataStoreReference(DataStoreReference newDataStoreReference, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_DataStoreReference(), newDataStoreReference, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataStoreReference(DataStoreReference newDataStoreReference) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_DataStoreReference(), newDataStoreReference);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Definitions getDefinitions() {
		return (Definitions)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Definitions(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDefinitions(Definitions newDefinitions, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Definitions(), newDefinitions, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefinitions(Definitions newDefinitions) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Definitions(), newDefinitions);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Documentation getDocumentation() {
		return (Documentation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Documentation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDocumentation(Documentation newDocumentation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Documentation(), newDocumentation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDocumentation(Documentation newDocumentation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Documentation(), newDocumentation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EndEvent getEndEvent() {
		return (EndEvent)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_EndEvent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEndEvent(EndEvent newEndEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_EndEvent(), newEndEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEndEvent(EndEvent newEndEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_EndEvent(), newEndEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EndPoint getEndPoint() {
		return (EndPoint)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_EndPoint(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEndPoint(EndPoint newEndPoint, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_EndPoint(), newEndPoint, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEndPoint(EndPoint newEndPoint) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_EndPoint(), newEndPoint);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public org.omg.bpmn.bpmn2.Error getError() {
		return (org.omg.bpmn.bpmn2.Error)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Error(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetError(org.omg.bpmn.bpmn2.Error newError, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Error(), newError, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setError(org.omg.bpmn.bpmn2.Error newError) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Error(), newError);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ErrorEventDefinition getErrorEventDefinition() {
		return (ErrorEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ErrorEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetErrorEventDefinition(ErrorEventDefinition newErrorEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ErrorEventDefinition(), newErrorEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setErrorEventDefinition(ErrorEventDefinition newErrorEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ErrorEventDefinition(), newErrorEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Escalation getEscalation() {
		return (Escalation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Escalation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEscalation(Escalation newEscalation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Escalation(), newEscalation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEscalation(Escalation newEscalation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Escalation(), newEscalation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EscalationEventDefinition getEscalationEventDefinition() {
		return (EscalationEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_EscalationEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEscalationEventDefinition(EscalationEventDefinition newEscalationEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_EscalationEventDefinition(), newEscalationEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEscalationEventDefinition(EscalationEventDefinition newEscalationEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_EscalationEventDefinition(), newEscalationEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Event getEvent() {
		return (Event)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Event(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEvent(Event newEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Event(), newEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEvent(Event newEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Event(), newEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EventBasedGateway getEventBasedGateway() {
		return (EventBasedGateway)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_EventBasedGateway(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEventBasedGateway(EventBasedGateway newEventBasedGateway, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_EventBasedGateway(), newEventBasedGateway, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEventBasedGateway(EventBasedGateway newEventBasedGateway) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_EventBasedGateway(), newEventBasedGateway);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExclusiveGateway getExclusiveGateway() {
		return (ExclusiveGateway)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ExclusiveGateway(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExclusiveGateway(ExclusiveGateway newExclusiveGateway, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ExclusiveGateway(), newExclusiveGateway, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExclusiveGateway(ExclusiveGateway newExclusiveGateway) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ExclusiveGateway(), newExclusiveGateway);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Expression getExpression() {
		return (Expression)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Expression(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExpression(Expression newExpression, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Expression(), newExpression, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExpression(Expression newExpression) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Expression(), newExpression);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Extension getExtension() {
		return (Extension)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Extension(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExtension(Extension newExtension, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Extension(), newExtension, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExtension(Extension newExtension) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Extension(), newExtension);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExtensionAttributeValue getExtensionElements() {
		return (ExtensionAttributeValue)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ExtensionElements(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExtensionElements(ExtensionAttributeValue newExtensionElements, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ExtensionElements(), newExtensionElements, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExtensionElements(ExtensionAttributeValue newExtensionElements) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ExtensionElements(), newExtensionElements);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FlowNode getFlowNode() {
		return (FlowNode)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_FlowNode(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFlowNode(FlowNode newFlowNode, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_FlowNode(), newFlowNode, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFlowNode(FlowNode newFlowNode) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_FlowNode(), newFlowNode);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FormalExpression getFormalExpression() {
		return (FormalExpression)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_FormalExpression(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFormalExpression(FormalExpression newFormalExpression, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_FormalExpression(), newFormalExpression, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFormalExpression(FormalExpression newFormalExpression) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_FormalExpression(), newFormalExpression);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Gateway getGateway() {
		return (Gateway)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Gateway(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGateway(Gateway newGateway, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Gateway(), newGateway, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GlobalBusinessRuleTask getGlobalBusinessRuleTask() {
		return (GlobalBusinessRuleTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalBusinessRuleTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGlobalBusinessRuleTask(GlobalBusinessRuleTask newGlobalBusinessRuleTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalBusinessRuleTask(), newGlobalBusinessRuleTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGlobalBusinessRuleTask(GlobalBusinessRuleTask newGlobalBusinessRuleTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalBusinessRuleTask(), newGlobalBusinessRuleTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GlobalChoreographyTask getGlobalChoreographyTask() {
		return (GlobalChoreographyTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalChoreographyTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGlobalChoreographyTask(GlobalChoreographyTask newGlobalChoreographyTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalChoreographyTask(), newGlobalChoreographyTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGlobalChoreographyTask(GlobalChoreographyTask newGlobalChoreographyTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalChoreographyTask(), newGlobalChoreographyTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GlobalConversation getGlobalConversation() {
		return (GlobalConversation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalConversation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGlobalConversation(GlobalConversation newGlobalConversation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalConversation(), newGlobalConversation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGlobalConversation(GlobalConversation newGlobalConversation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalConversation(), newGlobalConversation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GlobalManualTask getGlobalManualTask() {
		return (GlobalManualTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalManualTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGlobalManualTask(GlobalManualTask newGlobalManualTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalManualTask(), newGlobalManualTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGlobalManualTask(GlobalManualTask newGlobalManualTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalManualTask(), newGlobalManualTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GlobalScriptTask getGlobalScriptTask() {
		return (GlobalScriptTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalScriptTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGlobalScriptTask(GlobalScriptTask newGlobalScriptTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalScriptTask(), newGlobalScriptTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGlobalScriptTask(GlobalScriptTask newGlobalScriptTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalScriptTask(), newGlobalScriptTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GlobalTask getGlobalTask() {
		return (GlobalTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGlobalTask(GlobalTask newGlobalTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalTask(), newGlobalTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGlobalTask(GlobalTask newGlobalTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalTask(), newGlobalTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GlobalUserTask getGlobalUserTask() {
		return (GlobalUserTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalUserTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGlobalUserTask(GlobalUserTask newGlobalUserTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalUserTask(), newGlobalUserTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGlobalUserTask(GlobalUserTask newGlobalUserTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_GlobalUserTask(), newGlobalUserTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Group getGroup() {
		return (Group)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Group(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGroup(Group newGroup, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Group(), newGroup, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGroup(Group newGroup) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Group(), newGroup);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public HumanPerformer getHumanPerformer() {
		return (HumanPerformer)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_HumanPerformer(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetHumanPerformer(HumanPerformer newHumanPerformer, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_HumanPerformer(), newHumanPerformer, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHumanPerformer(HumanPerformer newHumanPerformer) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_HumanPerformer(), newHumanPerformer);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Performer getPerformer() {
		return (Performer)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Performer(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPerformer(Performer newPerformer, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Performer(), newPerformer, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPerformer(Performer newPerformer) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Performer(), newPerformer);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceRole getResourceRole() {
		return (ResourceRole)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceRole(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetResourceRole(ResourceRole newResourceRole, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceRole(), newResourceRole, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResourceRole(ResourceRole newResourceRole) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceRole(), newResourceRole);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ImplicitThrowEvent getImplicitThrowEvent() {
		return (ImplicitThrowEvent)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ImplicitThrowEvent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetImplicitThrowEvent(ImplicitThrowEvent newImplicitThrowEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ImplicitThrowEvent(), newImplicitThrowEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setImplicitThrowEvent(ImplicitThrowEvent newImplicitThrowEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ImplicitThrowEvent(), newImplicitThrowEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Import getImport() {
		return (Import)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Import(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetImport(Import newImport, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Import(), newImport, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setImport(Import newImport) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Import(), newImport);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public InclusiveGateway getInclusiveGateway() {
		return (InclusiveGateway)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_InclusiveGateway(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInclusiveGateway(InclusiveGateway newInclusiveGateway, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_InclusiveGateway(), newInclusiveGateway, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInclusiveGateway(InclusiveGateway newInclusiveGateway) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_InclusiveGateway(), newInclusiveGateway);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public InputSet getInputSet() {
		return (InputSet)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_InputSet(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInputSet(InputSet newInputSet, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_InputSet(), newInputSet, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInputSet(InputSet newInputSet) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_InputSet(), newInputSet);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Interface getInterface() {
		return (Interface)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Interface(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInterface(Interface newInterface, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Interface(), newInterface, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInterface(Interface newInterface) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Interface(), newInterface);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public IntermediateCatchEvent getIntermediateCatchEvent() {
		return (IntermediateCatchEvent)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_IntermediateCatchEvent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIntermediateCatchEvent(IntermediateCatchEvent newIntermediateCatchEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_IntermediateCatchEvent(), newIntermediateCatchEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIntermediateCatchEvent(IntermediateCatchEvent newIntermediateCatchEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_IntermediateCatchEvent(), newIntermediateCatchEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public IntermediateThrowEvent getIntermediateThrowEvent() {
		return (IntermediateThrowEvent)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_IntermediateThrowEvent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIntermediateThrowEvent(IntermediateThrowEvent newIntermediateThrowEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_IntermediateThrowEvent(), newIntermediateThrowEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIntermediateThrowEvent(IntermediateThrowEvent newIntermediateThrowEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_IntermediateThrowEvent(), newIntermediateThrowEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public InputOutputBinding getIoBinding() {
		return (InputOutputBinding)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_IoBinding(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIoBinding(InputOutputBinding newIoBinding, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_IoBinding(), newIoBinding, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIoBinding(InputOutputBinding newIoBinding) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_IoBinding(), newIoBinding);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public InputOutputSpecification getIoSpecification() {
		return (InputOutputSpecification)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_IoSpecification(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIoSpecification(InputOutputSpecification newIoSpecification, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_IoSpecification(), newIoSpecification, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIoSpecification(InputOutputSpecification newIoSpecification) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_IoSpecification(), newIoSpecification);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ItemDefinition getItemDefinition() {
		return (ItemDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ItemDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetItemDefinition(ItemDefinition newItemDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ItemDefinition(), newItemDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setItemDefinition(ItemDefinition newItemDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ItemDefinition(), newItemDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Lane getLane() {
		return (Lane)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Lane(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLane(Lane newLane, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Lane(), newLane, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLane(Lane newLane) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Lane(), newLane);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LaneSet getLaneSet() {
		return (LaneSet)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_LaneSet(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLaneSet(LaneSet newLaneSet, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_LaneSet(), newLaneSet, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLaneSet(LaneSet newLaneSet) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_LaneSet(), newLaneSet);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LinkEventDefinition getLinkEventDefinition() {
		return (LinkEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_LinkEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLinkEventDefinition(LinkEventDefinition newLinkEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_LinkEventDefinition(), newLinkEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLinkEventDefinition(LinkEventDefinition newLinkEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_LinkEventDefinition(), newLinkEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LoopCharacteristics getLoopCharacteristics() {
		return (LoopCharacteristics)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_LoopCharacteristics(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLoopCharacteristics(LoopCharacteristics newLoopCharacteristics, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_LoopCharacteristics(), newLoopCharacteristics, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLoopCharacteristics(LoopCharacteristics newLoopCharacteristics) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_LoopCharacteristics(), newLoopCharacteristics);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ManualTask getManualTask() {
		return (ManualTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ManualTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetManualTask(ManualTask newManualTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ManualTask(), newManualTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setManualTask(ManualTask newManualTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ManualTask(), newManualTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Message getMessage() {
		return (Message)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Message(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMessage(Message newMessage, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Message(), newMessage, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMessage(Message newMessage) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Message(), newMessage);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MessageEventDefinition getMessageEventDefinition() {
		return (MessageEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMessageEventDefinition(MessageEventDefinition newMessageEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageEventDefinition(), newMessageEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMessageEventDefinition(MessageEventDefinition newMessageEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageEventDefinition(), newMessageEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MessageFlow getMessageFlow() {
		return (MessageFlow)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageFlow(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMessageFlow(MessageFlow newMessageFlow, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageFlow(), newMessageFlow, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMessageFlow(MessageFlow newMessageFlow) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageFlow(), newMessageFlow);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MessageFlowAssociation getMessageFlowAssociation() {
		return (MessageFlowAssociation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageFlowAssociation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMessageFlowAssociation(MessageFlowAssociation newMessageFlowAssociation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageFlowAssociation(), newMessageFlowAssociation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMessageFlowAssociation(MessageFlowAssociation newMessageFlowAssociation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_MessageFlowAssociation(), newMessageFlowAssociation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Monitoring getMonitoring() {
		return (Monitoring)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Monitoring(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMonitoring(Monitoring newMonitoring, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Monitoring(), newMonitoring, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMonitoring(Monitoring newMonitoring) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Monitoring(), newMonitoring);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MultiInstanceLoopCharacteristics getMultiInstanceLoopCharacteristics() {
		return (MultiInstanceLoopCharacteristics)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_MultiInstanceLoopCharacteristics(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMultiInstanceLoopCharacteristics(MultiInstanceLoopCharacteristics newMultiInstanceLoopCharacteristics, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_MultiInstanceLoopCharacteristics(), newMultiInstanceLoopCharacteristics, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMultiInstanceLoopCharacteristics(MultiInstanceLoopCharacteristics newMultiInstanceLoopCharacteristics) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_MultiInstanceLoopCharacteristics(), newMultiInstanceLoopCharacteristics);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Operation getOperation() {
		return (Operation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Operation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOperation(Operation newOperation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Operation(), newOperation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOperation(Operation newOperation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Operation(), newOperation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OutputSet getOutputSet() {
		return (OutputSet)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_OutputSet(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOutputSet(OutputSet newOutputSet, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_OutputSet(), newOutputSet, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOutputSet(OutputSet newOutputSet) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_OutputSet(), newOutputSet);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ParallelGateway getParallelGateway() {
		return (ParallelGateway)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ParallelGateway(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParallelGateway(ParallelGateway newParallelGateway, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ParallelGateway(), newParallelGateway, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParallelGateway(ParallelGateway newParallelGateway) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ParallelGateway(), newParallelGateway);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Participant getParticipant() {
		return (Participant)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Participant(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParticipant(Participant newParticipant, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Participant(), newParticipant, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParticipant(Participant newParticipant) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Participant(), newParticipant);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ParticipantAssociation getParticipantAssociation() {
		return (ParticipantAssociation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ParticipantAssociation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParticipantAssociation(ParticipantAssociation newParticipantAssociation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ParticipantAssociation(), newParticipantAssociation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParticipantAssociation(ParticipantAssociation newParticipantAssociation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ParticipantAssociation(), newParticipantAssociation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ParticipantMultiplicity getParticipantMultiplicity() {
		return (ParticipantMultiplicity)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ParticipantMultiplicity(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParticipantMultiplicity(ParticipantMultiplicity newParticipantMultiplicity, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ParticipantMultiplicity(), newParticipantMultiplicity, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParticipantMultiplicity(ParticipantMultiplicity newParticipantMultiplicity) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ParticipantMultiplicity(), newParticipantMultiplicity);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PartnerEntity getPartnerEntity() {
		return (PartnerEntity)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_PartnerEntity(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPartnerEntity(PartnerEntity newPartnerEntity, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_PartnerEntity(), newPartnerEntity, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPartnerEntity(PartnerEntity newPartnerEntity) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_PartnerEntity(), newPartnerEntity);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PartnerRole getPartnerRole() {
		return (PartnerRole)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_PartnerRole(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPartnerRole(PartnerRole newPartnerRole, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_PartnerRole(), newPartnerRole, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPartnerRole(PartnerRole newPartnerRole) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_PartnerRole(), newPartnerRole);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PotentialOwner getPotentialOwner() {
		return (PotentialOwner)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_PotentialOwner(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPotentialOwner(PotentialOwner newPotentialOwner, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_PotentialOwner(), newPotentialOwner, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPotentialOwner(PotentialOwner newPotentialOwner) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_PotentialOwner(), newPotentialOwner);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public org.omg.bpmn.bpmn2.Process getProcess() {
		return (org.omg.bpmn.bpmn2.Process)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Process(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcess(org.omg.bpmn.bpmn2.Process newProcess, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Process(), newProcess, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setProcess(org.omg.bpmn.bpmn2.Process newProcess) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Process(), newProcess);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Property getProperty() {
		return (Property)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Property(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProperty(Property newProperty, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Property(), newProperty, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setProperty(Property newProperty) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Property(), newProperty);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ReceiveTask getReceiveTask() {
		return (ReceiveTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ReceiveTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetReceiveTask(ReceiveTask newReceiveTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ReceiveTask(), newReceiveTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setReceiveTask(ReceiveTask newReceiveTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ReceiveTask(), newReceiveTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Relationship getRelationship() {
		return (Relationship)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Relationship(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRelationship(Relationship newRelationship, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Relationship(), newRelationship, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRelationship(Relationship newRelationship) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Relationship(), newRelationship);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Rendering getRendering() {
		return (Rendering)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Rendering(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRendering(Rendering newRendering, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Rendering(), newRendering, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRendering(Rendering newRendering) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Rendering(), newRendering);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Resource getResource() {
		return (Resource)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Resource(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetResource(Resource newResource, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Resource(), newResource, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResource(Resource newResource) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Resource(), newResource);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceAssignmentExpression getResourceAssignmentExpression() {
		return (ResourceAssignmentExpression)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceAssignmentExpression(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetResourceAssignmentExpression(ResourceAssignmentExpression newResourceAssignmentExpression, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceAssignmentExpression(), newResourceAssignmentExpression, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResourceAssignmentExpression(ResourceAssignmentExpression newResourceAssignmentExpression) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceAssignmentExpression(), newResourceAssignmentExpression);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceParameter getResourceParameter() {
		return (ResourceParameter)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceParameter(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetResourceParameter(ResourceParameter newResourceParameter, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceParameter(), newResourceParameter, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResourceParameter(ResourceParameter newResourceParameter) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceParameter(), newResourceParameter);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceParameterBinding getResourceParameterBinding() {
		return (ResourceParameterBinding)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceParameterBinding(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetResourceParameterBinding(ResourceParameterBinding newResourceParameterBinding, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceParameterBinding(), newResourceParameterBinding, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResourceParameterBinding(ResourceParameterBinding newResourceParameterBinding) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ResourceParameterBinding(), newResourceParameterBinding);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject getScript() {
		return (EObject)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Script(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetScript(EObject newScript, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Script(), newScript, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setScript(EObject newScript) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Script(), newScript);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ScriptTask getScriptTask() {
		return (ScriptTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ScriptTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetScriptTask(ScriptTask newScriptTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ScriptTask(), newScriptTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setScriptTask(ScriptTask newScriptTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ScriptTask(), newScriptTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SendTask getSendTask() {
		return (SendTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_SendTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSendTask(SendTask newSendTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_SendTask(), newSendTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSendTask(SendTask newSendTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_SendTask(), newSendTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SequenceFlow getSequenceFlow() {
		return (SequenceFlow)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_SequenceFlow(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSequenceFlow(SequenceFlow newSequenceFlow, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_SequenceFlow(), newSequenceFlow, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSequenceFlow(SequenceFlow newSequenceFlow) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_SequenceFlow(), newSequenceFlow);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ServiceTask getServiceTask() {
		return (ServiceTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ServiceTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetServiceTask(ServiceTask newServiceTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ServiceTask(), newServiceTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setServiceTask(ServiceTask newServiceTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ServiceTask(), newServiceTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Signal getSignal() {
		return (Signal)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Signal(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSignal(Signal newSignal, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Signal(), newSignal, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSignal(Signal newSignal) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Signal(), newSignal);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SignalEventDefinition getSignalEventDefinition() {
		return (SignalEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_SignalEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSignalEventDefinition(SignalEventDefinition newSignalEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_SignalEventDefinition(), newSignalEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSignalEventDefinition(SignalEventDefinition newSignalEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_SignalEventDefinition(), newSignalEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StandardLoopCharacteristics getStandardLoopCharacteristics() {
		return (StandardLoopCharacteristics)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_StandardLoopCharacteristics(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStandardLoopCharacteristics(StandardLoopCharacteristics newStandardLoopCharacteristics, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_StandardLoopCharacteristics(), newStandardLoopCharacteristics, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStandardLoopCharacteristics(StandardLoopCharacteristics newStandardLoopCharacteristics) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_StandardLoopCharacteristics(), newStandardLoopCharacteristics);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StartEvent getStartEvent() {
		return (StartEvent)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_StartEvent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStartEvent(StartEvent newStartEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_StartEvent(), newStartEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStartEvent(StartEvent newStartEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_StartEvent(), newStartEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SubChoreography getSubChoreography() {
		return (SubChoreography)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_SubChoreography(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSubChoreography(SubChoreography newSubChoreography, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_SubChoreography(), newSubChoreography, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSubChoreography(SubChoreography newSubChoreography) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_SubChoreography(), newSubChoreography);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SubConversation getSubConversation() {
		return (SubConversation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_SubConversation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSubConversation(SubConversation newSubConversation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_SubConversation(), newSubConversation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSubConversation(SubConversation newSubConversation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_SubConversation(), newSubConversation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SubProcess getSubProcess() {
		return (SubProcess)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_SubProcess(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSubProcess(SubProcess newSubProcess, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_SubProcess(), newSubProcess, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSubProcess(SubProcess newSubProcess) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_SubProcess(), newSubProcess);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Task getTask() {
		return (Task)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Task(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTask(Task newTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Task(), newTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTask(Task newTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Task(), newTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TerminateEventDefinition getTerminateEventDefinition() {
		return (TerminateEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_TerminateEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTerminateEventDefinition(TerminateEventDefinition newTerminateEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_TerminateEventDefinition(), newTerminateEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTerminateEventDefinition(TerminateEventDefinition newTerminateEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_TerminateEventDefinition(), newTerminateEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject getText() {
		return (EObject)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Text(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetText(EObject newText, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Text(), newText, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setText(EObject newText) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Text(), newText);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TextAnnotation getTextAnnotation() {
		return (TextAnnotation)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_TextAnnotation(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTextAnnotation(TextAnnotation newTextAnnotation, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_TextAnnotation(), newTextAnnotation, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTextAnnotation(TextAnnotation newTextAnnotation) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_TextAnnotation(), newTextAnnotation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ThrowEvent getThrowEvent() {
		return (ThrowEvent)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_ThrowEvent(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetThrowEvent(ThrowEvent newThrowEvent, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_ThrowEvent(), newThrowEvent, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setThrowEvent(ThrowEvent newThrowEvent) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_ThrowEvent(), newThrowEvent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TimerEventDefinition getTimerEventDefinition() {
		return (TimerEventDefinition)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_TimerEventDefinition(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTimerEventDefinition(TimerEventDefinition newTimerEventDefinition, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_TimerEventDefinition(), newTimerEventDefinition, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimerEventDefinition(TimerEventDefinition newTimerEventDefinition) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_TimerEventDefinition(), newTimerEventDefinition);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Transaction getTransaction() {
		return (Transaction)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_Transaction(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTransaction(Transaction newTransaction, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_Transaction(), newTransaction, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTransaction(Transaction newTransaction) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_Transaction(), newTransaction);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public UserTask getUserTask() {
		return (UserTask)getMixed().get(Bpmn2Package.eINSTANCE.getBPMNRoot_UserTask(), true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUserTask(UserTask newUserTask, NotificationChain msgs) {
		return ((FeatureMap.Internal)getMixed()).basicAdd(Bpmn2Package.eINSTANCE.getBPMNRoot_UserTask(), newUserTask, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUserTask(UserTask newUserTask) {
		((FeatureMap.Internal)getMixed()).set(Bpmn2Package.eINSTANCE.getBPMNRoot_UserTask(), newUserTask);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Bpmn2Package.BPMN_ROOT__MIXED:
				return ((InternalEList<?>)getMixed()).basicRemove(otherEnd, msgs);
			case Bpmn2Package.BPMN_ROOT__XMLNS_PREFIX_MAP:
				return ((InternalEList<?>)getXMLNSPrefixMap()).basicRemove(otherEnd, msgs);
			case Bpmn2Package.BPMN_ROOT__XSI_SCHEMA_LOCATION:
				return ((InternalEList<?>)getXSISchemaLocation()).basicRemove(otherEnd, msgs);
			case Bpmn2Package.BPMN_ROOT__ACTIVITY:
				return basicSetActivity(null, msgs);
			case Bpmn2Package.BPMN_ROOT__AD_HOC_SUB_PROCESS:
				return basicSetAdHocSubProcess(null, msgs);
			case Bpmn2Package.BPMN_ROOT__FLOW_ELEMENT:
				return basicSetFlowElement(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ARTIFACT:
				return basicSetArtifact(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ASSIGNMENT:
				return basicSetAssignment(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ASSOCIATION:
				return basicSetAssociation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__AUDITING:
				return basicSetAuditing(null, msgs);
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT:
				return basicSetBaseElement(null, msgs);
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT_WITH_MIXED_CONTENT:
				return basicSetBaseElementWithMixedContent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__BOUNDARY_EVENT:
				return basicSetBoundaryEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__BUSINESS_RULE_TASK:
				return basicSetBusinessRuleTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CALLABLE_ELEMENT:
				return basicSetCallableElement(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CALL_ACTIVITY:
				return basicSetCallActivity(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CALL_CHOREOGRAPHY:
				return basicSetCallChoreography(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CALL_CONVERSATION:
				return basicSetCallConversation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_NODE:
				return basicSetConversationNode(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CANCEL_EVENT_DEFINITION:
				return basicSetCancelEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__EVENT_DEFINITION:
				return basicSetEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ROOT_ELEMENT:
				return basicSetRootElement(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CATCH_EVENT:
				return basicSetCatchEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CATEGORY:
				return basicSetCategory(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CATEGORY_VALUE:
				return basicSetCategoryValue(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY:
				return basicSetChoreography(null, msgs);
			case Bpmn2Package.BPMN_ROOT__COLLABORATION:
				return basicSetCollaboration(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_ACTIVITY:
				return basicSetChoreographyActivity(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_TASK:
				return basicSetChoreographyTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__COMPENSATE_EVENT_DEFINITION:
				return basicSetCompensateEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__COMPLEX_BEHAVIOR_DEFINITION:
				return basicSetComplexBehaviorDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__COMPLEX_GATEWAY:
				return basicSetComplexGateway(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CONDITIONAL_EVENT_DEFINITION:
				return basicSetConditionalEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CONVERSATION:
				return basicSetConversation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_ASSOCIATION:
				return basicSetConversationAssociation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_LINK:
				return basicSetConversationLink(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CORRELATION_KEY:
				return basicSetCorrelationKey(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY:
				return basicSetCorrelationProperty(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_BINDING:
				return basicSetCorrelationPropertyBinding(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_RETRIEVAL_EXPRESSION:
				return basicSetCorrelationPropertyRetrievalExpression(null, msgs);
			case Bpmn2Package.BPMN_ROOT__CORRELATION_SUBSCRIPTION:
				return basicSetCorrelationSubscription(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_ASSOCIATION:
				return basicSetDataAssociation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT:
				return basicSetDataInput(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT_ASSOCIATION:
				return basicSetDataInputAssociation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT:
				return basicSetDataObject(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT_REFERENCE:
				return basicSetDataObjectReference(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT:
				return basicSetDataOutput(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT_ASSOCIATION:
				return basicSetDataOutputAssociation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_STATE:
				return basicSetDataState(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_STORE:
				return basicSetDataStore(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DATA_STORE_REFERENCE:
				return basicSetDataStoreReference(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DEFINITIONS:
				return basicSetDefinitions(null, msgs);
			case Bpmn2Package.BPMN_ROOT__DOCUMENTATION:
				return basicSetDocumentation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__END_EVENT:
				return basicSetEndEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__END_POINT:
				return basicSetEndPoint(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ERROR:
				return basicSetError(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ERROR_EVENT_DEFINITION:
				return basicSetErrorEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ESCALATION:
				return basicSetEscalation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ESCALATION_EVENT_DEFINITION:
				return basicSetEscalationEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__EVENT:
				return basicSetEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__EVENT_BASED_GATEWAY:
				return basicSetEventBasedGateway(null, msgs);
			case Bpmn2Package.BPMN_ROOT__EXCLUSIVE_GATEWAY:
				return basicSetExclusiveGateway(null, msgs);
			case Bpmn2Package.BPMN_ROOT__EXPRESSION:
				return basicSetExpression(null, msgs);
			case Bpmn2Package.BPMN_ROOT__EXTENSION:
				return basicSetExtension(null, msgs);
			case Bpmn2Package.BPMN_ROOT__EXTENSION_ELEMENTS:
				return basicSetExtensionElements(null, msgs);
			case Bpmn2Package.BPMN_ROOT__FLOW_NODE:
				return basicSetFlowNode(null, msgs);
			case Bpmn2Package.BPMN_ROOT__FORMAL_EXPRESSION:
				return basicSetFormalExpression(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GATEWAY:
				return basicSetGateway(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GLOBAL_BUSINESS_RULE_TASK:
				return basicSetGlobalBusinessRuleTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CHOREOGRAPHY_TASK:
				return basicSetGlobalChoreographyTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CONVERSATION:
				return basicSetGlobalConversation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GLOBAL_MANUAL_TASK:
				return basicSetGlobalManualTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GLOBAL_SCRIPT_TASK:
				return basicSetGlobalScriptTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GLOBAL_TASK:
				return basicSetGlobalTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GLOBAL_USER_TASK:
				return basicSetGlobalUserTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__GROUP:
				return basicSetGroup(null, msgs);
			case Bpmn2Package.BPMN_ROOT__HUMAN_PERFORMER:
				return basicSetHumanPerformer(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PERFORMER:
				return basicSetPerformer(null, msgs);
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ROLE:
				return basicSetResourceRole(null, msgs);
			case Bpmn2Package.BPMN_ROOT__IMPLICIT_THROW_EVENT:
				return basicSetImplicitThrowEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__IMPORT:
				return basicSetImport(null, msgs);
			case Bpmn2Package.BPMN_ROOT__INCLUSIVE_GATEWAY:
				return basicSetInclusiveGateway(null, msgs);
			case Bpmn2Package.BPMN_ROOT__INPUT_SET:
				return basicSetInputSet(null, msgs);
			case Bpmn2Package.BPMN_ROOT__INTERFACE:
				return basicSetInterface(null, msgs);
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_CATCH_EVENT:
				return basicSetIntermediateCatchEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_THROW_EVENT:
				return basicSetIntermediateThrowEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__IO_BINDING:
				return basicSetIoBinding(null, msgs);
			case Bpmn2Package.BPMN_ROOT__IO_SPECIFICATION:
				return basicSetIoSpecification(null, msgs);
			case Bpmn2Package.BPMN_ROOT__ITEM_DEFINITION:
				return basicSetItemDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__LANE:
				return basicSetLane(null, msgs);
			case Bpmn2Package.BPMN_ROOT__LANE_SET:
				return basicSetLaneSet(null, msgs);
			case Bpmn2Package.BPMN_ROOT__LINK_EVENT_DEFINITION:
				return basicSetLinkEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__LOOP_CHARACTERISTICS:
				return basicSetLoopCharacteristics(null, msgs);
			case Bpmn2Package.BPMN_ROOT__MANUAL_TASK:
				return basicSetManualTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__MESSAGE:
				return basicSetMessage(null, msgs);
			case Bpmn2Package.BPMN_ROOT__MESSAGE_EVENT_DEFINITION:
				return basicSetMessageEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW:
				return basicSetMessageFlow(null, msgs);
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW_ASSOCIATION:
				return basicSetMessageFlowAssociation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__MONITORING:
				return basicSetMonitoring(null, msgs);
			case Bpmn2Package.BPMN_ROOT__MULTI_INSTANCE_LOOP_CHARACTERISTICS:
				return basicSetMultiInstanceLoopCharacteristics(null, msgs);
			case Bpmn2Package.BPMN_ROOT__OPERATION:
				return basicSetOperation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__OUTPUT_SET:
				return basicSetOutputSet(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PARALLEL_GATEWAY:
				return basicSetParallelGateway(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT:
				return basicSetParticipant(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_ASSOCIATION:
				return basicSetParticipantAssociation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_MULTIPLICITY:
				return basicSetParticipantMultiplicity(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PARTNER_ENTITY:
				return basicSetPartnerEntity(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PARTNER_ROLE:
				return basicSetPartnerRole(null, msgs);
			case Bpmn2Package.BPMN_ROOT__POTENTIAL_OWNER:
				return basicSetPotentialOwner(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PROCESS:
				return basicSetProcess(null, msgs);
			case Bpmn2Package.BPMN_ROOT__PROPERTY:
				return basicSetProperty(null, msgs);
			case Bpmn2Package.BPMN_ROOT__RECEIVE_TASK:
				return basicSetReceiveTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__RELATIONSHIP:
				return basicSetRelationship(null, msgs);
			case Bpmn2Package.BPMN_ROOT__RENDERING:
				return basicSetRendering(null, msgs);
			case Bpmn2Package.BPMN_ROOT__RESOURCE:
				return basicSetResource(null, msgs);
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ASSIGNMENT_EXPRESSION:
				return basicSetResourceAssignmentExpression(null, msgs);
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER:
				return basicSetResourceParameter(null, msgs);
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER_BINDING:
				return basicSetResourceParameterBinding(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SCRIPT:
				return basicSetScript(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SCRIPT_TASK:
				return basicSetScriptTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SEND_TASK:
				return basicSetSendTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SEQUENCE_FLOW:
				return basicSetSequenceFlow(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SERVICE_TASK:
				return basicSetServiceTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SIGNAL:
				return basicSetSignal(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SIGNAL_EVENT_DEFINITION:
				return basicSetSignalEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__STANDARD_LOOP_CHARACTERISTICS:
				return basicSetStandardLoopCharacteristics(null, msgs);
			case Bpmn2Package.BPMN_ROOT__START_EVENT:
				return basicSetStartEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SUB_CHOREOGRAPHY:
				return basicSetSubChoreography(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SUB_CONVERSATION:
				return basicSetSubConversation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__SUB_PROCESS:
				return basicSetSubProcess(null, msgs);
			case Bpmn2Package.BPMN_ROOT__TASK:
				return basicSetTask(null, msgs);
			case Bpmn2Package.BPMN_ROOT__TERMINATE_EVENT_DEFINITION:
				return basicSetTerminateEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__TEXT:
				return basicSetText(null, msgs);
			case Bpmn2Package.BPMN_ROOT__TEXT_ANNOTATION:
				return basicSetTextAnnotation(null, msgs);
			case Bpmn2Package.BPMN_ROOT__THROW_EVENT:
				return basicSetThrowEvent(null, msgs);
			case Bpmn2Package.BPMN_ROOT__TIMER_EVENT_DEFINITION:
				return basicSetTimerEventDefinition(null, msgs);
			case Bpmn2Package.BPMN_ROOT__TRANSACTION:
				return basicSetTransaction(null, msgs);
			case Bpmn2Package.BPMN_ROOT__USER_TASK:
				return basicSetUserTask(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Bpmn2Package.BPMN_ROOT__MIXED:
				if (coreType) return getMixed();
				return ((FeatureMap.Internal)getMixed()).getWrapper();
			case Bpmn2Package.BPMN_ROOT__XMLNS_PREFIX_MAP:
				if (coreType) return getXMLNSPrefixMap();
				else return getXMLNSPrefixMap().map();
			case Bpmn2Package.BPMN_ROOT__XSI_SCHEMA_LOCATION:
				if (coreType) return getXSISchemaLocation();
				else return getXSISchemaLocation().map();
			case Bpmn2Package.BPMN_ROOT__ACTIVITY:
				return getActivity();
			case Bpmn2Package.BPMN_ROOT__AD_HOC_SUB_PROCESS:
				return getAdHocSubProcess();
			case Bpmn2Package.BPMN_ROOT__FLOW_ELEMENT:
				return getFlowElement();
			case Bpmn2Package.BPMN_ROOT__ARTIFACT:
				return getArtifact();
			case Bpmn2Package.BPMN_ROOT__ASSIGNMENT:
				return getAssignment();
			case Bpmn2Package.BPMN_ROOT__ASSOCIATION:
				return getAssociation();
			case Bpmn2Package.BPMN_ROOT__AUDITING:
				return getAuditing();
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT:
				return getBaseElement();
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT_WITH_MIXED_CONTENT:
				return getBaseElementWithMixedContent();
			case Bpmn2Package.BPMN_ROOT__BOUNDARY_EVENT:
				return getBoundaryEvent();
			case Bpmn2Package.BPMN_ROOT__BUSINESS_RULE_TASK:
				return getBusinessRuleTask();
			case Bpmn2Package.BPMN_ROOT__CALLABLE_ELEMENT:
				return getCallableElement();
			case Bpmn2Package.BPMN_ROOT__CALL_ACTIVITY:
				return getCallActivity();
			case Bpmn2Package.BPMN_ROOT__CALL_CHOREOGRAPHY:
				return getCallChoreography();
			case Bpmn2Package.BPMN_ROOT__CALL_CONVERSATION:
				return getCallConversation();
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_NODE:
				return getConversationNode();
			case Bpmn2Package.BPMN_ROOT__CANCEL_EVENT_DEFINITION:
				return getCancelEventDefinition();
			case Bpmn2Package.BPMN_ROOT__EVENT_DEFINITION:
				return getEventDefinition();
			case Bpmn2Package.BPMN_ROOT__ROOT_ELEMENT:
				return getRootElement();
			case Bpmn2Package.BPMN_ROOT__CATCH_EVENT:
				return getCatchEvent();
			case Bpmn2Package.BPMN_ROOT__CATEGORY:
				return getCategory();
			case Bpmn2Package.BPMN_ROOT__CATEGORY_VALUE:
				return getCategoryValue();
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY:
				return getChoreography();
			case Bpmn2Package.BPMN_ROOT__COLLABORATION:
				return getCollaboration();
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_ACTIVITY:
				return getChoreographyActivity();
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_TASK:
				return getChoreographyTask();
			case Bpmn2Package.BPMN_ROOT__COMPENSATE_EVENT_DEFINITION:
				return getCompensateEventDefinition();
			case Bpmn2Package.BPMN_ROOT__COMPLEX_BEHAVIOR_DEFINITION:
				return getComplexBehaviorDefinition();
			case Bpmn2Package.BPMN_ROOT__COMPLEX_GATEWAY:
				return getComplexGateway();
			case Bpmn2Package.BPMN_ROOT__CONDITIONAL_EVENT_DEFINITION:
				return getConditionalEventDefinition();
			case Bpmn2Package.BPMN_ROOT__CONVERSATION:
				return getConversation();
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_ASSOCIATION:
				return getConversationAssociation();
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_LINK:
				return getConversationLink();
			case Bpmn2Package.BPMN_ROOT__CORRELATION_KEY:
				return getCorrelationKey();
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY:
				return getCorrelationProperty();
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_BINDING:
				return getCorrelationPropertyBinding();
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_RETRIEVAL_EXPRESSION:
				return getCorrelationPropertyRetrievalExpression();
			case Bpmn2Package.BPMN_ROOT__CORRELATION_SUBSCRIPTION:
				return getCorrelationSubscription();
			case Bpmn2Package.BPMN_ROOT__DATA_ASSOCIATION:
				return getDataAssociation();
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT:
				return getDataInput();
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT_ASSOCIATION:
				return getDataInputAssociation();
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT:
				return getDataObject();
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT_REFERENCE:
				return getDataObjectReference();
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT:
				return getDataOutput();
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT_ASSOCIATION:
				return getDataOutputAssociation();
			case Bpmn2Package.BPMN_ROOT__DATA_STATE:
				return getDataState();
			case Bpmn2Package.BPMN_ROOT__DATA_STORE:
				return getDataStore();
			case Bpmn2Package.BPMN_ROOT__DATA_STORE_REFERENCE:
				return getDataStoreReference();
			case Bpmn2Package.BPMN_ROOT__DEFINITIONS:
				return getDefinitions();
			case Bpmn2Package.BPMN_ROOT__DOCUMENTATION:
				return getDocumentation();
			case Bpmn2Package.BPMN_ROOT__END_EVENT:
				return getEndEvent();
			case Bpmn2Package.BPMN_ROOT__END_POINT:
				return getEndPoint();
			case Bpmn2Package.BPMN_ROOT__ERROR:
				return getError();
			case Bpmn2Package.BPMN_ROOT__ERROR_EVENT_DEFINITION:
				return getErrorEventDefinition();
			case Bpmn2Package.BPMN_ROOT__ESCALATION:
				return getEscalation();
			case Bpmn2Package.BPMN_ROOT__ESCALATION_EVENT_DEFINITION:
				return getEscalationEventDefinition();
			case Bpmn2Package.BPMN_ROOT__EVENT:
				return getEvent();
			case Bpmn2Package.BPMN_ROOT__EVENT_BASED_GATEWAY:
				return getEventBasedGateway();
			case Bpmn2Package.BPMN_ROOT__EXCLUSIVE_GATEWAY:
				return getExclusiveGateway();
			case Bpmn2Package.BPMN_ROOT__EXPRESSION:
				return getExpression();
			case Bpmn2Package.BPMN_ROOT__EXTENSION:
				return getExtension();
			case Bpmn2Package.BPMN_ROOT__EXTENSION_ELEMENTS:
				return getExtensionElements();
			case Bpmn2Package.BPMN_ROOT__FLOW_NODE:
				return getFlowNode();
			case Bpmn2Package.BPMN_ROOT__FORMAL_EXPRESSION:
				return getFormalExpression();
			case Bpmn2Package.BPMN_ROOT__GATEWAY:
				return getGateway();
			case Bpmn2Package.BPMN_ROOT__GLOBAL_BUSINESS_RULE_TASK:
				return getGlobalBusinessRuleTask();
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CHOREOGRAPHY_TASK:
				return getGlobalChoreographyTask();
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CONVERSATION:
				return getGlobalConversation();
			case Bpmn2Package.BPMN_ROOT__GLOBAL_MANUAL_TASK:
				return getGlobalManualTask();
			case Bpmn2Package.BPMN_ROOT__GLOBAL_SCRIPT_TASK:
				return getGlobalScriptTask();
			case Bpmn2Package.BPMN_ROOT__GLOBAL_TASK:
				return getGlobalTask();
			case Bpmn2Package.BPMN_ROOT__GLOBAL_USER_TASK:
				return getGlobalUserTask();
			case Bpmn2Package.BPMN_ROOT__GROUP:
				return getGroup();
			case Bpmn2Package.BPMN_ROOT__HUMAN_PERFORMER:
				return getHumanPerformer();
			case Bpmn2Package.BPMN_ROOT__PERFORMER:
				return getPerformer();
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ROLE:
				return getResourceRole();
			case Bpmn2Package.BPMN_ROOT__IMPLICIT_THROW_EVENT:
				return getImplicitThrowEvent();
			case Bpmn2Package.BPMN_ROOT__IMPORT:
				return getImport();
			case Bpmn2Package.BPMN_ROOT__INCLUSIVE_GATEWAY:
				return getInclusiveGateway();
			case Bpmn2Package.BPMN_ROOT__INPUT_SET:
				return getInputSet();
			case Bpmn2Package.BPMN_ROOT__INTERFACE:
				return getInterface();
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_CATCH_EVENT:
				return getIntermediateCatchEvent();
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_THROW_EVENT:
				return getIntermediateThrowEvent();
			case Bpmn2Package.BPMN_ROOT__IO_BINDING:
				return getIoBinding();
			case Bpmn2Package.BPMN_ROOT__IO_SPECIFICATION:
				return getIoSpecification();
			case Bpmn2Package.BPMN_ROOT__ITEM_DEFINITION:
				return getItemDefinition();
			case Bpmn2Package.BPMN_ROOT__LANE:
				return getLane();
			case Bpmn2Package.BPMN_ROOT__LANE_SET:
				return getLaneSet();
			case Bpmn2Package.BPMN_ROOT__LINK_EVENT_DEFINITION:
				return getLinkEventDefinition();
			case Bpmn2Package.BPMN_ROOT__LOOP_CHARACTERISTICS:
				return getLoopCharacteristics();
			case Bpmn2Package.BPMN_ROOT__MANUAL_TASK:
				return getManualTask();
			case Bpmn2Package.BPMN_ROOT__MESSAGE:
				return getMessage();
			case Bpmn2Package.BPMN_ROOT__MESSAGE_EVENT_DEFINITION:
				return getMessageEventDefinition();
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW:
				return getMessageFlow();
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW_ASSOCIATION:
				return getMessageFlowAssociation();
			case Bpmn2Package.BPMN_ROOT__MONITORING:
				return getMonitoring();
			case Bpmn2Package.BPMN_ROOT__MULTI_INSTANCE_LOOP_CHARACTERISTICS:
				return getMultiInstanceLoopCharacteristics();
			case Bpmn2Package.BPMN_ROOT__OPERATION:
				return getOperation();
			case Bpmn2Package.BPMN_ROOT__OUTPUT_SET:
				return getOutputSet();
			case Bpmn2Package.BPMN_ROOT__PARALLEL_GATEWAY:
				return getParallelGateway();
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT:
				return getParticipant();
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_ASSOCIATION:
				return getParticipantAssociation();
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_MULTIPLICITY:
				return getParticipantMultiplicity();
			case Bpmn2Package.BPMN_ROOT__PARTNER_ENTITY:
				return getPartnerEntity();
			case Bpmn2Package.BPMN_ROOT__PARTNER_ROLE:
				return getPartnerRole();
			case Bpmn2Package.BPMN_ROOT__POTENTIAL_OWNER:
				return getPotentialOwner();
			case Bpmn2Package.BPMN_ROOT__PROCESS:
				return getProcess();
			case Bpmn2Package.BPMN_ROOT__PROPERTY:
				return getProperty();
			case Bpmn2Package.BPMN_ROOT__RECEIVE_TASK:
				return getReceiveTask();
			case Bpmn2Package.BPMN_ROOT__RELATIONSHIP:
				return getRelationship();
			case Bpmn2Package.BPMN_ROOT__RENDERING:
				return getRendering();
			case Bpmn2Package.BPMN_ROOT__RESOURCE:
				return getResource();
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ASSIGNMENT_EXPRESSION:
				return getResourceAssignmentExpression();
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER:
				return getResourceParameter();
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER_BINDING:
				return getResourceParameterBinding();
			case Bpmn2Package.BPMN_ROOT__SCRIPT:
				return getScript();
			case Bpmn2Package.BPMN_ROOT__SCRIPT_TASK:
				return getScriptTask();
			case Bpmn2Package.BPMN_ROOT__SEND_TASK:
				return getSendTask();
			case Bpmn2Package.BPMN_ROOT__SEQUENCE_FLOW:
				return getSequenceFlow();
			case Bpmn2Package.BPMN_ROOT__SERVICE_TASK:
				return getServiceTask();
			case Bpmn2Package.BPMN_ROOT__SIGNAL:
				return getSignal();
			case Bpmn2Package.BPMN_ROOT__SIGNAL_EVENT_DEFINITION:
				return getSignalEventDefinition();
			case Bpmn2Package.BPMN_ROOT__STANDARD_LOOP_CHARACTERISTICS:
				return getStandardLoopCharacteristics();
			case Bpmn2Package.BPMN_ROOT__START_EVENT:
				return getStartEvent();
			case Bpmn2Package.BPMN_ROOT__SUB_CHOREOGRAPHY:
				return getSubChoreography();
			case Bpmn2Package.BPMN_ROOT__SUB_CONVERSATION:
				return getSubConversation();
			case Bpmn2Package.BPMN_ROOT__SUB_PROCESS:
				return getSubProcess();
			case Bpmn2Package.BPMN_ROOT__TASK:
				return getTask();
			case Bpmn2Package.BPMN_ROOT__TERMINATE_EVENT_DEFINITION:
				return getTerminateEventDefinition();
			case Bpmn2Package.BPMN_ROOT__TEXT:
				return getText();
			case Bpmn2Package.BPMN_ROOT__TEXT_ANNOTATION:
				return getTextAnnotation();
			case Bpmn2Package.BPMN_ROOT__THROW_EVENT:
				return getThrowEvent();
			case Bpmn2Package.BPMN_ROOT__TIMER_EVENT_DEFINITION:
				return getTimerEventDefinition();
			case Bpmn2Package.BPMN_ROOT__TRANSACTION:
				return getTransaction();
			case Bpmn2Package.BPMN_ROOT__USER_TASK:
				return getUserTask();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Bpmn2Package.BPMN_ROOT__MIXED:
				((FeatureMap.Internal)getMixed()).set(newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__XMLNS_PREFIX_MAP:
				((EStructuralFeature.Setting)getXMLNSPrefixMap()).set(newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__XSI_SCHEMA_LOCATION:
				((EStructuralFeature.Setting)getXSISchemaLocation()).set(newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ACTIVITY:
				setActivity((Activity)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__AD_HOC_SUB_PROCESS:
				setAdHocSubProcess((AdHocSubProcess)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__FLOW_ELEMENT:
				setFlowElement((FlowElement)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ARTIFACT:
				setArtifact((Artifact)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ASSIGNMENT:
				setAssignment((Assignment)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ASSOCIATION:
				setAssociation((Association)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__AUDITING:
				setAuditing((Auditing)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT:
				setBaseElement((BaseElement)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT_WITH_MIXED_CONTENT:
				setBaseElementWithMixedContent((BaseElement)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__BOUNDARY_EVENT:
				setBoundaryEvent((BoundaryEvent)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__BUSINESS_RULE_TASK:
				setBusinessRuleTask((BusinessRuleTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CALLABLE_ELEMENT:
				setCallableElement((CallableElement)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CALL_ACTIVITY:
				setCallActivity((CallActivity)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CALL_CHOREOGRAPHY:
				setCallChoreography((CallChoreography)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CALL_CONVERSATION:
				setCallConversation((CallConversation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_NODE:
				setConversationNode((ConversationNode)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CANCEL_EVENT_DEFINITION:
				setCancelEventDefinition((CancelEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__EVENT_DEFINITION:
				setEventDefinition((EventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ROOT_ELEMENT:
				setRootElement((RootElement)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CATCH_EVENT:
				setCatchEvent((CatchEvent)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CATEGORY:
				setCategory((Category)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CATEGORY_VALUE:
				setCategoryValue((CategoryValue)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY:
				setChoreography((Choreography)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__COLLABORATION:
				setCollaboration((Collaboration)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_ACTIVITY:
				setChoreographyActivity((ChoreographyActivity)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_TASK:
				setChoreographyTask((ChoreographyTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__COMPENSATE_EVENT_DEFINITION:
				setCompensateEventDefinition((CompensateEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__COMPLEX_BEHAVIOR_DEFINITION:
				setComplexBehaviorDefinition((ComplexBehaviorDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__COMPLEX_GATEWAY:
				setComplexGateway((ComplexGateway)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CONDITIONAL_EVENT_DEFINITION:
				setConditionalEventDefinition((ConditionalEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION:
				setConversation((Conversation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_ASSOCIATION:
				setConversationAssociation((ConversationAssociation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_LINK:
				setConversationLink((ConversationLink)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_KEY:
				setCorrelationKey((CorrelationKey)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY:
				setCorrelationProperty((CorrelationProperty)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_BINDING:
				setCorrelationPropertyBinding((CorrelationPropertyBinding)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_RETRIEVAL_EXPRESSION:
				setCorrelationPropertyRetrievalExpression((CorrelationPropertyRetrievalExpression)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_SUBSCRIPTION:
				setCorrelationSubscription((CorrelationSubscription)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_ASSOCIATION:
				setDataAssociation((DataAssociation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT:
				setDataInput((DataInput)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT_ASSOCIATION:
				setDataInputAssociation((DataInputAssociation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT:
				setDataObject((DataObject)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT_REFERENCE:
				setDataObjectReference((DataObjectReference)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT:
				setDataOutput((DataOutput)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT_ASSOCIATION:
				setDataOutputAssociation((DataOutputAssociation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_STATE:
				setDataState((DataState)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_STORE:
				setDataStore((DataStore)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_STORE_REFERENCE:
				setDataStoreReference((DataStoreReference)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DEFINITIONS:
				setDefinitions((Definitions)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__DOCUMENTATION:
				setDocumentation((Documentation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__END_EVENT:
				setEndEvent((EndEvent)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__END_POINT:
				setEndPoint((EndPoint)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ERROR:
				setError((org.omg.bpmn.bpmn2.Error)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ERROR_EVENT_DEFINITION:
				setErrorEventDefinition((ErrorEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ESCALATION:
				setEscalation((Escalation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ESCALATION_EVENT_DEFINITION:
				setEscalationEventDefinition((EscalationEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__EVENT:
				setEvent((Event)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__EVENT_BASED_GATEWAY:
				setEventBasedGateway((EventBasedGateway)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__EXCLUSIVE_GATEWAY:
				setExclusiveGateway((ExclusiveGateway)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__EXPRESSION:
				setExpression((Expression)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__EXTENSION:
				setExtension((Extension)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__EXTENSION_ELEMENTS:
				setExtensionElements((ExtensionAttributeValue)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__FLOW_NODE:
				setFlowNode((FlowNode)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__FORMAL_EXPRESSION:
				setFormalExpression((FormalExpression)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_BUSINESS_RULE_TASK:
				setGlobalBusinessRuleTask((GlobalBusinessRuleTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CHOREOGRAPHY_TASK:
				setGlobalChoreographyTask((GlobalChoreographyTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CONVERSATION:
				setGlobalConversation((GlobalConversation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_MANUAL_TASK:
				setGlobalManualTask((GlobalManualTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_SCRIPT_TASK:
				setGlobalScriptTask((GlobalScriptTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_TASK:
				setGlobalTask((GlobalTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_USER_TASK:
				setGlobalUserTask((GlobalUserTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__GROUP:
				setGroup((Group)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__HUMAN_PERFORMER:
				setHumanPerformer((HumanPerformer)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PERFORMER:
				setPerformer((Performer)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ROLE:
				setResourceRole((ResourceRole)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__IMPLICIT_THROW_EVENT:
				setImplicitThrowEvent((ImplicitThrowEvent)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__IMPORT:
				setImport((Import)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__INCLUSIVE_GATEWAY:
				setInclusiveGateway((InclusiveGateway)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__INPUT_SET:
				setInputSet((InputSet)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__INTERFACE:
				setInterface((Interface)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_CATCH_EVENT:
				setIntermediateCatchEvent((IntermediateCatchEvent)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_THROW_EVENT:
				setIntermediateThrowEvent((IntermediateThrowEvent)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__IO_BINDING:
				setIoBinding((InputOutputBinding)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__IO_SPECIFICATION:
				setIoSpecification((InputOutputSpecification)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__ITEM_DEFINITION:
				setItemDefinition((ItemDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__LANE:
				setLane((Lane)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__LANE_SET:
				setLaneSet((LaneSet)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__LINK_EVENT_DEFINITION:
				setLinkEventDefinition((LinkEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__LOOP_CHARACTERISTICS:
				setLoopCharacteristics((LoopCharacteristics)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__MANUAL_TASK:
				setManualTask((ManualTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__MESSAGE:
				setMessage((Message)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_EVENT_DEFINITION:
				setMessageEventDefinition((MessageEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW:
				setMessageFlow((MessageFlow)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW_ASSOCIATION:
				setMessageFlowAssociation((MessageFlowAssociation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__MONITORING:
				setMonitoring((Monitoring)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__MULTI_INSTANCE_LOOP_CHARACTERISTICS:
				setMultiInstanceLoopCharacteristics((MultiInstanceLoopCharacteristics)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__OPERATION:
				setOperation((Operation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__OUTPUT_SET:
				setOutputSet((OutputSet)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PARALLEL_GATEWAY:
				setParallelGateway((ParallelGateway)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT:
				setParticipant((Participant)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_ASSOCIATION:
				setParticipantAssociation((ParticipantAssociation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_MULTIPLICITY:
				setParticipantMultiplicity((ParticipantMultiplicity)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTNER_ENTITY:
				setPartnerEntity((PartnerEntity)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTNER_ROLE:
				setPartnerRole((PartnerRole)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__POTENTIAL_OWNER:
				setPotentialOwner((PotentialOwner)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PROCESS:
				setProcess((org.omg.bpmn.bpmn2.Process)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__PROPERTY:
				setProperty((Property)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__RECEIVE_TASK:
				setReceiveTask((ReceiveTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__RELATIONSHIP:
				setRelationship((Relationship)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__RENDERING:
				setRendering((Rendering)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE:
				setResource((Resource)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ASSIGNMENT_EXPRESSION:
				setResourceAssignmentExpression((ResourceAssignmentExpression)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER:
				setResourceParameter((ResourceParameter)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER_BINDING:
				setResourceParameterBinding((ResourceParameterBinding)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SCRIPT:
				setScript((EObject)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SCRIPT_TASK:
				setScriptTask((ScriptTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SEND_TASK:
				setSendTask((SendTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SEQUENCE_FLOW:
				setSequenceFlow((SequenceFlow)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SERVICE_TASK:
				setServiceTask((ServiceTask)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SIGNAL:
				setSignal((Signal)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SIGNAL_EVENT_DEFINITION:
				setSignalEventDefinition((SignalEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__STANDARD_LOOP_CHARACTERISTICS:
				setStandardLoopCharacteristics((StandardLoopCharacteristics)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__START_EVENT:
				setStartEvent((StartEvent)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SUB_CHOREOGRAPHY:
				setSubChoreography((SubChoreography)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SUB_CONVERSATION:
				setSubConversation((SubConversation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__SUB_PROCESS:
				setSubProcess((SubProcess)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__TASK:
				setTask((Task)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__TERMINATE_EVENT_DEFINITION:
				setTerminateEventDefinition((TerminateEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__TEXT:
				setText((EObject)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__TEXT_ANNOTATION:
				setTextAnnotation((TextAnnotation)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__THROW_EVENT:
				setThrowEvent((ThrowEvent)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__TIMER_EVENT_DEFINITION:
				setTimerEventDefinition((TimerEventDefinition)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__TRANSACTION:
				setTransaction((Transaction)newValue);
				return;
			case Bpmn2Package.BPMN_ROOT__USER_TASK:
				setUserTask((UserTask)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Bpmn2Package.BPMN_ROOT__MIXED:
				getMixed().clear();
				return;
			case Bpmn2Package.BPMN_ROOT__XMLNS_PREFIX_MAP:
				getXMLNSPrefixMap().clear();
				return;
			case Bpmn2Package.BPMN_ROOT__XSI_SCHEMA_LOCATION:
				getXSISchemaLocation().clear();
				return;
			case Bpmn2Package.BPMN_ROOT__ACTIVITY:
				setActivity((Activity)null);
				return;
			case Bpmn2Package.BPMN_ROOT__AD_HOC_SUB_PROCESS:
				setAdHocSubProcess((AdHocSubProcess)null);
				return;
			case Bpmn2Package.BPMN_ROOT__FLOW_ELEMENT:
				setFlowElement((FlowElement)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ARTIFACT:
				setArtifact((Artifact)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ASSIGNMENT:
				setAssignment((Assignment)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ASSOCIATION:
				setAssociation((Association)null);
				return;
			case Bpmn2Package.BPMN_ROOT__AUDITING:
				setAuditing((Auditing)null);
				return;
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT:
				setBaseElement((BaseElement)null);
				return;
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT_WITH_MIXED_CONTENT:
				setBaseElementWithMixedContent((BaseElement)null);
				return;
			case Bpmn2Package.BPMN_ROOT__BOUNDARY_EVENT:
				setBoundaryEvent((BoundaryEvent)null);
				return;
			case Bpmn2Package.BPMN_ROOT__BUSINESS_RULE_TASK:
				setBusinessRuleTask((BusinessRuleTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CALLABLE_ELEMENT:
				setCallableElement((CallableElement)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CALL_ACTIVITY:
				setCallActivity((CallActivity)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CALL_CHOREOGRAPHY:
				setCallChoreography((CallChoreography)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CALL_CONVERSATION:
				setCallConversation((CallConversation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_NODE:
				setConversationNode((ConversationNode)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CANCEL_EVENT_DEFINITION:
				setCancelEventDefinition((CancelEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__EVENT_DEFINITION:
				setEventDefinition((EventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ROOT_ELEMENT:
				setRootElement((RootElement)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CATCH_EVENT:
				setCatchEvent((CatchEvent)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CATEGORY:
				setCategory((Category)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CATEGORY_VALUE:
				setCategoryValue((CategoryValue)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY:
				setChoreography((Choreography)null);
				return;
			case Bpmn2Package.BPMN_ROOT__COLLABORATION:
				setCollaboration((Collaboration)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_ACTIVITY:
				setChoreographyActivity((ChoreographyActivity)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_TASK:
				setChoreographyTask((ChoreographyTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__COMPENSATE_EVENT_DEFINITION:
				setCompensateEventDefinition((CompensateEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__COMPLEX_BEHAVIOR_DEFINITION:
				setComplexBehaviorDefinition((ComplexBehaviorDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__COMPLEX_GATEWAY:
				setComplexGateway((ComplexGateway)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CONDITIONAL_EVENT_DEFINITION:
				setConditionalEventDefinition((ConditionalEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION:
				setConversation((Conversation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_ASSOCIATION:
				setConversationAssociation((ConversationAssociation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_LINK:
				setConversationLink((ConversationLink)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_KEY:
				setCorrelationKey((CorrelationKey)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY:
				setCorrelationProperty((CorrelationProperty)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_BINDING:
				setCorrelationPropertyBinding((CorrelationPropertyBinding)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_RETRIEVAL_EXPRESSION:
				setCorrelationPropertyRetrievalExpression((CorrelationPropertyRetrievalExpression)null);
				return;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_SUBSCRIPTION:
				setCorrelationSubscription((CorrelationSubscription)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_ASSOCIATION:
				setDataAssociation((DataAssociation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT:
				setDataInput((DataInput)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT_ASSOCIATION:
				setDataInputAssociation((DataInputAssociation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT:
				setDataObject((DataObject)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT_REFERENCE:
				setDataObjectReference((DataObjectReference)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT:
				setDataOutput((DataOutput)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT_ASSOCIATION:
				setDataOutputAssociation((DataOutputAssociation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_STATE:
				setDataState((DataState)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_STORE:
				setDataStore((DataStore)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DATA_STORE_REFERENCE:
				setDataStoreReference((DataStoreReference)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DEFINITIONS:
				setDefinitions((Definitions)null);
				return;
			case Bpmn2Package.BPMN_ROOT__DOCUMENTATION:
				setDocumentation((Documentation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__END_EVENT:
				setEndEvent((EndEvent)null);
				return;
			case Bpmn2Package.BPMN_ROOT__END_POINT:
				setEndPoint((EndPoint)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ERROR:
				setError((org.omg.bpmn.bpmn2.Error)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ERROR_EVENT_DEFINITION:
				setErrorEventDefinition((ErrorEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ESCALATION:
				setEscalation((Escalation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ESCALATION_EVENT_DEFINITION:
				setEscalationEventDefinition((EscalationEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__EVENT:
				setEvent((Event)null);
				return;
			case Bpmn2Package.BPMN_ROOT__EVENT_BASED_GATEWAY:
				setEventBasedGateway((EventBasedGateway)null);
				return;
			case Bpmn2Package.BPMN_ROOT__EXCLUSIVE_GATEWAY:
				setExclusiveGateway((ExclusiveGateway)null);
				return;
			case Bpmn2Package.BPMN_ROOT__EXPRESSION:
				setExpression((Expression)null);
				return;
			case Bpmn2Package.BPMN_ROOT__EXTENSION:
				setExtension((Extension)null);
				return;
			case Bpmn2Package.BPMN_ROOT__EXTENSION_ELEMENTS:
				setExtensionElements((ExtensionAttributeValue)null);
				return;
			case Bpmn2Package.BPMN_ROOT__FLOW_NODE:
				setFlowNode((FlowNode)null);
				return;
			case Bpmn2Package.BPMN_ROOT__FORMAL_EXPRESSION:
				setFormalExpression((FormalExpression)null);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_BUSINESS_RULE_TASK:
				setGlobalBusinessRuleTask((GlobalBusinessRuleTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CHOREOGRAPHY_TASK:
				setGlobalChoreographyTask((GlobalChoreographyTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CONVERSATION:
				setGlobalConversation((GlobalConversation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_MANUAL_TASK:
				setGlobalManualTask((GlobalManualTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_SCRIPT_TASK:
				setGlobalScriptTask((GlobalScriptTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_TASK:
				setGlobalTask((GlobalTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_USER_TASK:
				setGlobalUserTask((GlobalUserTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__GROUP:
				setGroup((Group)null);
				return;
			case Bpmn2Package.BPMN_ROOT__HUMAN_PERFORMER:
				setHumanPerformer((HumanPerformer)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PERFORMER:
				setPerformer((Performer)null);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ROLE:
				setResourceRole((ResourceRole)null);
				return;
			case Bpmn2Package.BPMN_ROOT__IMPLICIT_THROW_EVENT:
				setImplicitThrowEvent((ImplicitThrowEvent)null);
				return;
			case Bpmn2Package.BPMN_ROOT__IMPORT:
				setImport((Import)null);
				return;
			case Bpmn2Package.BPMN_ROOT__INCLUSIVE_GATEWAY:
				setInclusiveGateway((InclusiveGateway)null);
				return;
			case Bpmn2Package.BPMN_ROOT__INPUT_SET:
				setInputSet((InputSet)null);
				return;
			case Bpmn2Package.BPMN_ROOT__INTERFACE:
				setInterface((Interface)null);
				return;
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_CATCH_EVENT:
				setIntermediateCatchEvent((IntermediateCatchEvent)null);
				return;
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_THROW_EVENT:
				setIntermediateThrowEvent((IntermediateThrowEvent)null);
				return;
			case Bpmn2Package.BPMN_ROOT__IO_BINDING:
				setIoBinding((InputOutputBinding)null);
				return;
			case Bpmn2Package.BPMN_ROOT__IO_SPECIFICATION:
				setIoSpecification((InputOutputSpecification)null);
				return;
			case Bpmn2Package.BPMN_ROOT__ITEM_DEFINITION:
				setItemDefinition((ItemDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__LANE:
				setLane((Lane)null);
				return;
			case Bpmn2Package.BPMN_ROOT__LANE_SET:
				setLaneSet((LaneSet)null);
				return;
			case Bpmn2Package.BPMN_ROOT__LINK_EVENT_DEFINITION:
				setLinkEventDefinition((LinkEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__LOOP_CHARACTERISTICS:
				setLoopCharacteristics((LoopCharacteristics)null);
				return;
			case Bpmn2Package.BPMN_ROOT__MANUAL_TASK:
				setManualTask((ManualTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__MESSAGE:
				setMessage((Message)null);
				return;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_EVENT_DEFINITION:
				setMessageEventDefinition((MessageEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW:
				setMessageFlow((MessageFlow)null);
				return;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW_ASSOCIATION:
				setMessageFlowAssociation((MessageFlowAssociation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__MONITORING:
				setMonitoring((Monitoring)null);
				return;
			case Bpmn2Package.BPMN_ROOT__MULTI_INSTANCE_LOOP_CHARACTERISTICS:
				setMultiInstanceLoopCharacteristics((MultiInstanceLoopCharacteristics)null);
				return;
			case Bpmn2Package.BPMN_ROOT__OPERATION:
				setOperation((Operation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__OUTPUT_SET:
				setOutputSet((OutputSet)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PARALLEL_GATEWAY:
				setParallelGateway((ParallelGateway)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT:
				setParticipant((Participant)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_ASSOCIATION:
				setParticipantAssociation((ParticipantAssociation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_MULTIPLICITY:
				setParticipantMultiplicity((ParticipantMultiplicity)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTNER_ENTITY:
				setPartnerEntity((PartnerEntity)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PARTNER_ROLE:
				setPartnerRole((PartnerRole)null);
				return;
			case Bpmn2Package.BPMN_ROOT__POTENTIAL_OWNER:
				setPotentialOwner((PotentialOwner)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PROCESS:
				setProcess((org.omg.bpmn.bpmn2.Process)null);
				return;
			case Bpmn2Package.BPMN_ROOT__PROPERTY:
				setProperty((Property)null);
				return;
			case Bpmn2Package.BPMN_ROOT__RECEIVE_TASK:
				setReceiveTask((ReceiveTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__RELATIONSHIP:
				setRelationship((Relationship)null);
				return;
			case Bpmn2Package.BPMN_ROOT__RENDERING:
				setRendering((Rendering)null);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE:
				setResource((Resource)null);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ASSIGNMENT_EXPRESSION:
				setResourceAssignmentExpression((ResourceAssignmentExpression)null);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER:
				setResourceParameter((ResourceParameter)null);
				return;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER_BINDING:
				setResourceParameterBinding((ResourceParameterBinding)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SCRIPT:
				setScript((EObject)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SCRIPT_TASK:
				setScriptTask((ScriptTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SEND_TASK:
				setSendTask((SendTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SEQUENCE_FLOW:
				setSequenceFlow((SequenceFlow)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SERVICE_TASK:
				setServiceTask((ServiceTask)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SIGNAL:
				setSignal((Signal)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SIGNAL_EVENT_DEFINITION:
				setSignalEventDefinition((SignalEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__STANDARD_LOOP_CHARACTERISTICS:
				setStandardLoopCharacteristics((StandardLoopCharacteristics)null);
				return;
			case Bpmn2Package.BPMN_ROOT__START_EVENT:
				setStartEvent((StartEvent)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SUB_CHOREOGRAPHY:
				setSubChoreography((SubChoreography)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SUB_CONVERSATION:
				setSubConversation((SubConversation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__SUB_PROCESS:
				setSubProcess((SubProcess)null);
				return;
			case Bpmn2Package.BPMN_ROOT__TASK:
				setTask((Task)null);
				return;
			case Bpmn2Package.BPMN_ROOT__TERMINATE_EVENT_DEFINITION:
				setTerminateEventDefinition((TerminateEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__TEXT:
				setText((EObject)null);
				return;
			case Bpmn2Package.BPMN_ROOT__TEXT_ANNOTATION:
				setTextAnnotation((TextAnnotation)null);
				return;
			case Bpmn2Package.BPMN_ROOT__THROW_EVENT:
				setThrowEvent((ThrowEvent)null);
				return;
			case Bpmn2Package.BPMN_ROOT__TIMER_EVENT_DEFINITION:
				setTimerEventDefinition((TimerEventDefinition)null);
				return;
			case Bpmn2Package.BPMN_ROOT__TRANSACTION:
				setTransaction((Transaction)null);
				return;
			case Bpmn2Package.BPMN_ROOT__USER_TASK:
				setUserTask((UserTask)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Bpmn2Package.BPMN_ROOT__MIXED:
				return mixed != null && !mixed.isEmpty();
			case Bpmn2Package.BPMN_ROOT__XMLNS_PREFIX_MAP:
				return xMLNSPrefixMap != null && !xMLNSPrefixMap.isEmpty();
			case Bpmn2Package.BPMN_ROOT__XSI_SCHEMA_LOCATION:
				return xSISchemaLocation != null && !xSISchemaLocation.isEmpty();
			case Bpmn2Package.BPMN_ROOT__ACTIVITY:
				return getActivity() != null;
			case Bpmn2Package.BPMN_ROOT__AD_HOC_SUB_PROCESS:
				return getAdHocSubProcess() != null;
			case Bpmn2Package.BPMN_ROOT__FLOW_ELEMENT:
				return getFlowElement() != null;
			case Bpmn2Package.BPMN_ROOT__ARTIFACT:
				return getArtifact() != null;
			case Bpmn2Package.BPMN_ROOT__ASSIGNMENT:
				return getAssignment() != null;
			case Bpmn2Package.BPMN_ROOT__ASSOCIATION:
				return getAssociation() != null;
			case Bpmn2Package.BPMN_ROOT__AUDITING:
				return getAuditing() != null;
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT:
				return getBaseElement() != null;
			case Bpmn2Package.BPMN_ROOT__BASE_ELEMENT_WITH_MIXED_CONTENT:
				return getBaseElementWithMixedContent() != null;
			case Bpmn2Package.BPMN_ROOT__BOUNDARY_EVENT:
				return getBoundaryEvent() != null;
			case Bpmn2Package.BPMN_ROOT__BUSINESS_RULE_TASK:
				return getBusinessRuleTask() != null;
			case Bpmn2Package.BPMN_ROOT__CALLABLE_ELEMENT:
				return getCallableElement() != null;
			case Bpmn2Package.BPMN_ROOT__CALL_ACTIVITY:
				return getCallActivity() != null;
			case Bpmn2Package.BPMN_ROOT__CALL_CHOREOGRAPHY:
				return getCallChoreography() != null;
			case Bpmn2Package.BPMN_ROOT__CALL_CONVERSATION:
				return getCallConversation() != null;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_NODE:
				return getConversationNode() != null;
			case Bpmn2Package.BPMN_ROOT__CANCEL_EVENT_DEFINITION:
				return getCancelEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__EVENT_DEFINITION:
				return getEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__ROOT_ELEMENT:
				return getRootElement() != null;
			case Bpmn2Package.BPMN_ROOT__CATCH_EVENT:
				return getCatchEvent() != null;
			case Bpmn2Package.BPMN_ROOT__CATEGORY:
				return getCategory() != null;
			case Bpmn2Package.BPMN_ROOT__CATEGORY_VALUE:
				return getCategoryValue() != null;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY:
				return getChoreography() != null;
			case Bpmn2Package.BPMN_ROOT__COLLABORATION:
				return getCollaboration() != null;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_ACTIVITY:
				return getChoreographyActivity() != null;
			case Bpmn2Package.BPMN_ROOT__CHOREOGRAPHY_TASK:
				return getChoreographyTask() != null;
			case Bpmn2Package.BPMN_ROOT__COMPENSATE_EVENT_DEFINITION:
				return getCompensateEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__COMPLEX_BEHAVIOR_DEFINITION:
				return getComplexBehaviorDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__COMPLEX_GATEWAY:
				return getComplexGateway() != null;
			case Bpmn2Package.BPMN_ROOT__CONDITIONAL_EVENT_DEFINITION:
				return getConditionalEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION:
				return getConversation() != null;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_ASSOCIATION:
				return getConversationAssociation() != null;
			case Bpmn2Package.BPMN_ROOT__CONVERSATION_LINK:
				return getConversationLink() != null;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_KEY:
				return getCorrelationKey() != null;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY:
				return getCorrelationProperty() != null;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_BINDING:
				return getCorrelationPropertyBinding() != null;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_PROPERTY_RETRIEVAL_EXPRESSION:
				return getCorrelationPropertyRetrievalExpression() != null;
			case Bpmn2Package.BPMN_ROOT__CORRELATION_SUBSCRIPTION:
				return getCorrelationSubscription() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_ASSOCIATION:
				return getDataAssociation() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT:
				return getDataInput() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_INPUT_ASSOCIATION:
				return getDataInputAssociation() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT:
				return getDataObject() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_OBJECT_REFERENCE:
				return getDataObjectReference() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT:
				return getDataOutput() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_OUTPUT_ASSOCIATION:
				return getDataOutputAssociation() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_STATE:
				return getDataState() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_STORE:
				return getDataStore() != null;
			case Bpmn2Package.BPMN_ROOT__DATA_STORE_REFERENCE:
				return getDataStoreReference() != null;
			case Bpmn2Package.BPMN_ROOT__DEFINITIONS:
				return getDefinitions() != null;
			case Bpmn2Package.BPMN_ROOT__DOCUMENTATION:
				return getDocumentation() != null;
			case Bpmn2Package.BPMN_ROOT__END_EVENT:
				return getEndEvent() != null;
			case Bpmn2Package.BPMN_ROOT__END_POINT:
				return getEndPoint() != null;
			case Bpmn2Package.BPMN_ROOT__ERROR:
				return getError() != null;
			case Bpmn2Package.BPMN_ROOT__ERROR_EVENT_DEFINITION:
				return getErrorEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__ESCALATION:
				return getEscalation() != null;
			case Bpmn2Package.BPMN_ROOT__ESCALATION_EVENT_DEFINITION:
				return getEscalationEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__EVENT:
				return getEvent() != null;
			case Bpmn2Package.BPMN_ROOT__EVENT_BASED_GATEWAY:
				return getEventBasedGateway() != null;
			case Bpmn2Package.BPMN_ROOT__EXCLUSIVE_GATEWAY:
				return getExclusiveGateway() != null;
			case Bpmn2Package.BPMN_ROOT__EXPRESSION:
				return getExpression() != null;
			case Bpmn2Package.BPMN_ROOT__EXTENSION:
				return getExtension() != null;
			case Bpmn2Package.BPMN_ROOT__EXTENSION_ELEMENTS:
				return getExtensionElements() != null;
			case Bpmn2Package.BPMN_ROOT__FLOW_NODE:
				return getFlowNode() != null;
			case Bpmn2Package.BPMN_ROOT__FORMAL_EXPRESSION:
				return getFormalExpression() != null;
			case Bpmn2Package.BPMN_ROOT__GATEWAY:
				return getGateway() != null;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_BUSINESS_RULE_TASK:
				return getGlobalBusinessRuleTask() != null;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CHOREOGRAPHY_TASK:
				return getGlobalChoreographyTask() != null;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_CONVERSATION:
				return getGlobalConversation() != null;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_MANUAL_TASK:
				return getGlobalManualTask() != null;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_SCRIPT_TASK:
				return getGlobalScriptTask() != null;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_TASK:
				return getGlobalTask() != null;
			case Bpmn2Package.BPMN_ROOT__GLOBAL_USER_TASK:
				return getGlobalUserTask() != null;
			case Bpmn2Package.BPMN_ROOT__GROUP:
				return getGroup() != null;
			case Bpmn2Package.BPMN_ROOT__HUMAN_PERFORMER:
				return getHumanPerformer() != null;
			case Bpmn2Package.BPMN_ROOT__PERFORMER:
				return getPerformer() != null;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ROLE:
				return getResourceRole() != null;
			case Bpmn2Package.BPMN_ROOT__IMPLICIT_THROW_EVENT:
				return getImplicitThrowEvent() != null;
			case Bpmn2Package.BPMN_ROOT__IMPORT:
				return getImport() != null;
			case Bpmn2Package.BPMN_ROOT__INCLUSIVE_GATEWAY:
				return getInclusiveGateway() != null;
			case Bpmn2Package.BPMN_ROOT__INPUT_SET:
				return getInputSet() != null;
			case Bpmn2Package.BPMN_ROOT__INTERFACE:
				return getInterface() != null;
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_CATCH_EVENT:
				return getIntermediateCatchEvent() != null;
			case Bpmn2Package.BPMN_ROOT__INTERMEDIATE_THROW_EVENT:
				return getIntermediateThrowEvent() != null;
			case Bpmn2Package.BPMN_ROOT__IO_BINDING:
				return getIoBinding() != null;
			case Bpmn2Package.BPMN_ROOT__IO_SPECIFICATION:
				return getIoSpecification() != null;
			case Bpmn2Package.BPMN_ROOT__ITEM_DEFINITION:
				return getItemDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__LANE:
				return getLane() != null;
			case Bpmn2Package.BPMN_ROOT__LANE_SET:
				return getLaneSet() != null;
			case Bpmn2Package.BPMN_ROOT__LINK_EVENT_DEFINITION:
				return getLinkEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__LOOP_CHARACTERISTICS:
				return getLoopCharacteristics() != null;
			case Bpmn2Package.BPMN_ROOT__MANUAL_TASK:
				return getManualTask() != null;
			case Bpmn2Package.BPMN_ROOT__MESSAGE:
				return getMessage() != null;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_EVENT_DEFINITION:
				return getMessageEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW:
				return getMessageFlow() != null;
			case Bpmn2Package.BPMN_ROOT__MESSAGE_FLOW_ASSOCIATION:
				return getMessageFlowAssociation() != null;
			case Bpmn2Package.BPMN_ROOT__MONITORING:
				return getMonitoring() != null;
			case Bpmn2Package.BPMN_ROOT__MULTI_INSTANCE_LOOP_CHARACTERISTICS:
				return getMultiInstanceLoopCharacteristics() != null;
			case Bpmn2Package.BPMN_ROOT__OPERATION:
				return getOperation() != null;
			case Bpmn2Package.BPMN_ROOT__OUTPUT_SET:
				return getOutputSet() != null;
			case Bpmn2Package.BPMN_ROOT__PARALLEL_GATEWAY:
				return getParallelGateway() != null;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT:
				return getParticipant() != null;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_ASSOCIATION:
				return getParticipantAssociation() != null;
			case Bpmn2Package.BPMN_ROOT__PARTICIPANT_MULTIPLICITY:
				return getParticipantMultiplicity() != null;
			case Bpmn2Package.BPMN_ROOT__PARTNER_ENTITY:
				return getPartnerEntity() != null;
			case Bpmn2Package.BPMN_ROOT__PARTNER_ROLE:
				return getPartnerRole() != null;
			case Bpmn2Package.BPMN_ROOT__POTENTIAL_OWNER:
				return getPotentialOwner() != null;
			case Bpmn2Package.BPMN_ROOT__PROCESS:
				return getProcess() != null;
			case Bpmn2Package.BPMN_ROOT__PROPERTY:
				return getProperty() != null;
			case Bpmn2Package.BPMN_ROOT__RECEIVE_TASK:
				return getReceiveTask() != null;
			case Bpmn2Package.BPMN_ROOT__RELATIONSHIP:
				return getRelationship() != null;
			case Bpmn2Package.BPMN_ROOT__RENDERING:
				return getRendering() != null;
			case Bpmn2Package.BPMN_ROOT__RESOURCE:
				return getResource() != null;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_ASSIGNMENT_EXPRESSION:
				return getResourceAssignmentExpression() != null;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER:
				return getResourceParameter() != null;
			case Bpmn2Package.BPMN_ROOT__RESOURCE_PARAMETER_BINDING:
				return getResourceParameterBinding() != null;
			case Bpmn2Package.BPMN_ROOT__SCRIPT:
				return getScript() != null;
			case Bpmn2Package.BPMN_ROOT__SCRIPT_TASK:
				return getScriptTask() != null;
			case Bpmn2Package.BPMN_ROOT__SEND_TASK:
				return getSendTask() != null;
			case Bpmn2Package.BPMN_ROOT__SEQUENCE_FLOW:
				return getSequenceFlow() != null;
			case Bpmn2Package.BPMN_ROOT__SERVICE_TASK:
				return getServiceTask() != null;
			case Bpmn2Package.BPMN_ROOT__SIGNAL:
				return getSignal() != null;
			case Bpmn2Package.BPMN_ROOT__SIGNAL_EVENT_DEFINITION:
				return getSignalEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__STANDARD_LOOP_CHARACTERISTICS:
				return getStandardLoopCharacteristics() != null;
			case Bpmn2Package.BPMN_ROOT__START_EVENT:
				return getStartEvent() != null;
			case Bpmn2Package.BPMN_ROOT__SUB_CHOREOGRAPHY:
				return getSubChoreography() != null;
			case Bpmn2Package.BPMN_ROOT__SUB_CONVERSATION:
				return getSubConversation() != null;
			case Bpmn2Package.BPMN_ROOT__SUB_PROCESS:
				return getSubProcess() != null;
			case Bpmn2Package.BPMN_ROOT__TASK:
				return getTask() != null;
			case Bpmn2Package.BPMN_ROOT__TERMINATE_EVENT_DEFINITION:
				return getTerminateEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__TEXT:
				return getText() != null;
			case Bpmn2Package.BPMN_ROOT__TEXT_ANNOTATION:
				return getTextAnnotation() != null;
			case Bpmn2Package.BPMN_ROOT__THROW_EVENT:
				return getThrowEvent() != null;
			case Bpmn2Package.BPMN_ROOT__TIMER_EVENT_DEFINITION:
				return getTimerEventDefinition() != null;
			case Bpmn2Package.BPMN_ROOT__TRANSACTION:
				return getTransaction() != null;
			case Bpmn2Package.BPMN_ROOT__USER_TASK:
				return getUserTask() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (mixed: ");
		result.append(mixed);
		result.append(')');
		return result.toString();
	}

} //BPMNRootImpl
