/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.w3.xhtml;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.w3.xhtml.XhtmlPackage
 * @generated
 */
@ProviderType
public interface XhtmlFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	XhtmlFactory eINSTANCE = org.w3.xhtml.impl.XhtmlFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Abbr Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abbr Type</em>'.
	 * @generated
	 */
	AbbrType createAbbrType();

	/**
	 * Returns a new object of class '<em>AContent</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>AContent</em>'.
	 * @generated
	 */
	AContent createAContent();

	/**
	 * Returns a new object of class '<em>Acronym Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Acronym Type</em>'.
	 * @generated
	 */
	AcronymType createAcronymType();

	/**
	 * Returns a new object of class '<em>Address Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Type</em>'.
	 * @generated
	 */
	AddressType createAddressType();

	/**
	 * Returns a new object of class '<em>Area Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Area Type</em>'.
	 * @generated
	 */
	AreaType createAreaType();

	/**
	 * Returns a new object of class '<em>AType</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>AType</em>'.
	 * @generated
	 */
	AType createAType();

	/**
	 * Returns a new object of class '<em>Bdo Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bdo Type</em>'.
	 * @generated
	 */
	BdoType createBdoType();

	/**
	 * Returns a new object of class '<em>Big Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Big Type</em>'.
	 * @generated
	 */
	BigType createBigType();

	/**
	 * Returns a new object of class '<em>Block</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Block</em>'.
	 * @generated
	 */
	Block createBlock();

	/**
	 * Returns a new object of class '<em>Blockquote Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Blockquote Type</em>'.
	 * @generated
	 */
	BlockquoteType createBlockquoteType();

	/**
	 * Returns a new object of class '<em>Br Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Br Type</em>'.
	 * @generated
	 */
	BrType createBrType();

	/**
	 * Returns a new object of class '<em>BType</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>BType</em>'.
	 * @generated
	 */
	BType createBType();

	/**
	 * Returns a new object of class '<em>Caption Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Caption Type</em>'.
	 * @generated
	 */
	CaptionType createCaptionType();

	/**
	 * Returns a new object of class '<em>Cite Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cite Type</em>'.
	 * @generated
	 */
	CiteType createCiteType();

	/**
	 * Returns a new object of class '<em>Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Code Type</em>'.
	 * @generated
	 */
	CodeType createCodeType();

	/**
	 * Returns a new object of class '<em>Colgroup Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Colgroup Type</em>'.
	 * @generated
	 */
	ColgroupType createColgroupType();

	/**
	 * Returns a new object of class '<em>Col Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Col Type</em>'.
	 * @generated
	 */
	ColType createColType();

	/**
	 * Returns a new object of class '<em>Dd Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dd Type</em>'.
	 * @generated
	 */
	DdType createDdType();

	/**
	 * Returns a new object of class '<em>Dfn Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dfn Type</em>'.
	 * @generated
	 */
	DfnType createDfnType();

	/**
	 * Returns a new object of class '<em>Div Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Div Type</em>'.
	 * @generated
	 */
	DivType createDivType();

	/**
	 * Returns a new object of class '<em>Dl Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dl Type</em>'.
	 * @generated
	 */
	DlType createDlType();

	/**
	 * Returns a new object of class '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Document Root</em>'.
	 * @generated
	 */
	DocumentRoot createDocumentRoot();

	/**
	 * Returns a new object of class '<em>Dt Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dt Type</em>'.
	 * @generated
	 */
	DtType createDtType();

	/**
	 * Returns a new object of class '<em>Em Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Em Type</em>'.
	 * @generated
	 */
	EmType createEmType();

	/**
	 * Returns a new object of class '<em>Flow</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Flow</em>'.
	 * @generated
	 */
	Flow createFlow();

	/**
	 * Returns a new object of class '<em>H1 Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>H1 Type</em>'.
	 * @generated
	 */
	H1Type createH1Type();

	/**
	 * Returns a new object of class '<em>H2 Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>H2 Type</em>'.
	 * @generated
	 */
	H2Type createH2Type();

	/**
	 * Returns a new object of class '<em>H3 Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>H3 Type</em>'.
	 * @generated
	 */
	H3Type createH3Type();

	/**
	 * Returns a new object of class '<em>H4 Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>H4 Type</em>'.
	 * @generated
	 */
	H4Type createH4Type();

	/**
	 * Returns a new object of class '<em>H5 Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>H5 Type</em>'.
	 * @generated
	 */
	H5Type createH5Type();

	/**
	 * Returns a new object of class '<em>H6 Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>H6 Type</em>'.
	 * @generated
	 */
	H6Type createH6Type();

	/**
	 * Returns a new object of class '<em>Hr Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hr Type</em>'.
	 * @generated
	 */
	HrType createHrType();

	/**
	 * Returns a new object of class '<em>Img Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Img Type</em>'.
	 * @generated
	 */
	ImgType createImgType();

	/**
	 * Returns a new object of class '<em>Inline</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Inline</em>'.
	 * @generated
	 */
	Inline createInline();

	/**
	 * Returns a new object of class '<em>IType</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IType</em>'.
	 * @generated
	 */
	IType createIType();

	/**
	 * Returns a new object of class '<em>Kbd Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Kbd Type</em>'.
	 * @generated
	 */
	KbdType createKbdType();

	/**
	 * Returns a new object of class '<em>Li Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Li Type</em>'.
	 * @generated
	 */
	LiType createLiType();

	/**
	 * Returns a new object of class '<em>Map Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Map Type</em>'.
	 * @generated
	 */
	MapType createMapType();

	/**
	 * Returns a new object of class '<em>Ol Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ol Type</em>'.
	 * @generated
	 */
	OlType createOlType();

	/**
	 * Returns a new object of class '<em>Pre Content</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pre Content</em>'.
	 * @generated
	 */
	PreContent createPreContent();

	/**
	 * Returns a new object of class '<em>Pre Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pre Type</em>'.
	 * @generated
	 */
	PreType createPreType();

	/**
	 * Returns a new object of class '<em>PType</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>PType</em>'.
	 * @generated
	 */
	PType createPType();

	/**
	 * Returns a new object of class '<em>QType</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>QType</em>'.
	 * @generated
	 */
	QType createQType();

	/**
	 * Returns a new object of class '<em>Samp Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Samp Type</em>'.
	 * @generated
	 */
	SampType createSampType();

	/**
	 * Returns a new object of class '<em>Small Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Small Type</em>'.
	 * @generated
	 */
	SmallType createSmallType();

	/**
	 * Returns a new object of class '<em>Span Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Span Type</em>'.
	 * @generated
	 */
	SpanType createSpanType();

	/**
	 * Returns a new object of class '<em>Strong Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Strong Type</em>'.
	 * @generated
	 */
	StrongType createStrongType();

	/**
	 * Returns a new object of class '<em>Sub Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Type</em>'.
	 * @generated
	 */
	SubType createSubType();

	/**
	 * Returns a new object of class '<em>Sup Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sup Type</em>'.
	 * @generated
	 */
	SupType createSupType();

	/**
	 * Returns a new object of class '<em>Table Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Table Type</em>'.
	 * @generated
	 */
	TableType createTableType();

	/**
	 * Returns a new object of class '<em>Tbody Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tbody Type</em>'.
	 * @generated
	 */
	TbodyType createTbodyType();

	/**
	 * Returns a new object of class '<em>Td Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Td Type</em>'.
	 * @generated
	 */
	TdType createTdType();

	/**
	 * Returns a new object of class '<em>Tfoot Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tfoot Type</em>'.
	 * @generated
	 */
	TfootType createTfootType();

	/**
	 * Returns a new object of class '<em>Thead Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thead Type</em>'.
	 * @generated
	 */
	TheadType createTheadType();

	/**
	 * Returns a new object of class '<em>Th Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Th Type</em>'.
	 * @generated
	 */
	ThType createThType();

	/**
	 * Returns a new object of class '<em>Tr Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tr Type</em>'.
	 * @generated
	 */
	TrType createTrType();

	/**
	 * Returns a new object of class '<em>Tt Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tt Type</em>'.
	 * @generated
	 */
	TtType createTtType();

	/**
	 * Returns a new object of class '<em>Ul Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ul Type</em>'.
	 * @generated
	 */
	UlType createUlType();

	/**
	 * Returns a new object of class '<em>Var Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Var Type</em>'.
	 * @generated
	 */
	VarType createVarType();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	XhtmlPackage getXhtmlPackage();

} //XhtmlFactory
