/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.w3.xhtml.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.w3.xhtml.AContent;
import org.w3.xhtml.AbbrType;
import org.w3.xhtml.AcronymType;
import org.w3.xhtml.BType;
import org.w3.xhtml.BdoType;
import org.w3.xhtml.BigType;
import org.w3.xhtml.BrType;
import org.w3.xhtml.CiteType;
import org.w3.xhtml.CodeType;
import org.w3.xhtml.DfnType;
import org.w3.xhtml.EmType;
import org.w3.xhtml.IType;
import org.w3.xhtml.ImgType;
import org.w3.xhtml.KbdType;
import org.w3.xhtml.MapType;
import org.w3.xhtml.QType;
import org.w3.xhtml.SampType;
import org.w3.xhtml.SmallType;
import org.w3.xhtml.SpanType;
import org.w3.xhtml.StrongType;
import org.w3.xhtml.SubType;
import org.w3.xhtml.SupType;
import org.w3.xhtml.TtType;
import org.w3.xhtml.VarType;
import org.w3.xhtml.XhtmlPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>AContent</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getMixed <em>Mixed</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getGroup <em>Group</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getBr <em>Br</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getSpan <em>Span</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getBdo <em>Bdo</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getMap <em>Map</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getImg <em>Img</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getTt <em>Tt</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getI <em>I</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getB <em>B</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getBig <em>Big</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getSmall <em>Small</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getEm <em>Em</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getStrong <em>Strong</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getDfn <em>Dfn</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getCode <em>Code</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getQ <em>Q</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getSamp <em>Samp</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getKbd <em>Kbd</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getVar <em>Var</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getCite <em>Cite</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getAbbr <em>Abbr</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getAcronym <em>Acronym</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getSub <em>Sub</em>}</li>
 *   <li>{@link org.w3.xhtml.impl.AContentImpl#getSup <em>Sup</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AContentImpl extends MinimalEObjectImpl.Container implements AContent {
	/**
	 * The cached value of the '{@link #getMixed() <em>Mixed</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMixed()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap mixed;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AContentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return XhtmlPackage.eINSTANCE.getAContent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureMap getMixed() {
		if (mixed == null) {
			mixed = new BasicFeatureMap(this, XhtmlPackage.ACONTENT__MIXED);
		}
		return mixed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureMap getGroup() {
		return (FeatureMap)getMixed().<FeatureMap.Entry>list(XhtmlPackage.eINSTANCE.getAContent_Group());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<BrType> getBr() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Br());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SpanType> getSpan() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Span());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<BdoType> getBdo() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Bdo());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<MapType> getMap() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Map());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ImgType> getImg() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Img());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TtType> getTt() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Tt());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<IType> getI() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_I());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<BType> getB() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_B());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<BigType> getBig() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Big());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SmallType> getSmall() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Small());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<EmType> getEm() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Em());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<StrongType> getStrong() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Strong());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DfnType> getDfn() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Dfn());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<CodeType> getCode() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Code());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<QType> getQ() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Q());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SampType> getSamp() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Samp());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<KbdType> getKbd() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Kbd());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<VarType> getVar() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Var());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<CiteType> getCite() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Cite());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<AbbrType> getAbbr() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Abbr());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<AcronymType> getAcronym() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Acronym());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SubType> getSub() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Sub());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SupType> getSup() {
		return getGroup().list(XhtmlPackage.eINSTANCE.getAContent_Sup());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case XhtmlPackage.ACONTENT__MIXED:
				return ((InternalEList<?>)getMixed()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__GROUP:
				return ((InternalEList<?>)getGroup()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__BR:
				return ((InternalEList<?>)getBr()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__SPAN:
				return ((InternalEList<?>)getSpan()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__BDO:
				return ((InternalEList<?>)getBdo()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__MAP:
				return ((InternalEList<?>)getMap()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__IMG:
				return ((InternalEList<?>)getImg()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__TT:
				return ((InternalEList<?>)getTt()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__I:
				return ((InternalEList<?>)getI()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__B:
				return ((InternalEList<?>)getB()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__BIG:
				return ((InternalEList<?>)getBig()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__SMALL:
				return ((InternalEList<?>)getSmall()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__EM:
				return ((InternalEList<?>)getEm()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__STRONG:
				return ((InternalEList<?>)getStrong()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__DFN:
				return ((InternalEList<?>)getDfn()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__CODE:
				return ((InternalEList<?>)getCode()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__Q:
				return ((InternalEList<?>)getQ()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__SAMP:
				return ((InternalEList<?>)getSamp()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__KBD:
				return ((InternalEList<?>)getKbd()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__VAR:
				return ((InternalEList<?>)getVar()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__CITE:
				return ((InternalEList<?>)getCite()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__ABBR:
				return ((InternalEList<?>)getAbbr()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__ACRONYM:
				return ((InternalEList<?>)getAcronym()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__SUB:
				return ((InternalEList<?>)getSub()).basicRemove(otherEnd, msgs);
			case XhtmlPackage.ACONTENT__SUP:
				return ((InternalEList<?>)getSup()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case XhtmlPackage.ACONTENT__MIXED:
				if (coreType) return getMixed();
				return ((FeatureMap.Internal)getMixed()).getWrapper();
			case XhtmlPackage.ACONTENT__GROUP:
				if (coreType) return getGroup();
				return ((FeatureMap.Internal)getGroup()).getWrapper();
			case XhtmlPackage.ACONTENT__BR:
				return getBr();
			case XhtmlPackage.ACONTENT__SPAN:
				return getSpan();
			case XhtmlPackage.ACONTENT__BDO:
				return getBdo();
			case XhtmlPackage.ACONTENT__MAP:
				return getMap();
			case XhtmlPackage.ACONTENT__IMG:
				return getImg();
			case XhtmlPackage.ACONTENT__TT:
				return getTt();
			case XhtmlPackage.ACONTENT__I:
				return getI();
			case XhtmlPackage.ACONTENT__B:
				return getB();
			case XhtmlPackage.ACONTENT__BIG:
				return getBig();
			case XhtmlPackage.ACONTENT__SMALL:
				return getSmall();
			case XhtmlPackage.ACONTENT__EM:
				return getEm();
			case XhtmlPackage.ACONTENT__STRONG:
				return getStrong();
			case XhtmlPackage.ACONTENT__DFN:
				return getDfn();
			case XhtmlPackage.ACONTENT__CODE:
				return getCode();
			case XhtmlPackage.ACONTENT__Q:
				return getQ();
			case XhtmlPackage.ACONTENT__SAMP:
				return getSamp();
			case XhtmlPackage.ACONTENT__KBD:
				return getKbd();
			case XhtmlPackage.ACONTENT__VAR:
				return getVar();
			case XhtmlPackage.ACONTENT__CITE:
				return getCite();
			case XhtmlPackage.ACONTENT__ABBR:
				return getAbbr();
			case XhtmlPackage.ACONTENT__ACRONYM:
				return getAcronym();
			case XhtmlPackage.ACONTENT__SUB:
				return getSub();
			case XhtmlPackage.ACONTENT__SUP:
				return getSup();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case XhtmlPackage.ACONTENT__MIXED:
				((FeatureMap.Internal)getMixed()).set(newValue);
				return;
			case XhtmlPackage.ACONTENT__GROUP:
				((FeatureMap.Internal)getGroup()).set(newValue);
				return;
			case XhtmlPackage.ACONTENT__BR:
				getBr().clear();
				getBr().addAll((Collection<? extends BrType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__SPAN:
				getSpan().clear();
				getSpan().addAll((Collection<? extends SpanType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__BDO:
				getBdo().clear();
				getBdo().addAll((Collection<? extends BdoType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__MAP:
				getMap().clear();
				getMap().addAll((Collection<? extends MapType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__IMG:
				getImg().clear();
				getImg().addAll((Collection<? extends ImgType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__TT:
				getTt().clear();
				getTt().addAll((Collection<? extends TtType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__I:
				getI().clear();
				getI().addAll((Collection<? extends IType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__B:
				getB().clear();
				getB().addAll((Collection<? extends BType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__BIG:
				getBig().clear();
				getBig().addAll((Collection<? extends BigType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__SMALL:
				getSmall().clear();
				getSmall().addAll((Collection<? extends SmallType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__EM:
				getEm().clear();
				getEm().addAll((Collection<? extends EmType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__STRONG:
				getStrong().clear();
				getStrong().addAll((Collection<? extends StrongType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__DFN:
				getDfn().clear();
				getDfn().addAll((Collection<? extends DfnType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__CODE:
				getCode().clear();
				getCode().addAll((Collection<? extends CodeType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__Q:
				getQ().clear();
				getQ().addAll((Collection<? extends QType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__SAMP:
				getSamp().clear();
				getSamp().addAll((Collection<? extends SampType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__KBD:
				getKbd().clear();
				getKbd().addAll((Collection<? extends KbdType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__VAR:
				getVar().clear();
				getVar().addAll((Collection<? extends VarType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__CITE:
				getCite().clear();
				getCite().addAll((Collection<? extends CiteType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__ABBR:
				getAbbr().clear();
				getAbbr().addAll((Collection<? extends AbbrType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__ACRONYM:
				getAcronym().clear();
				getAcronym().addAll((Collection<? extends AcronymType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__SUB:
				getSub().clear();
				getSub().addAll((Collection<? extends SubType>)newValue);
				return;
			case XhtmlPackage.ACONTENT__SUP:
				getSup().clear();
				getSup().addAll((Collection<? extends SupType>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case XhtmlPackage.ACONTENT__MIXED:
				getMixed().clear();
				return;
			case XhtmlPackage.ACONTENT__GROUP:
				getGroup().clear();
				return;
			case XhtmlPackage.ACONTENT__BR:
				getBr().clear();
				return;
			case XhtmlPackage.ACONTENT__SPAN:
				getSpan().clear();
				return;
			case XhtmlPackage.ACONTENT__BDO:
				getBdo().clear();
				return;
			case XhtmlPackage.ACONTENT__MAP:
				getMap().clear();
				return;
			case XhtmlPackage.ACONTENT__IMG:
				getImg().clear();
				return;
			case XhtmlPackage.ACONTENT__TT:
				getTt().clear();
				return;
			case XhtmlPackage.ACONTENT__I:
				getI().clear();
				return;
			case XhtmlPackage.ACONTENT__B:
				getB().clear();
				return;
			case XhtmlPackage.ACONTENT__BIG:
				getBig().clear();
				return;
			case XhtmlPackage.ACONTENT__SMALL:
				getSmall().clear();
				return;
			case XhtmlPackage.ACONTENT__EM:
				getEm().clear();
				return;
			case XhtmlPackage.ACONTENT__STRONG:
				getStrong().clear();
				return;
			case XhtmlPackage.ACONTENT__DFN:
				getDfn().clear();
				return;
			case XhtmlPackage.ACONTENT__CODE:
				getCode().clear();
				return;
			case XhtmlPackage.ACONTENT__Q:
				getQ().clear();
				return;
			case XhtmlPackage.ACONTENT__SAMP:
				getSamp().clear();
				return;
			case XhtmlPackage.ACONTENT__KBD:
				getKbd().clear();
				return;
			case XhtmlPackage.ACONTENT__VAR:
				getVar().clear();
				return;
			case XhtmlPackage.ACONTENT__CITE:
				getCite().clear();
				return;
			case XhtmlPackage.ACONTENT__ABBR:
				getAbbr().clear();
				return;
			case XhtmlPackage.ACONTENT__ACRONYM:
				getAcronym().clear();
				return;
			case XhtmlPackage.ACONTENT__SUB:
				getSub().clear();
				return;
			case XhtmlPackage.ACONTENT__SUP:
				getSup().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case XhtmlPackage.ACONTENT__MIXED:
				return mixed != null && !mixed.isEmpty();
			case XhtmlPackage.ACONTENT__GROUP:
				return !getGroup().isEmpty();
			case XhtmlPackage.ACONTENT__BR:
				return !getBr().isEmpty();
			case XhtmlPackage.ACONTENT__SPAN:
				return !getSpan().isEmpty();
			case XhtmlPackage.ACONTENT__BDO:
				return !getBdo().isEmpty();
			case XhtmlPackage.ACONTENT__MAP:
				return !getMap().isEmpty();
			case XhtmlPackage.ACONTENT__IMG:
				return !getImg().isEmpty();
			case XhtmlPackage.ACONTENT__TT:
				return !getTt().isEmpty();
			case XhtmlPackage.ACONTENT__I:
				return !getI().isEmpty();
			case XhtmlPackage.ACONTENT__B:
				return !getB().isEmpty();
			case XhtmlPackage.ACONTENT__BIG:
				return !getBig().isEmpty();
			case XhtmlPackage.ACONTENT__SMALL:
				return !getSmall().isEmpty();
			case XhtmlPackage.ACONTENT__EM:
				return !getEm().isEmpty();
			case XhtmlPackage.ACONTENT__STRONG:
				return !getStrong().isEmpty();
			case XhtmlPackage.ACONTENT__DFN:
				return !getDfn().isEmpty();
			case XhtmlPackage.ACONTENT__CODE:
				return !getCode().isEmpty();
			case XhtmlPackage.ACONTENT__Q:
				return !getQ().isEmpty();
			case XhtmlPackage.ACONTENT__SAMP:
				return !getSamp().isEmpty();
			case XhtmlPackage.ACONTENT__KBD:
				return !getKbd().isEmpty();
			case XhtmlPackage.ACONTENT__VAR:
				return !getVar().isEmpty();
			case XhtmlPackage.ACONTENT__CITE:
				return !getCite().isEmpty();
			case XhtmlPackage.ACONTENT__ABBR:
				return !getAbbr().isEmpty();
			case XhtmlPackage.ACONTENT__ACRONYM:
				return !getAcronym().isEmpty();
			case XhtmlPackage.ACONTENT__SUB:
				return !getSub().isEmpty();
			case XhtmlPackage.ACONTENT__SUP:
				return !getSup().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (mixed: ");
		result.append(mixed);
		result.append(')');
		return result.toString();
	}

} //AContentImpl
