/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.build.enunciate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.jaxb.ElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;

public class MediaTypeDeclaration {
    private final String id;
    private final String name;
    private final String description;
    private final String version;
    private final String xmlMediaType;
    private final String jsonMediaType;
    private final String projectId;
    private final RootElementDeclaration rootElement;
    private final List<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
    private final List<MediaTypeDeclaration> others;

    public MediaTypeDeclaration(String id, String name, String description, String version, String xmlMediaType, String jsonMediaType, String projectId, RootElementDeclaration rootElement, List<MediaTypeDeclaration> others) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.version = version;
        this.xmlMediaType = xmlMediaType;
        this.jsonMediaType = jsonMediaType;
        this.projectId = projectId;
        this.rootElement = rootElement;
        this.others = others;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getXmlMediaType() {
        return this.xmlMediaType;
    }

    public String getJsonMediaType() {
        return this.jsonMediaType;
    }

    public List<SchemaInfo> getSchemas() {
        return this.schemas;
    }

    public RootElementDeclaration getRootElement() {
        return this.rootElement;
    }

    public MediaTypeDeclaration getExtension() {
        XmlType baseType = this.getRootElement().getTypeDefinition().getBaseType();
        if (baseType instanceof XmlClassType) {
            String extfqn = ((XmlClassType)baseType).getTypeDefinition().getQualifiedName();
            for (MediaTypeDeclaration other : this.others) {
                if (!extfqn.equals(other.getRootElement().getQualifiedName())) continue;
                return other;
            }
        }
        return null;
    }

    public Set<ElementDeclaration> getElements() {
        TreeSet<ElementDeclaration> elements = new TreeSet<ElementDeclaration>(new Comparator<ElementDeclaration>(){

            @Override
            public int compare(ElementDeclaration o1, ElementDeclaration o2) {
                return o1.getQname().toString().compareTo(o2.getQname().toString());
            }
        });
        for (SchemaInfo schema : this.schemas) {
            elements.addAll(schema.getGlobalElements());
            elements.addAll(schema.getLocalElementDeclarations());
        }
        return elements;
    }

    public Set<TypeDefinition> getDataTypes() {
        TreeSet<TypeDefinition> elements = new TreeSet<TypeDefinition>(new Comparator<TypeDefinition>(){

            @Override
            public int compare(TypeDefinition o1, TypeDefinition o2) {
                return o1.getQname().toString().compareTo(o2.getQname().toString());
            }
        });
        for (SchemaInfo schema : this.schemas) {
            elements.addAll(schema.getTypeDefinitions());
        }
        return elements;
    }
}

