/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.build.enunciate;

import com.sun.mirror.apt.Messager;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jelly.apt.Context;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.config.WsdlInfo;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.contract.validation.ValidationMessage;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.NamedArtifact;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.codehaus.enunciate.modules.DocumentationAwareModule;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.modules.docs.GenerateExampleXmlMethod;
import org.codehaus.enunciate.modules.docs.SchemaForNamespaceMethod;
import org.codehaus.enunciate.modules.objc.ObjCDeploymentModule;
import org.codehaus.enunciate.template.freemarker.IsDefinedGloballyMethod;
import org.codehaus.enunciate.template.freemarker.UniqueContentTypesMethod;
import org.gedcomx.build.enunciate.BaseProjectUriMethod;
import org.gedcomx.build.enunciate.GedcomxRuleSet;
import org.gedcomx.build.enunciate.GedcomxValidator;
import org.gedcomx.build.enunciate.GenerateExampleJsonMethod;
import org.gedcomx.build.enunciate.IsOfProjectMethod;
import org.gedcomx.build.enunciate.JsonExtensionElementNameMethod;
import org.gedcomx.build.enunciate.MediaTypeDeclaration;
import org.gedcomx.build.enunciate.TypeNameMethod;
import org.gedcomx.build.enunciate.rdf.RDFProcessor;
import org.gedcomx.rt.DocIgnoreXmlRootElement;
import org.gedcomx.rt.GedcomNamespaceManager;
import org.gedcomx.rt.MediaTypeDefinition;
import org.gedcomx.rt.Model;

public class GedcomxDeploymentModule
extends FreemarkerDeploymentModule
implements DocumentationAwareModule {
    private String projectId = "gedcomx";
    private String projectLabelModifier = null;
    private final Map<String, String> baseProjectUris = new HashMap<String, String>();
    private RDFProcessor rdfProcessor;
    private final Map<String, String> primaryNav = new LinkedHashMap<String, String>();
    private boolean disableProcessing = true;
    private String stylesheet;

    public String getName() {
        return "gedcomx";
    }

    public int getOrder() {
        return 100;
    }

    public String getTitle() {
        return "GEDCOMX";
    }

    public void setTitle(String title) {
    }

    public void setTitleConditionally(String title) {
    }

    public String getDocsDir() {
        return null;
    }

    public String getIndexPageName() {
        return "index.html";
    }

    public void setIndexPageName(String indexPageName) {
    }

    public void setDocsDir(String docsDir) {
    }

    public boolean isDisableProcessing() {
        return this.disableProcessing;
    }

    public void setDisableProcessing(boolean disableProcessing) {
        this.disableProcessing = disableProcessing;
    }

    public void addPrimaryNav(String label, String href) {
        this.primaryNav.put(label, href);
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setProjectLabelModifier(String projectLabelModifier) {
        this.projectLabelModifier = projectLabelModifier;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    protected URL getDocsTemplateURL() {
        return GedcomxDeploymentModule.class.getResource("docs.fmt");
    }

    protected URL getCodeTemplateURL() {
        return GedcomxDeploymentModule.class.getResource("code.fmt");
    }

    protected URL getRDFSchemaTemplateURL() {
        return GedcomxDeploymentModule.class.getResource("rdfschema.fmt");
    }

    public void init(Enunciate enunciate) throws EnunciateException {
        super.init(enunciate);
        enunciate.getConfig().getContentTypesToIds().put("application/x-gedcomx-v1+xml", "gedcomx-xml");
        enunciate.getConfig().getContentTypesToIds().put("application/x-gedcomx-v1+json", "gedcomx-json");
        SortedSet modules = enunciate.getConfig().getAllModules();
        for (DeploymentModule module : modules) {
            if (!(module instanceof ObjCDeploymentModule)) continue;
            ((ObjCDeploymentModule)module).setTranslateIdTo("objectId");
        }
        this.rdfProcessor = new RDFProcessor();
    }

    public void initModel(EnunciateFreemarkerModel model) {
        StringBuilder text;
        super.initModel(model);
        Iterator it = model.getRootElementDeclarations().iterator();
        while (it.hasNext()) {
            if (((RootElementDeclaration)it.next()).getAnnotation(DocIgnoreXmlRootElement.class) == null) continue;
            it.remove();
        }
        Map knownPrefixes = GedcomNamespaceManager.getKnownPrefixes();
        model.getNamespacesToPrefixes().putAll(knownPrefixes);
        for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
            String knownPrefix = (String)knownPrefixes.get(schemaInfo.getNamespace());
            if (knownPrefix != null) {
                schemaInfo.setId(knownPrefix);
            }
            it = schemaInfo.getGlobalElements().iterator();
            while (it.hasNext()) {
                if (((RootElementDeclaration)it.next()).getAnnotation(DocIgnoreXmlRootElement.class) == null) continue;
                it.remove();
            }
        }
        ArrayList<MediaTypeDeclaration> mediaTypeDeclarations = new ArrayList<MediaTypeDeclaration>();
        Collection<RootElementDeclaration> mediaTypeRoots = this.gatherMediaTypeRoots(model);
        HashMap<String, String> prefix_version_to_ns = new HashMap<String, String>();
        for (RootElementDeclaration rootElement : mediaTypeRoots) {
            this.info("Found media type root declaration at %s.", new Object[]{rootElement.getQualifiedName()});
            MediaTypeDefinition mediaTypeInfo = (MediaTypeDefinition)rootElement.getAnnotation(MediaTypeDefinition.class);
            MediaTypeDeclaration decl = new MediaTypeDeclaration(mediaTypeInfo.id(), mediaTypeInfo.name(), mediaTypeInfo.description(), mediaTypeInfo.version(), mediaTypeInfo.xmlMediaType(), mediaTypeInfo.jsonMediaType(), mediaTypeInfo.projectId(), rootElement, mediaTypeDeclarations);
            for (Model m : mediaTypeInfo.models()) {
                String id = m.id();
                SchemaInfo schemaInfo = (SchemaInfo)model.getNamespacesToSchemas().get(m.namespace());
                model.getNamespacesToPrefixes().put(m.namespace(), id);
                if (schemaInfo == null) continue;
                schemaInfo.setId(id);
                String previousNamespace = prefix_version_to_ns.put(id, schemaInfo.getNamespace());
                if (previousNamespace != null && !previousNamespace.equals(schemaInfo.getNamespace())) {
                    String message = rootElement.getPosition() == null ? String.format("Id '%s' is already being used by model %s.", id, previousNamespace) : String.format("%s: Id '%s' is already being used by model %s.", rootElement.getQualifiedName(), id, previousNamespace);
                    throw new ValidationException(rootElement.getPosition(), message);
                }
                String label = m.label();
                if ("".equals(label)) {
                    label = "\"" + id + "\" Model";
                }
                schemaInfo.setProperty("label", (Object)label);
                String description = m.description();
                if ("".equals(description)) {
                    description = null;
                }
                schemaInfo.setProperty("description", (Object)description);
                schemaInfo.setProperty("definesRDFSchema", (Object)m.definesRDFSchema());
                schemaInfo.setProperty("projectId", (Object)mediaTypeInfo.projectId());
                schemaInfo.setProperty("mediaType", (Object)decl);
                schemaInfo.setProperty("filename", (Object)(id + ".xsd"));
                schemaInfo.setProperty("location", (Object)(id + ".xsd"));
                decl.getSchemas().add(schemaInfo);
            }
            mediaTypeDeclarations.add(decl);
        }
        model.put("mediaTypeDeclarations", mediaTypeDeclarations);
        ValidationResult validationResult = this.rdfProcessor.processModel(model);
        Messager messager = Context.getCurrentEnvironment().getMessager();
        if (validationResult.hasWarnings()) {
            this.warn("Warnings while processing RDF and resource services.", new Object[0]);
            for (ValidationMessage warning : validationResult.getWarnings()) {
                text = new StringBuilder();
                if (warning.getLabel() != null) {
                    text.append('[').append(warning.getLabel()).append("] ");
                }
                text.append(warning.getText());
                if (warning.getPosition() != null) {
                    messager.printWarning(warning.getPosition(), text.toString());
                    continue;
                }
                messager.printWarning(text.toString());
            }
        }
        if (validationResult.hasErrors()) {
            for (ValidationMessage error : validationResult.getErrors()) {
                text = new StringBuilder();
                if (error.getLabel() != null) {
                    text.append('[').append(error.getLabel()).append("] ");
                }
                text.append(error.getText());
                if (error.getPosition() != null) {
                    messager.printError(error.getPosition(), text.toString());
                    continue;
                }
                messager.printError(text.toString());
            }
            throw new RuntimeException("Errors while processing RDF and resource services.");
        }
    }

    protected Collection<RootElementDeclaration> gatherMediaTypeRoots(EnunciateFreemarkerModel model) {
        ArrayList<RootElementDeclaration> mediaTypeDecls = new ArrayList<RootElementDeclaration>();
        for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
            for (RootElementDeclaration declaration : schemaInfo.getGlobalElements()) {
                if (declaration.getAnnotation(MediaTypeDefinition.class) == null) continue;
                mediaTypeDecls.add(declaration);
            }
        }
        return mediaTypeDecls;
    }

    public void doFreemarkerGenerate() throws EnunciateException, IOException, TemplateException {
    }

    /*
     * Unable to fully structure code
     */
    protected void doBuild() throws EnunciateException, IOException {
        if (!this.getEnunciate().isUpToDateWithSources(this.getBuildDir())) {
            downloadableArtifacts = this.buildBase();
            model = this.getModel();
            model.setFileOutputDirectory(this.getBuildDir());
            model.put("downloads", downloadableArtifacts);
            model.setVariable("uniqueContentTypes", (Object)new UniqueContentTypesMethod());
            model.setVariable("schemaForNamespace", (Object)new SchemaForNamespaceMethod(model.getNamespacesToSchemas()));
            model.put("isDefinedGlobally", (Object)new IsDefinedGloballyMethod());
            model.put("defaultDate", (Object)new Date());
            model.setVariable("generateExampleJson", (Object)new GenerateExampleJsonMethod(model));
            model.setVariable("generateExampleXml", (Object)new GenerateExampleXmlMethod(null, model));
            model.setVariable("typeName", (Object)new TypeNameMethod(model.getNamespacesToSchemas()));
            model.setVariable("jsonExtensionElementName", (Object)new JsonExtensionElementNameMethod());
            model.put("rdfschema", (Object)this.rdfProcessor.getRdfSchema());
            model.put("primaryNav", this.primaryNav);
            model.put("projectId", (Object)this.projectId);
            if (this.projectLabelModifier != null) {
                model.put("projectLabelModifier", (Object)this.projectLabelModifier);
            }
            model.put("isOfProject", (Object)new IsOfProjectMethod(this.getModelInternal().getNamespacesToSchemas(), this.projectId));
            model.put("baseProjectUris", this.getBaseProjectUris());
            model.put("baseProjectUri", (Object)new BaseProjectUriMethod(this.getBaseProjectUris(), this.getModelInternal().getNamespacesToSchemas()));
            try {
                for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
                    namespace = schemaInfo.getNamespace();
                    if (!Boolean.TRUE.equals(schemaInfo.getProperty("definesRDFSchema"))) continue;
                    if (!this.rdfProcessor.isKnownRDFNamespace(namespace)) {
                        model.put("schema", (Object)schemaInfo);
                        if (!this.isDisableProcessing()) {
                            this.processTemplate(this.getRDFSchemaTemplateURL(), model);
                        }
                        schemaInfo.setProperty("rdfSchemaLocation", (Object)(schemaInfo.getId() + ".rdf.xml"));
                        continue;
                    }
                    schemaInfo.setProperty("rdfSchemaLocation", (Object)namespace);
                }
                if (this.isDisableProcessing()) ** GOTO lbl41
                this.processTemplate(this.getDocsTemplateURL(), model);
                this.processTemplate(this.getCodeTemplateURL(), model);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
        } else {
            this.info("Skipping build of documentation as everything appears up-to-date...", new Object[0]);
        }
lbl41:
        // 3 sources

        this.getEnunciate().addArtifact((Artifact)new FileArtifact(this.getName(), "gedcomx-docs", this.getBuildDir()));
    }

    protected Set<Artifact> buildBase() throws IOException {
        File to;
        String filename;
        File from;
        Enunciate enunciate = this.getEnunciate();
        File buildDir = this.getBuildDir();
        buildDir.mkdirs();
        enunciate.extractBase(GedcomxDeploymentModule.class.getResourceAsStream("/docs.base.zip"), buildDir);
        if (this.stylesheet != null) {
            File styleSheet = enunciate.resolvePath(this.stylesheet);
            enunciate.copyFile(styleSheet, new File(new File(buildDir, "css"), "style.css"));
        }
        for (SchemaInfo schemaInfo : this.getModel().getNamespacesToSchemas().values()) {
            if (schemaInfo.getProperty("file") == null) continue;
            from = (File)schemaInfo.getProperty("file");
            filename = schemaInfo.getProperty("filename") != null ? (String)schemaInfo.getProperty("filename") : from.getName();
            to = new File(buildDir, filename);
            enunciate.copyFile(from, to);
        }
        for (WsdlInfo wsdlInfo : this.getModel().getNamespacesToWSDLs().values()) {
            if (wsdlInfo.getProperty("file") == null) continue;
            from = (File)wsdlInfo.getProperty("file");
            filename = wsdlInfo.getProperty("filename") != null ? (String)wsdlInfo.getProperty("filename") : from.getName();
            to = new File(buildDir, filename);
            enunciate.copyFile(from, to);
        }
        File wadlFile = this.getModelInternal().getWadlFile();
        if (wadlFile != null) {
            enunciate.copyFile(wadlFile, new File(buildDir, wadlFile.getName()));
        }
        TreeSet<Artifact> downloads = new TreeSet<Artifact>();
        for (Artifact artifact : enunciate.getArtifacts()) {
            if (!(artifact instanceof NamedArtifact) || !artifact.isPublic()) continue;
            downloads.add(artifact);
        }
        for (Artifact download : downloads) {
            this.debug("Exporting %s to directory %s.", new Object[]{download.getId(), buildDir});
            download.exportTo(buildDir, enunciate);
        }
        return downloads;
    }

    public Validator getValidator() {
        return new GedcomxValidator();
    }

    public RuleSet getConfigurationRules() {
        return new GedcomxRuleSet();
    }

    public Map<String, String> getBaseProjectUris() {
        return this.baseProjectUris;
    }

    public void putProjectBase(String id, String uri) {
        this.baseProjectUris.put(id, uri);
    }
}

