/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.build.enunciate;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;

public class GedcomxExtensionDeploymentModule
extends FreemarkerDeploymentModule {
    public String getName() {
        return "gedcomx-ext";
    }

    public final int getOrder() {
        return 101;
    }

    public void init(Enunciate enunciate) throws EnunciateException {
        super.init(enunciate);
        if (!this.isDisabled() && !enunciate.isModuleEnabled("gedcomx")) {
            throw new EnunciateException("The 'gedcomx' enunciate module must be enabled for extension processing.");
        }
    }

    protected URL getDocsTemplateURL() {
        return GedcomxExtensionDeploymentModule.class.getResource("/META-INF/gedcomx-ext-docs.fmt");
    }

    public void doFreemarkerGenerate() throws EnunciateException, IOException, TemplateException {
    }

    protected void doBuild() throws EnunciateException, IOException {
        File buildDir = this.getBuildDir();
        if (!this.getEnunciate().isUpToDateWithSources(buildDir)) {
            EnunciateFreemarkerModel model = this.getModel();
            model.setFileOutputDirectory(buildDir);
            InputStream base = GedcomxExtensionDeploymentModule.class.getResourceAsStream("/gedcomx.ext.docs.base.zip");
            if (base != null) {
                this.getEnunciate().extractBase(base, buildDir);
            }
            try {
                this.processTemplate(this.getDocsTemplateURL(), model);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
        } else {
            this.info("Skipping build of documentation as everything appears up-to-date...", new Object[0]);
        }
        this.getEnunciate().addArtifact((Artifact)new FileArtifact(this.getName(), "gedcomx-ext-docs", buildDir));
    }

    public boolean isDisabled() {
        if (super.isDisabled()) {
            return true;
        }
        if (this.getDocsTemplateURL() == null) {
            this.debug("Module %s is disabled because nothing's at /META-INF/gedcomx-ext-docs.fmt.", new Object[]{this.getName()});
            return true;
        }
        return false;
    }
}

