/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.build.enunciate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.codehaus.enunciate.main.ClasspathHandler;
import org.codehaus.enunciate.main.ClasspathResource;
import org.codehaus.enunciate.main.Enunciate;
import org.gedcomx.test.Recipe;

public class RecipeClasspathHandler
implements ClasspathHandler {
    private final Enunciate enunciate;
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private final Unmarshaller unmarshaller;

    public RecipeClasspathHandler(Enunciate enunciate) {
        this.enunciate = enunciate;
        try {
            this.unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Recipe.class}).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Recipe> getRecipes() {
        return this.recipes;
    }

    public void startPathEntry(File pathEntry) {
    }

    public void handleResource(ClasspathResource resource) {
        if (resource.getPath().endsWith(".recipe.xml")) {
            try {
                this.recipes.add((Recipe)this.unmarshaller.unmarshal(resource.read()));
            }
            catch (Exception e) {
                this.enunciate.error("Unable to unmarshal recipe %s: %s.", new Object[]{resource.getPath(), e.getMessage()});
            }
        }
    }

    public boolean endPathEntry(File pathEntry) {
        return false;
    }
}

