/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.build.enunciate;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.ImplicitSchemaElement;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;

public class TypeNameMethod
implements TemplateMethodModelEx {
    private final Map<String, SchemaInfo> namespacesToSchemas;

    public TypeNameMethod(Map<String, SchemaInfo> namespacesToSchemas) {
        this.namespacesToSchemas = namespacesToSchemas;
    }

    public Object exec(List list) throws TemplateModelException {
        String name;
        if (list.size() < 1) {
            throw new TemplateModelException("The typeName method must have an accessor as a parameter.");
        }
        Object object = BeansWrapper.getDefaultInstance().unwrap((TemplateModel)list.get(0));
        if (object instanceof Accessor) {
            Accessor accessor = (Accessor)object;
            QName ref = accessor.getRef();
            if (ref != null) {
                name = null;
                SchemaInfo schemaInfo = this.namespacesToSchemas.get(ref.getNamespaceURI());
                if (schemaInfo != null) {
                    for (ImplicitSchemaElement implicitElement : schemaInfo.getImplicitSchemaElements()) {
                        if (!implicitElement.getElementName().equals(ref.getLocalPart())) continue;
                        name = implicitElement.getTypeQName().getLocalPart();
                        break;
                    }
                    if (name == null) {
                        for (ImplicitSchemaElement implicitElement : schemaInfo.getImplicitSchemaAttributes()) {
                            if (!implicitElement.getAttributeName().equals(ref.getLocalPart())) continue;
                            name = implicitElement.getTypeQName().getLocalPart();
                            break;
                        }
                    }
                    if (name == null) {
                        name = ref.getLocalPart();
                    }
                }
            } else {
                name = accessor.getBaseType().getName();
            }
        } else if (object instanceof RootElementDeclaration) {
            name = ((RootElementDeclaration)object).getTypeDefinition().getName();
        } else if (object instanceof XmlType) {
            name = ((XmlType)object).getName();
        } else {
            throw new TemplateModelException("The typeName method must have an accessor as a parameter.");
        }
        return name;
    }
}

