/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.build.enunciate.rdf;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.Declarations;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.QNameEnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.gedcomx.build.enunciate.rdf.RDFSchema;
import org.gedcomx.rt.RDFDomain;
import org.gedcomx.rt.RDFRange;
import org.gedcomx.rt.RDFSubClassOf;
import org.gedcomx.rt.RDFSubPropertyOf;

public class RDFProcessor {
    private final RDFSchema rdfSchema = new RDFSchema();

    public RDFProcessor() {
        this.loadKnownRDFSchemaDescriptions();
    }

    public RDFSchema getRdfSchema() {
        return this.rdfSchema;
    }

    public boolean isKnownRDFNamespace(String namespace) {
        return "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespace) || "http://www.w3.org/2000/01/rdf-schema#".equals(namespace) || "http://www.w3.org/XML/1998/namespace".equals(namespace) || "http://purl.org/dc/dcmitype/".equals(namespace) || "http://purl.org/dc/terms/".equals(namespace);
    }

    public ValidationResult processModel(EnunciateFreemarkerModel model) {
        ValidationResult result = new ValidationResult();
        for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
            if (this.isKnownRDFNamespace(schemaInfo.getNamespace()) || !Boolean.TRUE.equals(schemaInfo.getProperty("definesRDFSchema"))) continue;
            this.describeSchema(schemaInfo, result);
            ArrayList<QNameEnumTypeDefinition> enums = new ArrayList<QNameEnumTypeDefinition>();
            for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                this.validate(result, typeDefinition);
                if (typeDefinition instanceof QNameEnumTypeDefinition) {
                    enums.add((QNameEnumTypeDefinition)typeDefinition);
                    continue;
                }
                if (!(typeDefinition instanceof ComplexTypeDefinition)) continue;
                this.describeRDFClassesAndProperties((ComplexTypeDefinition)typeDefinition, result);
            }
            for (LocalElementDeclaration localElementDeclaration : schemaInfo.getLocalElementDeclarations()) {
                this.describeRDFProperty(localElementDeclaration, result);
            }
            for (QNameEnumTypeDefinition qNameEnumTypeDefinition : enums) {
                this.describeRDFClassesAndProperties(qNameEnumTypeDefinition, result);
            }
        }
        return result;
    }

    protected void validate(ValidationResult result, TypeDefinition typeDef) {
        if (!(this.suppressWarning((Declaration)typeDef, "rdf-incompatible-ns") || typeDef.getNamespace().endsWith("/") || typeDef.getNamespace().endsWith("#"))) {
            result.addError((Declaration)typeDef, "The namespace of type definitions should end with a '/' or a '#' in order to provide for defining them in terms of RDF Schema.");
        }
        for (Attribute attribute : typeDef.getAttributes()) {
            String namespace = attribute.getNamespace();
            if ((namespace == null || "".equals(attribute.getNamespace())) && !this.suppressWarning((Declaration)typeDef, "unqualified-attribute")) {
                result.addError((Declaration)attribute, "Attributes should be defined within a namespace so as to be well-defined within RDF. Hint: use attributeFormDefault=\"qualified\".");
            }
            if (!this.suppressWarning((Declaration)attribute, "rdf-incompatible-type-reference") && "type".equals(attribute.getName())) {
                result.addError((Declaration)attribute, "Types should be specified with as an rdf:type reference, which is an element named 'type' in the rdf namespace with an rdf:resource attribute.");
            }
            if (!"id".equalsIgnoreCase(attribute.getName()) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attribute.getNamespace()) || "ID".equals(attribute.getName())) continue;
            result.addError((Declaration)attribute, "Id attributes should be named rdf:ID.");
        }
        for (Element element : typeDef.getElements()) {
            for (Element choice : element.getChoices()) {
                if (!this.suppressWarning((Declaration)choice, "rdf-incompatible-type-reference") && "type".equals(choice.getName()) && !this.isTypeReference(choice)) {
                    result.addError((Declaration)choice, "Types should be specified with as an rdf:type reference, which is an element named 'type' in the rdf namespace with an rdf:resource attribute.");
                }
                if (!"id".equals(choice.getName()) || choice.isXmlID()) continue;
                result.addError((Declaration)choice, "Accessors named 'id' should be attributes named rdf:ID and annotated with @XmlID.");
            }
        }
    }

    private boolean suppressWarning(Declaration declaration, String warning) {
        SuppressWarnings suppressionInfo = (SuppressWarnings)declaration.getAnnotation(SuppressWarnings.class);
        return suppressionInfo != null && Arrays.asList(suppressionInfo.value()).contains(warning);
    }

    private boolean isTypeReference(Element choice) {
        org.codehaus.enunciate.contract.jaxb.types.XmlType baseType;
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(choice.getNamespace()) && (baseType = choice.getBaseType()) instanceof XmlClassType) {
            TypeDefinition typeDefinition = ((XmlClassType)baseType).getTypeDefinition();
            for (Attribute attribute : typeDefinition.getAttributes()) {
                if (!"resource".equals(attribute.getName()) || !"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attribute.getNamespace())) continue;
                return true;
            }
        }
        return false;
    }

    private void describeRDFClassesAndProperties(ComplexTypeDefinition typeDefinition, ValidationResult result) {
        if (!this.isResourceRef((TypeDefinition)typeDefinition)) {
            this.describeRDFClasses((TypeDefinition)typeDefinition, result);
            for (Attribute attribute : typeDefinition.getAttributes()) {
                this.describeRDFProperty((Accessor)attribute, result);
            }
            for (Element element : typeDefinition.getElements()) {
                for (Element choice : element.getChoices()) {
                    this.describeRDFProperty((Accessor)choice, result);
                }
                if (!element.isWrapped()) continue;
                result.addWarning((Declaration)element, "A wrapped element adds significant confusion to the RDF schema.");
            }
        }
    }

    private void describeRDFClassesAndProperties(QNameEnumTypeDefinition typeDefinition, ValidationResult result) {
        Map enumValues = typeDefinition.getEnumValues();
        for (EnumConstantDeclaration constant : typeDefinition.getEnumConstants()) {
            String about;
            RDFSchema.RDFDescription description;
            QName qname = (QName)enumValues.get(constant.getSimpleName());
            if (qname == null) continue;
            if (!Character.isUpperCase(qname.getLocalPart().charAt(0))) {
                result.addWarning((Declaration)constant, "RDF style conventions imply that the local part of this QName should be capitalized.");
            }
            if ((description = this.rdfSchema.findDescription(about = qname.getNamespaceURI() + qname.getLocalPart())) == null) {
                description = new RDFSchema.RDFDescription();
                description.setAbout(about);
                description.setIsDefinedBy(qname.getNamespaceURI());
                description.setType("http://www.w3.org/2000/01/rdf-schema#Class");
                description.setLabel(constant.getSimpleName());
                description.setAssociatedDeclaration((Declaration)constant);
                this.rdfSchema.addDescription(description);
            } else {
                StringBuilder message;
                if (!qname.getNamespaceURI().equals(description.getIsDefinedBy())) {
                    message = new StringBuilder("Unable to describe class ").append(about).append(" because it's already described in a different definition (").append(description.getIsDefinedBy()).append(")");
                    this.appendPosition(message, description.getAssociatedDeclaration());
                    message.append('.');
                    result.addError((Declaration)constant, message.toString());
                }
                if (!"http://www.w3.org/2000/01/rdf-schema#Class".equals(description.getType())) {
                    message = new StringBuilder("Unable to describe class ").append(about).append(" because it's already described as of type '").append(description.getType()).append("'");
                    this.appendPosition(message, description.getAssociatedDeclaration());
                    message.append('.');
                    result.addError((Declaration)constant, message.toString());
                }
            }
            String docComment = constant.getDocComment();
            if ((docComment = docComment == null ? "" : docComment.trim()).isEmpty()) continue;
            description.addComment(docComment);
        }
    }

    private void describeRDFProperty(Accessor accessor, ValidationResult result) {
        String comment;
        String namespace = accessor.getNamespace();
        if (this.isKnownRDFNamespace(namespace)) {
            return;
        }
        String name = accessor.getName();
        String about = namespace + name;
        MemberDeclaration declaringMember = this.findDeclaringMember(accessor);
        Set<String> domain = this.determineRDFDomain(accessor, declaringMember, result);
        Set<String> range = this.determineRDFRange(accessor, declaringMember, result);
        Set<String> superProperties = this.determineRDFSuperProperties(accessor, declaringMember, result);
        RDFSchema.RDFDescription description = this.rdfSchema.findDescription(about);
        if (description == null) {
            description = new RDFSchema.RDFDescription();
            description.setAbout(about);
            description.setLabel(name);
            description.setIsDefinedBy(namespace);
            description.setType("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
            description.setRange(range);
            description.setDomain(domain);
            description.setSubPropertyOf(superProperties);
            description.setAssociatedDeclaration((Declaration)accessor);
            this.rdfSchema.addDescription(description);
        } else {
            StringBuilder message;
            if (!namespace.equals(description.getIsDefinedBy())) {
                message = new StringBuilder("Unable to describe property ").append(about).append(" because it's already described as defined by '").append(description.getIsDefinedBy()).append("'");
                this.appendPosition(message, description.getAssociatedDeclaration());
                message.append('.');
                result.addError((Declaration)accessor, message.toString());
            }
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#Property".equals(description.getType())) {
                message = new StringBuilder("Unable to describe property ").append(about).append(" because it's already described as of type '").append(description.getType()).append("'");
                this.appendPosition(message, description.getAssociatedDeclaration());
                message.append('.');
                result.addError((Declaration)accessor, message.toString());
            } else {
                if (!((Object)range).equals(description.getRange()) && !description.getRange().isEmpty()) {
                    description.getRange().retainAll(range);
                    if (description.getRange().isEmpty()) {
                        message = new StringBuilder("Unable to determine range for property ").append(about).append(" because the intersection between the range ");
                        this.appendPosition(message, description.getAssociatedDeclaration());
                        message.append(" is empty.");
                        result.addWarning((Declaration)accessor, message.toString());
                    }
                }
                if (!((Object)domain).equals(description.getDomain())) {
                    message = new StringBuilder("Unable to describe property ").append(about).append(" because it's domain is described as ");
                    message.append((CharSequence)this.getSetComparisonMessage(domain, description.getDomain()));
                    this.appendPosition(message, description.getAssociatedDeclaration());
                    message.append('.');
                    result.addError((Declaration)accessor, message.toString());
                }
                if (!((Object)superProperties).equals(description.getSubPropertyOf())) {
                    message = new StringBuilder("Unable to describe property ").append(about).append(" because it's 'subPropertyOf' is described as ");
                    message.append((CharSequence)this.getSetComparisonMessage(superProperties, description.getSubPropertyOf()));
                    this.appendPosition(message, description.getAssociatedDeclaration());
                    message.append('.');
                    result.addError((Declaration)accessor, message.toString());
                }
            }
        }
        JavaDoc javaDoc = accessor.getJavaDoc();
        if (declaringMember != null) {
            javaDoc = new JavaDoc(declaringMember.getDocComment());
        }
        if (javaDoc != null && !(comment = javaDoc.toString()).isEmpty()) {
            description.addComment(comment);
        }
    }

    private void describeRDFProperty(LocalElementDeclaration localEl, ValidationResult result) {
        String comment;
        String namespace = localEl.getNamespace();
        if (this.isKnownRDFNamespace(namespace)) {
            return;
        }
        String name = localEl.getName();
        String about = namespace + name;
        TreeSet<String> domain = new TreeSet<String>();
        Set<String> range = this.determineRDFRange(localEl.getElementXmlType(), result);
        TreeSet<String> superProperties = new TreeSet<String>();
        RDFSchema.RDFDescription description = this.rdfSchema.findDescription(about);
        if (description == null) {
            description = new RDFSchema.RDFDescription();
            description.setAbout(about);
            description.setLabel(name);
            description.setIsDefinedBy(namespace);
            description.setType("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
            description.setRange(range);
            description.setDomain(domain);
            description.setSubPropertyOf(superProperties);
            description.setAssociatedDeclaration((Declaration)localEl);
            this.rdfSchema.addDescription(description);
        } else {
            StringBuilder message;
            if (!namespace.equals(description.getIsDefinedBy())) {
                message = new StringBuilder("Unable to describe property ").append(about).append(" because it's already described as defined by '").append(description.getIsDefinedBy()).append("'");
                this.appendPosition(message, description.getAssociatedDeclaration());
                message.append('.');
                result.addError((Declaration)localEl, message.toString());
            }
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#Property".equals(description.getType())) {
                message = new StringBuilder("Unable to describe property ").append(about).append(" because it's already described as of type '").append(description.getType()).append("'");
                this.appendPosition(message, description.getAssociatedDeclaration());
                message.append('.');
                result.addError((Declaration)localEl, message.toString());
            } else {
                if (!((Object)range).equals(description.getRange()) && !description.getRange().isEmpty()) {
                    description.getRange().retainAll(range);
                    if (description.getRange().isEmpty()) {
                        message = new StringBuilder("Unable to determine range for property ").append(about).append(" because the intersection between the range ");
                        this.appendPosition(message, description.getAssociatedDeclaration());
                        message.append(" is empty.");
                        result.addWarning((Declaration)localEl, message.toString());
                    }
                }
                if (!((Object)domain).equals(description.getDomain())) {
                    message = new StringBuilder("Unable to describe property ").append(about).append(" because it's domain is described as ");
                    message.append((CharSequence)this.getSetComparisonMessage(domain, description.getDomain()));
                    this.appendPosition(message, description.getAssociatedDeclaration());
                    message.append('.');
                    result.addError((Declaration)localEl, message.toString());
                }
                if (!((Object)superProperties).equals(description.getSubPropertyOf())) {
                    message = new StringBuilder("Unable to describe property ").append(about).append(" because it's 'subPropertyOf' is described as ");
                    message.append((CharSequence)this.getSetComparisonMessage(superProperties, description.getSubPropertyOf()));
                    this.appendPosition(message, description.getAssociatedDeclaration());
                    message.append('.');
                    result.addError((Declaration)localEl, message.toString());
                }
            }
        }
        JavaDoc javaDoc = localEl.getJavaDoc();
        if (localEl != null) {
            javaDoc = new JavaDoc(localEl.getDocComment());
        }
        if (javaDoc != null && !(comment = javaDoc.toString()).isEmpty()) {
            description.addComment(comment);
        }
    }

    private StringBuilder getSetComparisonMessage(Set<String> set1, Set<String> set2) {
        Iterator<String> it;
        StringBuilder setComparisonMessage = new StringBuilder();
        if (set1 == null || set1.isEmpty()) {
            setComparisonMessage.append("empty");
        } else {
            setComparisonMessage.append('[');
            it = set1.iterator();
            while (it.hasNext()) {
                setComparisonMessage.append("\"").append(it.next()).append("\"");
                if (!it.hasNext()) continue;
                setComparisonMessage.append(",");
            }
            setComparisonMessage.append(']');
        }
        setComparisonMessage.append(" which conflicts with ");
        if (set2 == null || set2.isEmpty()) {
            setComparisonMessage.append("the empty set");
        } else {
            setComparisonMessage.append('[');
            it = set2.iterator();
            while (it.hasNext()) {
                setComparisonMessage.append("\"").append(it.next()).append("\"");
                if (!it.hasNext()) continue;
                setComparisonMessage.append(",");
            }
            setComparisonMessage.append(']');
        }
        return setComparisonMessage;
    }

    private Set<String> determineRDFSuperProperties(Accessor accessor, MemberDeclaration declaringMember, ValidationResult result) {
        TreeSet<String> superProperties = new TreeSet<String>();
        RDFSubPropertyOf rdfSubPropertyOf = (RDFSubPropertyOf)accessor.getAnnotation(RDFSubPropertyOf.class);
        if (rdfSubPropertyOf == null && declaringMember != null) {
            rdfSubPropertyOf = (RDFSubPropertyOf)declaringMember.getAnnotation(RDFSubPropertyOf.class);
        }
        if (rdfSubPropertyOf != null) {
            superProperties.addAll(Arrays.asList(rdfSubPropertyOf.value()));
        }
        return superProperties;
    }

    private Set<String> determineRDFRange(Accessor accessor, MemberDeclaration declaringMember, ValidationResult result) {
        Set<String> range = this.getExplicitRange((MemberDeclaration)accessor);
        if (range == null && declaringMember != null) {
            range = this.getExplicitRange(declaringMember);
        }
        if (range == null) {
            org.codehaus.enunciate.contract.jaxb.types.XmlType xmlType = null;
            if (accessor.isElementRef()) {
                try {
                    xmlType = XmlTypeFactory.getXmlType((TypeMirror)accessor.getBareAccessorType());
                }
                catch (XmlTypeException e) {
                    result.addWarning((Declaration)accessor, String.format("Unable to determine range (%s). Please consider explicitly declaring the range of this accessor.", e.getMessage()));
                }
            } else {
                xmlType = accessor.getBaseType();
            }
            if ((range = this.determineRDFRange(xmlType, result)) == null) {
                range = new TreeSet<String>();
                if (!this.isWarningSuppressed(accessor, declaringMember, "rdf:no_range")) {
                    result.addWarning((Declaration)accessor, "Unable to determine range because the accessor type appears to be a resource reference (it declares an rdf:resource attribute). Please consider explicitly declaring the range of this accessor.");
                }
            } else if (range.size() > 1 && range.contains("http://www.w3.org/2000/01/rdf-schema#Literal")) {
                result.addWarning((Declaration)accessor, "This accessor specifies a range that is both literal and non-literal, implying that there is an @XmlValue with @XmlAttribute. This causes an ambiguous RDF schema definition.");
            }
        }
        return range;
    }

    private boolean isWarningSuppressed(Accessor accessor, MemberDeclaration declaringMember, String warning) {
        return !(accessor.getAnnotation(SuppressWarnings.class) != null && !Arrays.asList(((SuppressWarnings)accessor.getAnnotation(SuppressWarnings.class)).value()).contains(warning) || declaringMember != null && declaringMember.getAnnotation(SuppressWarnings.class) != null && !Arrays.asList(((SuppressWarnings)declaringMember.getAnnotation(SuppressWarnings.class)).value()).contains(warning));
    }

    private Set<String> determineRDFRange(org.codehaus.enunciate.contract.jaxb.types.XmlType xmlType, ValidationResult result) {
        TreeSet<String> range = new TreeSet<String>();
        if (xmlType != null) {
            if (this.isResourceRef(xmlType)) {
                return null;
            }
            if (xmlType.isSimple()) {
                range.add("http://www.w3.org/2000/01/rdf-schema#Literal");
            } else {
                TypeDefinition typeDefinition;
                range.add(xmlType.getNamespace() + xmlType.getName());
                if (xmlType instanceof XmlClassType && !(typeDefinition = ((XmlClassType)xmlType).getTypeDefinition()).isBaseObject()) {
                    Set<String> baseRange = this.determineRDFRange(typeDefinition.getBaseType(), result);
                    if (baseRange == null) {
                        return null;
                    }
                    range.addAll(baseRange);
                }
            }
        }
        return range;
    }

    private boolean isResourceRef(org.codehaus.enunciate.contract.jaxb.types.XmlType xmlType) {
        return xmlType instanceof XmlClassType && this.isResourceRef(((XmlClassType)xmlType).getTypeDefinition());
    }

    private boolean isResourceRef(TypeDefinition typeDefinition) {
        for (Attribute attribute : typeDefinition.getAttributes()) {
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attribute.getNamespace()) || !"resource".equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    private Set<String> getExplicitRange(MemberDeclaration member) {
        TreeSet<String> range = null;
        RDFRange rangeInfo = (RDFRange)member.getAnnotation(RDFRange.class);
        if (rangeInfo != null) {
            range = new TreeSet<String>();
            ArrayList<TypeDeclaration> explicitTypes = new ArrayList<TypeDeclaration>();
            try {
                for (Class clazz : rangeInfo.value()) {
                    explicitTypes.add(Context.getCurrentEnvironment().getTypeDeclaration(clazz.getName()));
                }
            }
            catch (MirroredTypesException e) {
                for (TypeMirror typeMirror : e.getTypeMirrors()) {
                    if (!(typeMirror instanceof DeclaredType)) continue;
                    explicitTypes.add(((DeclaredType)typeMirror).getDeclaration());
                }
            }
            for (TypeDeclaration explicitType : explicitTypes) {
                QName about = this.findRDFUri(explicitType);
                if (about == null) continue;
                range.add(about.getNamespaceURI() + about.getLocalPart());
            }
            range.addAll(Arrays.asList(rangeInfo.external()));
        }
        return range;
    }

    private Set<String> determineRDFDomain(Accessor accessor, MemberDeclaration declaringMember, ValidationResult result) {
        Set<String> explicitDomain = this.findExplicitDomain((MemberDeclaration)accessor);
        if (explicitDomain != null) {
            return explicitDomain;
        }
        TypeDeclaration declaringType = accessor.getDeclaringType();
        if (declaringMember != null) {
            explicitDomain = this.findExplicitDomain(declaringMember);
            if (explicitDomain != null) {
                return explicitDomain;
            }
            declaringType = declaringMember.getDeclaringType();
        }
        TreeSet<String> domain = new TreeSet<String>();
        QName rdfUri = this.findRDFUri(declaringType);
        domain.add(rdfUri.getNamespaceURI() + rdfUri.getLocalPart());
        return domain;
    }

    private MemberDeclaration findDeclaringMember(Accessor accessor) {
        DecoratedMethodDeclaration getter;
        MethodDeclaration declaringMethod = null;
        if (accessor.getDelegate() instanceof PropertyDeclaration && (getter = ((PropertyDeclaration)accessor.getDelegate()).getGetter()) != null) {
            MethodDeclaration method = (MethodDeclaration)getter.getDelegate();
            declaringMethod = this.findDeclaringMethod(method.getDeclaringType(), method);
        }
        return declaringMethod;
    }

    private Set<String> findExplicitDomain(MemberDeclaration member) {
        TreeSet<String> explicitDomain = null;
        RDFDomain rdfDomain = (RDFDomain)member.getAnnotation(RDFDomain.class);
        if (rdfDomain != null) {
            explicitDomain = new TreeSet<String>(Arrays.asList(rdfDomain.value()));
        }
        return explicitDomain;
    }

    private MethodDeclaration findDeclaringMethod(TypeDeclaration type, MethodDeclaration method) {
        MethodDeclaration declaringMethod;
        if (type == null || Object.class.getName().equals(type.getQualifiedName())) {
            return null;
        }
        while (method instanceof DecoratedMethodDeclaration) {
            method = (MethodDeclaration)((DecoratedMethodDeclaration)method).getDelegate();
        }
        Declarations declarationUtils = Context.getCurrentEnvironment().getDeclarationUtils();
        Collection superinterfaces = type.getSuperinterfaces();
        if (superinterfaces != null) {
            for (InterfaceType superinterface : superinterfaces) {
                MethodDeclaration declaringMethod2 = this.findDeclaringMethod((TypeDeclaration)superinterface.getDeclaration(), method);
                if (declaringMethod2 == null) continue;
                return declaringMethod2;
            }
        }
        if (type instanceof ClassDeclaration && (declaringMethod = this.findDeclaringMethod((TypeDeclaration)((ClassDeclaration)type).getSuperclass().getDeclaration(), method)) != null) {
            return declaringMethod;
        }
        Collection methods = type.getMethods();
        for (MethodDeclaration candidate : methods) {
            while (candidate instanceof DecoratedMethodDeclaration) {
                candidate = (MethodDeclaration)((DecoratedMethodDeclaration)candidate).getDelegate();
            }
            if (!declarationUtils.overrides(method, candidate)) continue;
            return candidate;
        }
        return null;
    }

    private void describeSchema(SchemaInfo schema, ValidationResult result) {
        RDFSchema.RDFDescription description;
        String desc;
        String label = (String)schema.getProperty("label");
        if (label == null) {
            label = schema.getId();
        }
        if ((desc = (String)schema.getProperty("description")) == null) {
            desc = String.format("Vocabulary definitions for the %s namespace.", schema.getNamespace());
        }
        if ((description = this.rdfSchema.findDescription(schema.getNamespace())) == null) {
            description = new RDFSchema.RDFDescription();
            this.rdfSchema.addDescription(description);
        }
        description.setAbout(schema.getNamespace());
        description.setLabel(label);
        description.addComment(desc);
    }

    private QName findRDFUri(TypeDeclaration typeDeclaration) {
        XmlType xmlType;
        if (typeDeclaration == null || Object.class.getName().equals(typeDeclaration.getQualifiedName())) {
            return null;
        }
        String namespace = "";
        String name = Introspector.decapitalize(typeDeclaration.getSimpleName());
        PackageDeclaration pkg = typeDeclaration.getPackage();
        if (pkg != null && pkg.getAnnotation(XmlSchema.class) != null) {
            namespace = ((XmlSchema)pkg.getAnnotation(XmlSchema.class)).namespace();
        }
        if ((xmlType = (XmlType)typeDeclaration.getAnnotation(XmlType.class)) != null) {
            if (!"##default".equals(xmlType.namespace())) {
                namespace = xmlType.namespace();
            }
            if (!"##default".equals(xmlType.name())) {
                name = xmlType.name();
            }
        }
        return new QName(namespace, name);
    }

    private void describeRDFClasses(TypeDefinition typeDefinition, ValidationResult result) {
        String about;
        RDFSchema.RDFDescription description;
        String namespace = typeDefinition.getNamespace();
        String name = typeDefinition.getName();
        if (name.length() > 0 && !Character.isUpperCase(name.charAt(0))) {
            result.addWarning((Declaration)typeDefinition, "RDF style conventions recommend upper-case names for class definitions. Consider annotating this class with @XmlType(name=\"...\")");
        }
        if ((description = this.rdfSchema.findDescription(about = namespace + name)) == null) {
            description = new RDFSchema.RDFDescription();
            description.setAbout(about);
            description.setIsDefinedBy(namespace);
            description.setType("http://www.w3.org/2000/01/rdf-schema#Class");
            description.setLabel(typeDefinition.getSimpleName());
            description.setAssociatedDeclaration((Declaration)typeDefinition);
            String comment = new JavaDoc(typeDefinition.getDocComment()).toString();
            if (!comment.isEmpty()) {
                description.addComment(comment);
            }
            if (!typeDefinition.isBaseObject()) {
                org.codehaus.enunciate.contract.jaxb.types.XmlType xmlType = typeDefinition.getBaseType();
                if (!xmlType.isSimple()) {
                    description.addSubClassOf(xmlType.getNamespace() + xmlType.getName());
                } else {
                    result.addWarning((Declaration)typeDefinition, String.format("Unable to add %s as a super class of %s because it's a simple type.", xmlType.getNamespace() + xmlType.getName(), about));
                }
            }
            for (String superclass : this.findExplicitSuperclasses((TypeDeclaration)typeDefinition)) {
                description.addSubClassOf(superclass);
            }
            Collection superinterfaces = typeDefinition.getSuperinterfaces();
            if (superinterfaces != null) {
                for (InterfaceType superinterface : superinterfaces) {
                    String resource = this.describeRDFClasses(superinterface.getDeclaration(), result);
                    if (resource == null) continue;
                    description.addSubClassOf(resource);
                }
            }
            this.rdfSchema.addDescription(description);
        } else if (!(description.getAssociatedDeclaration() instanceof TypeDeclaration) || !((TypeDeclaration)description.getAssociatedDeclaration()).getQualifiedName().equals(typeDefinition.getQualifiedName())) {
            StringBuilder message = new StringBuilder("Unable to describe class ").append(about).append(" because it's already described");
            this.appendPosition(message, description.getAssociatedDeclaration());
            message.append('.');
            result.addError((Declaration)typeDefinition, message.toString());
        }
    }

    private Set<String> findExplicitSuperclasses(TypeDeclaration declaration) {
        TreeSet<String> explicitSupers = new TreeSet<String>();
        RDFSubClassOf subClassOf = (RDFSubClassOf)declaration.getAnnotation(RDFSubClassOf.class);
        if (subClassOf != null) {
            explicitSupers.addAll(Arrays.asList(subClassOf.value()));
        }
        return explicitSupers;
    }

    private String describeRDFClasses(InterfaceDeclaration iface, ValidationResult result) {
        String about = null;
        if (iface.getAnnotation(XmlType.class) != null) {
            QName rdfUri = this.findRDFUri((TypeDeclaration)iface);
            String namespace = rdfUri.getNamespaceURI();
            about = namespace + rdfUri.getLocalPart();
            RDFSchema.RDFDescription description = this.rdfSchema.findDescription(about);
            if (description == null) {
                description = new RDFSchema.RDFDescription();
                description.setAbout(about);
                description.setIsDefinedBy(namespace);
                description.setType("http://www.w3.org/2000/01/rdf-schema#Class");
                description.setLabel(iface.getSimpleName());
                description.setAssociatedDeclaration((Declaration)iface);
                String comment = new JavaDoc(iface.getDocComment()).toString();
                if (!comment.isEmpty()) {
                    description.addComment(comment);
                }
                this.rdfSchema.addDescription(description);
                for (String superclass : this.findExplicitSuperclasses((TypeDeclaration)iface)) {
                    description.addSubClassOf(superclass);
                }
                Collection superinterfaces = iface.getSuperinterfaces();
                if (superinterfaces != null) {
                    for (InterfaceType superinterface : superinterfaces) {
                        String resource = this.describeRDFClasses(superinterface.getDeclaration(), result);
                        if (resource == null) continue;
                        description.addSubClassOf(resource);
                    }
                }
            } else if (!(description.getAssociatedDeclaration() instanceof TypeDeclaration) || !((TypeDeclaration)description.getAssociatedDeclaration()).getQualifiedName().equals(iface.getQualifiedName())) {
                StringBuilder message = new StringBuilder("Unable to describe class ").append(about).append(" because it's already described");
                this.appendPosition(message, description.getAssociatedDeclaration());
                message.append('.');
                result.addError((Declaration)iface, message.toString());
            }
        }
        return about;
    }

    protected void loadKnownRDFSchemaDescriptions() {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = JAXBContext.newInstance((Class[])new Class[]{RDFSchema.class}).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        URL resource = RDFProcessor.class.getResource("dcterms.rdf.xml");
        if (resource != null) {
            this.loadRDFSchema(unmarshaller, resource);
        }
        this.addDescription("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID", true, true);
        this.addDescription("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", true, true);
        this.addDescription("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", true, true);
        this.addDescription("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "value", true, true);
        this.addDescription("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type", true, false);
        this.addDescription("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description", true, false);
        this.addDescription("http://www.w3.org/XML/1998/namespace", "lang", true, true);
    }

    protected void loadRDFSchema(Unmarshaller unmarshaller, URL schemaUrl) {
        try {
            InputStream stream = schemaUrl.openStream();
            RDFSchema schema = (RDFSchema)unmarshaller.unmarshal(stream);
            this.rdfSchema.addDescriptions(schema);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read resource %s: %s", schemaUrl, e.getMessage()));
        }
    }

    protected void addDescription(String namespace, String name, boolean property, boolean literal) {
        RDFSchema.RDFDescription description = new RDFSchema.RDFDescription();
        description.setAbout(namespace + name);
        if (property) {
            description.setType("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
        }
        if (literal) {
            description.setRange(new TreeSet<String>());
            description.getRange().add("http://www.w3.org/2000/01/rdf-schema#Literal");
        }
        description.setIsDefinedBy(namespace);
        this.rdfSchema.addDescription(description);
    }

    private void appendPosition(StringBuilder message, Declaration associatedDeclaration) {
        if (associatedDeclaration != null) {
            message.append(" as defined by ");
            if (associatedDeclaration.getPosition() != null) {
                message.append(associatedDeclaration.getPosition());
            } else if (associatedDeclaration instanceof MemberDeclaration) {
                TypeDeclaration declaringType = ((MemberDeclaration)associatedDeclaration).getDeclaringType();
                if (declaringType != null) {
                    message.append(declaringType.getQualifiedName()).append('#');
                }
                message.append(associatedDeclaration instanceof TypeDeclaration ? ((TypeDeclaration)associatedDeclaration).getQualifiedName() : associatedDeclaration.getSimpleName());
            }
        }
    }
}

