/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.build.enunciate;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedClassType;
import net.sf.jelly.apt.decorations.type.DecoratedInterfaceType;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.jaxb.AnyElement;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.Registry;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.SimpleTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Value;
import org.codehaus.enunciate.contract.jaxb.types.KnownXmlType;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.qname.XmlQNameEnum;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.rt.SupportsExtensionAttributes;
import org.gedcomx.rt.SupportsExtensionElements;
import org.gedcomx.rt.json.JsonElementWrapper;

public class GedcomxValidator
extends BaseValidator {
    private final Map<String, Declaration> jsonNameDeclarations = new HashMap<String, Declaration>();

    public ValidationResult validate(EnunciateFreemarkerModel model) {
        ValidationResult result = super.validate(model);
        for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
            for (Registry registry : schemaInfo.getRegistries()) {
                Collection localElements = registry.getLocalElementDeclarations();
                for (LocalElementDeclaration localElement : localElements) {
                    String jsonName;
                    Declaration previous;
                    JsonElementWrapper elementWrapper = (JsonElementWrapper)localElement.getAnnotation(JsonElementWrapper.class);
                    if (elementWrapper == null || (previous = this.jsonNameDeclarations.put(jsonName = elementWrapper.namespace() + elementWrapper.name(), (Declaration)localElement)) == null) continue;
                    result.addError((Declaration)localElement, "JSON name conflict with " + String.valueOf(previous.getPosition()));
                }
            }
        }
        return result;
    }

    private boolean suppressWarning(Declaration declaration, String warning) {
        SuppressWarnings suppressionInfo = (SuppressWarnings)declaration.getAnnotation(SuppressWarnings.class);
        return suppressionInfo != null && Arrays.asList(suppressionInfo.value()).contains(warning);
    }

    public ValidationResult validateSimpleType(SimpleTypeDefinition simpleType) {
        return this.validateTypeDefinition((TypeDefinition)simpleType);
    }

    public ValidationResult validateEnumType(EnumTypeDefinition enumType) {
        return this.validateTypeDefinition((TypeDefinition)enumType);
    }

    public ValidationResult validateRootElement(RootElementDeclaration rootElementDeclaration) {
        String jsonName;
        Declaration previous;
        ValidationResult result = super.validateRootElement(rootElementDeclaration);
        String namespace = rootElementDeclaration.getNamespace();
        if (namespace == null) {
            namespace = "";
        }
        if (namespace.isEmpty()) {
            result.addError((Declaration)rootElementDeclaration, "Root element should not be in the empty namespace.");
        }
        if (rootElementDeclaration.getName().toLowerCase().startsWith("web")) {
            result.addWarning((Declaration)rootElementDeclaration, "You probably don't want a root element that starts with the name 'web'. Consider renaming using the @XmlRootElement annotation.");
        }
        JsonElementWrapper elementWrapper = (JsonElementWrapper)rootElementDeclaration.getAnnotation(JsonElementWrapper.class);
        if (namespace.startsWith("http://gedcomx.org/") && elementWrapper == null) {
            result.addWarning((Declaration)rootElementDeclaration, "Root elements in the 'http://gedcomx.org/' namespace should probably be annotated with @" + JsonElementWrapper.class.getSimpleName() + ".");
        }
        if (elementWrapper != null && (previous = this.jsonNameDeclarations.put(jsonName = elementWrapper.namespace() + elementWrapper.name(), (Declaration)rootElementDeclaration)) != null) {
            result.addError((Declaration)rootElementDeclaration, "JSON name conflict with " + String.valueOf(previous.getPosition()));
        }
        return result;
    }

    public ValidationResult validateTypeDefinition(TypeDefinition typeDef) {
        AnyElement anyElement;
        SortedSet elements;
        Value value;
        boolean isURI;
        Collection attributes;
        ValidationResult result = new ValidationResult();
        if ("".equals(typeDef.getNamespace())) {
            result.addError((Declaration)typeDef, "Type definition should not be in the empty namespace.");
        }
        if (typeDef.getName().toLowerCase().startsWith("web")) {
            result.addWarning((Declaration)typeDef, "You probably don't want a type definition that starts with the name 'web'. Consider renaming using the @XmlType annotation.");
        }
        if ((attributes = typeDef.getAttributes()) != null && !attributes.isEmpty()) {
            for (Attribute attribute : attributes) {
                TypeMirror accessorType;
                isURI = ((DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)attribute.getAccessorType())).isInstanceOf("org.gedcomx.common.URI");
                if (isURI && !KnownXmlType.ANY_URI.getQname().equals(attribute.getBaseType().getQname())) {
                    result.addError((Declaration)attribute, "Accessors of type 'org.gedcomx.common.URI' should of type xs:anyURI. Please annotate the attribute with @XmlSchemaType(name = \"anyURI\", namespace = XMLConstants.W3C_XML_SCHEMA_NS_URI)");
                }
                if ("id".equalsIgnoreCase(attribute.getName()) && !attribute.isXmlID()) {
                    result.addError((Declaration)attribute, "Id attributes should be annotated as @XmlID.");
                }
                if (!((accessorType = attribute.getAccessorType()) instanceof EnumType) || ((EnumType)accessorType).getDeclaration().getAnnotation(XmlQNameEnum.class) == null) continue;
                result.addError((Declaration)attribute, "Accessors should not reference QName enums directly. You probably want to annotate this accessor with @XmlTransient.");
            }
        }
        if ((value = typeDef.getValue()) != null) {
            TypeMirror accessorType = value.getAccessorType();
            if (accessorType instanceof EnumType && ((EnumType)accessorType).getDeclaration().getAnnotation(XmlQNameEnum.class) != null) {
                result.addError((Declaration)value, "Accessors should not reference QName enums directly. You probably want to annotate this accessor with @XmlTransient.");
            }
            if ((isURI = ((DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)accessorType)).isInstanceOf("org.gedcomx.common.URI")) && !KnownXmlType.ANY_URI.getQname().equals(value.getBaseType().getQname())) {
                result.addError((Declaration)value, "Accessors of type 'org.gedcomx.common.URI' should of type xs:anyURI. Please annotate the value with @XmlSchemaType(name = \"anyURI\", namespace = XMLConstants.W3C_XML_SCHEMA_NS_URI)");
            }
        }
        if ((elements = typeDef.getElements()) != null && !elements.isEmpty()) {
            for (Element element : elements) {
                for (Element choice : element.getChoices()) {
                    QName ref;
                    String ns;
                    TypeMirror accessorType;
                    boolean isURI2 = ((DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)choice.getAccessorType())).isInstanceOf("org.gedcomx.common.URI");
                    if (isURI2 && !KnownXmlType.ANY_URI.getQname().equals(choice.getBaseType().getQname())) {
                        result.addError((Declaration)choice, "Accessors of type 'org.gedcomx.common.URI' should of type xs:anyURI. Please annotate the element with @XmlSchemaType(name = \"anyURI\", namespace = XMLConstants.W3C_XML_SCHEMA_NS_URI)");
                    }
                    if ("href".equals(choice.getName())) {
                        result.addError((Declaration)choice, "Entity links should be make with an attribute named 'href'. You probably need to apply @XmlAttribute.");
                    }
                    if ("type".equals(choice.getName())) {
                        result.addError((Declaration)choice, "Type references should be attributes. You probably need to apply @XmlAttribute.");
                    }
                    if ((accessorType = choice.getAccessorType()) instanceof EnumType && ((EnumType)accessorType).getDeclaration().getAnnotation(XmlQNameEnum.class) != null) {
                        result.addError((Declaration)choice, "Accessors should not reference QName enums directly. You probably want to annotate this accessor with @XmlTransient.");
                    }
                    String string = ns = (ref = choice.getRef()) != null ? ref.getNamespaceURI() : choice.getNamespace();
                    if (ns != null && !"".equals(ns)) continue;
                    result.addError((Declaration)choice, "Choice should not reference the empty namespace.");
                }
                if (!element.isCollectionType()) continue;
                if (!element.isWrapped() && element.getName().endsWith("s")) {
                    if (this.suppressWarning((Declaration)element, "gedcomx:plural_xml_name")) continue;
                    result.addWarning((Declaration)element, "You may want to use @XmlElement to change the name to a non-plural form.");
                    continue;
                }
                String jsonMemberName = element.getJsonMemberName();
                if (!jsonMemberName.endsWith("s")) {
                    if (this.suppressWarning((Declaration)element, "gedcomx:non_plural_json_name")) continue;
                    result.addWarning((Declaration)element, "Collection element should probably have a JSON name that ends with 's'. Consider annotating it with @JsonName.");
                    continue;
                }
                if (element.isWrapped()) continue;
                if (element.getDelegate() instanceof PropertyDeclaration) {
                    DecoratedMethodDeclaration setter;
                    DecoratedMethodDeclaration getter = ((PropertyDeclaration)element.getDelegate()).getGetter();
                    if (getter == null || getter.getAnnotation(JsonProperty.class) == null || !jsonMemberName.equals(((JsonProperty)getter.getAnnotation(JsonProperty.class)).value())) {
                        result.addWarning((Declaration)element, "Collection element is annotated with @JsonName, but the getter needs to also be annotated with @JsonProperty(\"" + jsonMemberName + "\").");
                    }
                    if ((setter = ((PropertyDeclaration)element.getDelegate()).getSetter()) != null && setter.getAnnotation(JsonProperty.class) != null && jsonMemberName.equals(((JsonProperty)setter.getAnnotation(JsonProperty.class)).value())) continue;
                    result.addWarning((Declaration)element, "Collection element is annotated with @JsonName, but the setter needs to also be annotated with @JsonProperty(\"" + jsonMemberName + "\").");
                    continue;
                }
                if (!(element.getDelegate() instanceof FieldDeclaration) || element.getAnnotation(JsonProperty.class) != null && jsonMemberName.equals(((JsonProperty)element.getAnnotation(JsonProperty.class)).value())) continue;
                result.addWarning((Declaration)element, "Collection element is annotated with @JsonName, but the field needs to also be annotated with @JsonProperty(\"" + jsonMemberName + "\").");
            }
        }
        if ((anyElement = typeDef.getAnyElement()) != null) {
            JsonIgnore setterIgnore;
            if (!this.isInstanceOf(typeDef, SupportsExtensionElements.class.getName())) {
                result.addError((Declaration)anyElement, "Type definitions that supply the 'any' element must implement " + SupportsExtensionElements.class.getName() + " so the 'any' elements can be serialized to/from JSON.");
            }
            if (!"extensionElements".equals(anyElement.getSimpleName()) && !this.suppressWarning((Declaration)anyElement, "gedcomx:unconventional_any_element_name")) {
                result.addWarning((Declaration)anyElement, "The 'any' element might be better named 'extensionElements' to conform to convention.");
            }
            JsonIgnore getterIgnore = anyElement.getDelegate() instanceof PropertyDeclaration ? (JsonIgnore)((PropertyDeclaration)anyElement.getDelegate()).getGetter().getAnnotation(JsonIgnore.class) : (JsonIgnore)anyElement.getAnnotation(JsonIgnore.class);
            JsonIgnore jsonIgnore = setterIgnore = anyElement.getDelegate() instanceof PropertyDeclaration ? (JsonIgnore)((PropertyDeclaration)anyElement.getDelegate()).getGetter().getAnnotation(JsonIgnore.class) : getterIgnore;
            if (getterIgnore == null || setterIgnore == null) {
                String message = "Properties annotated with @XmlAnyElement should be annotated with @JsonIgnore.";
                if (anyElement.getDelegate() instanceof PropertyDeclaration) {
                    message = message + " (On both the getter and the setter.)";
                }
                result.addError((Declaration)anyElement, message);
            }
        }
        if (typeDef.isHasAnyAttribute()) {
            if (!this.isInstanceOf(typeDef, SupportsExtensionAttributes.class.getName())) {
                result.addError((Declaration)anyElement, "Type definitions that supply the 'any' attribute must implement " + SupportsExtensionAttributes.class.getName() + " so the 'any' attributes can be serialized to/from JSON.");
            }
            PropertyDeclaration anyAttribute = null;
            for (PropertyDeclaration prop : typeDef.getProperties()) {
                if (prop.getAnnotation(XmlAnyAttribute.class) == null) continue;
                anyAttribute = prop;
            }
            if (anyAttribute == null) {
                for (FieldDeclaration field : typeDef.getFields()) {
                    if (field.getAnnotation(XmlAnyAttribute.class) == null) continue;
                    anyAttribute = field;
                }
            }
            if (anyAttribute != null) {
                JsonIgnore setterIgnore;
                if (!"extensionAttributes".equals(anyAttribute.getSimpleName()) && !this.suppressWarning((Declaration)anyElement, "gedcomx:unconventional_any_attribute_name")) {
                    result.addWarning((Declaration)anyElement, "The 'any' attribute might be better named 'extensionAttributes' to conform to convention.");
                }
                JsonIgnore getterIgnore = anyAttribute instanceof PropertyDeclaration ? (JsonIgnore)anyAttribute.getGetter().getAnnotation(JsonIgnore.class) : (JsonIgnore)anyAttribute.getAnnotation(JsonIgnore.class);
                JsonIgnore jsonIgnore = setterIgnore = anyAttribute instanceof PropertyDeclaration ? (JsonIgnore)anyAttribute.getGetter().getAnnotation(JsonIgnore.class) : getterIgnore;
                if (getterIgnore == null || setterIgnore == null) {
                    String message = "Properties annotated with @XmlAnyAttribute should be annotated with @JsonIgnore.";
                    if (anyAttribute instanceof PropertyDeclaration) {
                        message = message + " (On both the getter and the setter.)";
                    }
                    result.addError((Declaration)anyAttribute, message);
                }
            }
        }
        return result;
    }

    private boolean isInstanceOf(TypeDefinition typeDef, String name) {
        for (InterfaceType interfaceType : typeDef.getSuperinterfaces()) {
            if (!((DecoratedInterfaceType)TypeMirrorDecorator.decorate((TypeMirror)interfaceType)).isInstanceOf(name)) continue;
            return true;
        }
        ClassType superclass = typeDef.getSuperclass();
        return superclass != null && ((DecoratedClassType)TypeMirrorDecorator.decorate((TypeMirror)superclass)).isInstanceOf(name);
    }
}

