/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.build.enunciate.rdf;

import com.sun.mirror.declaration.Declaration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(namespace="http://www.w3.org/1999/02/22-rdf-syntax-ns#", name="RDF")
public class RDFSchema {
    public static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDF_PROPERTY_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Property";
    public static final String RDFS_NAMESPACE = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String RDFS_CLASS_TYPE = "http://www.w3.org/2000/01/rdf-schema#Class";
    public static final String RDFS_LITERAL_RANGE = "http://www.w3.org/2000/01/rdf-schema#Literal";
    public static final String DUBLIN_CORE_NAMESPACE = "http://purl.org/dc/terms/";
    public static final String DUBLIN_CORE_TYPE_NAMESPACE = "http://purl.org/dc/dcmitype/";
    private List<RDFDescription> descriptions;

    @XmlElement(namespace="http://www.w3.org/1999/02/22-rdf-syntax-ns#", name="Description")
    public List<RDFDescription> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<RDFDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(RDFDescription description) {
        if (description != null) {
            if (this.descriptions == null) {
                this.descriptions = new ArrayList<RDFDescription>();
            }
            this.descriptions.add(description);
        }
    }

    public RDFDescription findDescription(String about) {
        RDFDescription description = null;
        if (this.getDescriptions() != null) {
            for (RDFDescription candidate : this.descriptions) {
                if (!about.equals(candidate.getAbout())) continue;
                description = candidate;
                break;
            }
        }
        return description;
    }

    public void addDescriptions(RDFSchema schema) {
        if (this.getDescriptions() == null) {
            this.descriptions = new ArrayList<RDFDescription>();
        }
        this.descriptions.addAll(schema.getDescriptions());
    }

    public static class StringToResourceAdapter
    extends XmlAdapter<RDFResourceReference, String> {
        public String unmarshal(RDFResourceReference v) throws Exception {
            return v == null ? null : v.getResource();
        }

        public RDFResourceReference marshal(String v) throws Exception {
            return v == null ? null : new RDFResourceReference(v);
        }
    }

    public static class RDFResourceReference {
        private String resource;

        public RDFResourceReference() {
        }

        public RDFResourceReference(String resource) {
            this.resource = resource;
        }

        @XmlAttribute(namespace="http://www.w3.org/1999/02/22-rdf-syntax-ns#")
        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }
    }

    public static class RDFDescription {
        private String about;
        private String label;
        private Set<String> comments;
        private String isDefinedBy;
        private String type;
        private Set<String> subClassOf;
        private Set<String> subPropertyOf;
        private Set<String> range;
        private Set<String> domain;
        private Declaration associatedDeclaration;

        @XmlAttribute(namespace="http://www.w3.org/1999/02/22-rdf-syntax-ns#")
        public String getAbout() {
            return this.about;
        }

        public void setAbout(String about) {
            this.about = about;
        }

        @XmlElement(namespace="http://www.w3.org/2000/01/rdf-schema#")
        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        @XmlElement(name="comment", namespace="http://www.w3.org/2000/01/rdf-schema#")
        public Set<String> getComments() {
            return this.comments;
        }

        public void setComments(Set<String> comments) {
            this.comments = comments;
        }

        public void addComment(String comment) {
            if (comment != null) {
                if (this.comments == null) {
                    this.comments = new TreeSet<String>();
                }
                this.comments.add(comment);
            }
        }

        @XmlElement(namespace="http://www.w3.org/2000/01/rdf-schema#")
        @XmlJavaTypeAdapter(value=StringToResourceAdapter.class)
        public String getIsDefinedBy() {
            return this.isDefinedBy;
        }

        public void setIsDefinedBy(String definedBy) {
            this.isDefinedBy = definedBy;
        }

        @XmlElement(namespace="http://www.w3.org/1999/02/22-rdf-syntax-ns#")
        @XmlJavaTypeAdapter(value=StringToResourceAdapter.class)
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @XmlElement(namespace="http://www.w3.org/2000/01/rdf-schema#")
        @XmlJavaTypeAdapter(value=StringToResourceAdapter.class)
        public Set<String> getSubClassOf() {
            return this.subClassOf;
        }

        public void setSubClassOf(Set<String> subClassOf) {
            this.subClassOf = subClassOf;
        }

        public void addSubClassOf(String resource) {
            if (resource != null) {
                if (this.subClassOf == null) {
                    this.subClassOf = new TreeSet<String>();
                }
                this.subClassOf.add(resource);
            }
        }

        @XmlElement(namespace="http://www.w3.org/2000/01/rdf-schema#")
        @XmlJavaTypeAdapter(value=StringToResourceAdapter.class)
        public Set<String> getSubPropertyOf() {
            return this.subPropertyOf;
        }

        public void setSubPropertyOf(Set<String> subPropertyOf) {
            this.subPropertyOf = subPropertyOf;
        }

        @XmlElement(namespace="http://www.w3.org/2000/01/rdf-schema#")
        @XmlJavaTypeAdapter(value=StringToResourceAdapter.class)
        public Set<String> getRange() {
            return this.range;
        }

        public void setRange(Set<String> range) {
            this.range = range;
        }

        @XmlElement(namespace="http://www.w3.org/2000/01/rdf-schema#")
        @XmlJavaTypeAdapter(value=StringToResourceAdapter.class)
        public Set<String> getDomain() {
            return this.domain;
        }

        public void setDomain(Set<String> domain) {
            this.domain = domain;
        }

        @XmlTransient
        public Declaration getAssociatedDeclaration() {
            return this.associatedDeclaration;
        }

        public void setAssociatedDeclaration(Declaration associatedDeclaration) {
            this.associatedDeclaration = associatedDeclaration;
        }

        public boolean isClassDescription() {
            return RDFSchema.RDFS_CLASS_TYPE.equals(this.type);
        }

        public boolean isPropertyDescription() {
            return RDFSchema.RDF_PROPERTY_TYPE.equals(this.type);
        }

        public boolean isLiteral() {
            return this.range != null && this.range.size() == 1 && this.range.contains(RDFSchema.RDFS_LITERAL_RANGE);
        }
    }
}

