/**
 * Copyright 2012 Intellectual Reserve, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gedcomx.conversion.gedcom.dq55;

import java.util.concurrent.atomic.AtomicLong;


public class SequentialIdentifierGenerator {

  private static AtomicLong lastId = new AtomicLong(0);

  public static long getNextId() {
    return lastId.incrementAndGet();
  }

  public static void reset() {
    lastId.set(0);
  }

  private SequentialIdentifierGenerator() { } // added to remove "major" sonar warning
                                              // formatted to minimize impact on code coverage metrics
}
