/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conversion.gedcom.dq55;

import java.io.IOException;
import java.util.List;
import org.folg.gedcom.model.Family;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.Person;
import org.folg.gedcom.model.Repository;
import org.folg.gedcom.model.Source;
import org.folg.gedcom.model.Submitter;
import org.gedcomx.conversion.DefaultGedcomxConversionResult;
import org.gedcomx.conversion.GedcomxConversionResult;
import org.gedcomx.conversion.gedcom.dq55.FamilyMapper;
import org.gedcomx.conversion.gedcom.dq55.LanguageMapping;
import org.gedcomx.conversion.gedcom.dq55.MappingConfig;
import org.gedcomx.conversion.gedcom.dq55.PersonMapper;
import org.gedcomx.conversion.gedcom.dq55.PostProcessor;
import org.gedcomx.conversion.gedcom.dq55.SourceDescriptionMapper;
import org.gedcomx.conversion.gedcom.dq55.SubmitterMapper;

public class GedcomMapper {
    private final PersonMapper personMapper;
    private final FamilyMapper familyMapper;
    private final SubmitterMapper submitterMapper;
    private final SourceDescriptionMapper sourceDescriptionMapper;

    public GedcomMapper(MappingConfig mappingConfig) {
        this(mappingConfig, null);
    }

    public GedcomMapper(MappingConfig mappingConfig, PostProcessor postProcessor) {
        this.personMapper = new PersonMapper(mappingConfig, postProcessor);
        this.familyMapper = new FamilyMapper(mappingConfig);
        this.submitterMapper = new SubmitterMapper();
        this.sourceDescriptionMapper = new SourceDescriptionMapper();
    }

    public GedcomxConversionResult toGedcomx(Gedcom dqGedcom) throws IOException {
        return this.toGedcomx(dqGedcom, new DefaultGedcomxConversionResult());
    }

    public GedcomxConversionResult toGedcomx(Gedcom dqGedcom, GedcomxConversionResult result) throws IOException {
        this.toPersons(dqGedcom.getPeople(), result);
        this.toRelationships(dqGedcom.getFamilies(), dqGedcom, result);
        this.toSourceDescriptions(dqGedcom.getSources(), result);
        this.toOrganizations(dqGedcom.getRepositories(), result);
        if (dqGedcom.getSubmitters() != null && !dqGedcom.getSubmitters().isEmpty()) {
            this.submitterMapper.toContributor((Submitter)dqGedcom.getSubmitters().get(0), result);
        }
        String lang = dqGedcom.getHeader() == null || dqGedcom.getHeader().getLanguage() == null ? null : dqGedcom.getHeader().getLanguage();
        LanguageMapping langMapping = LanguageMapping.fromString(lang);
        String langCode = langMapping == null ? null : langMapping.getLanguageCode();
        result.addLanguage(langCode);
        return result;
    }

    void toPersons(List<Person> dqPersons, GedcomxConversionResult result) throws IOException {
        for (Person person : dqPersons) {
            this.personMapper.toPerson(person, result);
        }
    }

    private void toRelationships(List<Family> dqFamilies, Gedcom dqGedcom, GedcomxConversionResult result) throws IOException {
        for (Family family : dqFamilies) {
            this.familyMapper.toRelationship(family, dqGedcom, result);
        }
    }

    private void toSourceDescriptions(List<Source> dqSources, GedcomxConversionResult result) throws IOException {
        for (Source dqSource : dqSources) {
            this.sourceDescriptionMapper.toSourceDescription(dqSource, result);
        }
    }

    private void toOrganizations(List<Repository> dqRepositories, GedcomxConversionResult result) throws IOException {
        for (Repository dqRepository : dqRepositories) {
            this.sourceDescriptionMapper.toOrganization(dqRepository, result);
        }
    }
}

