/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conversion.gedcom.dq55;

public enum LanguageMapping {
    Afrikaans("af"),
    Albanian("sq"),
    Amharic("am"),
    Anglo_Saxon("ang"),
    Arabic("ar"),
    Armenian("hy"),
    Assamese("as"),
    Belorusian("be"),
    Bengali("bn"),
    Braj("bra"),
    Bulgarian("bg"),
    Burmese("my"),
    Cantonese("zh"),
    Catalan("ca"),
    Catalan_Spn(null),
    Church_Slavic("cu"),
    Czech("cs"),
    Danish("da"),
    Dogri("doi"),
    Dutch("nl"),
    English("en"),
    Esperanto("eo"),
    Estonian("et"),
    Faroese("fo"),
    Finnish("fi"),
    French("fr"),
    German("de"),
    Georgian("ka"),
    Greek("el"),
    Gujarati("gu"),
    Hawaiian("haw"),
    Hebrew("he"),
    Hindi("hi"),
    Hungarian("hu"),
    Icelandic("is"),
    Indonesian("id"),
    Italian("it"),
    Japanese("ja"),
    Kannada("kn"),
    Khmer("km"),
    Konkani("kok"),
    Korean("ko"),
    Lahnda("lah"),
    Lao("lo"),
    Latvian("lv"),
    Lithuanian("lt"),
    Macedonian("mk"),
    Maithili("mai"),
    Malayalam("ml"),
    Mandrin("zh"),
    Manipuri("mni"),
    Marathi("mr"),
    Mewari(null),
    Navaho("nv"),
    Nepali("ne"),
    Norwegian("no"),
    Oriya("or"),
    Pahari("him"),
    Pali("pi"),
    Panjabi("pa"),
    Persian("fa"),
    Polish("pl"),
    Portuguese("pt"),
    Prakrit("pra"),
    Pusto("ps"),
    Rajasthani("raj"),
    Romanian("ro"),
    Russian("ru"),
    Sanskrit("sa"),
    Serb("sr"),
    Serbo_Croa("hr"),
    Slovak("sk"),
    Slovene("sl"),
    Spanish("es"),
    Swedish("sv"),
    Tagalog("tl"),
    Tamil("ta"),
    Telugu("te"),
    Thai("th"),
    Tibetan("bo"),
    Turkish("tr"),
    Ukrainian("uk"),
    Urdu("ur"),
    Vietnamese("vi"),
    Wendic(null),
    Yiddish("yi");

    private String languageCode;

    private LanguageMapping(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public static LanguageMapping fromString(String text) {
        if (text == null) {
            return null;
        }
        if (text.contains("-")) {
            text.replaceAll("-", "_");
        }
        for (LanguageMapping mapping : LanguageMapping.values()) {
            if (!mapping.name().equalsIgnoreCase(text)) continue;
            return mapping;
        }
        return null;
    }
}

