/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conversion.gedcom.dq55;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.folg.gedcom.model.EventFact;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.model.LdsOrdinance;
import org.folg.gedcom.model.Name;
import org.folg.gedcom.model.Person;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Gender;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.conclusion.NameForm;
import org.gedcomx.conclusion.NamePart;
import org.gedcomx.conversion.GedcomxConversionResult;
import org.gedcomx.conversion.gedcom.dq55.CommonMapper;
import org.gedcomx.conversion.gedcom.dq55.ConversionContext;
import org.gedcomx.conversion.gedcom.dq55.FactMapper;
import org.gedcomx.conversion.gedcom.dq55.MappingConfig;
import org.gedcomx.conversion.gedcom.dq55.PostProcessor;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.GenderType;
import org.gedcomx.types.NamePartType;
import org.gedcomx.types.NameType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class PersonMapper {
    private static final Logger logger = LoggerFactory.getLogger(CommonMapper.class);
    private final MappingConfig mappingConfig;
    private final PostProcessor postProcessor;

    public PersonMapper(MappingConfig mappingConfig) {
        this(mappingConfig, null);
    }

    public PersonMapper(MappingConfig mappingConfig, PostProcessor postProcessor) {
        this.mappingConfig = mappingConfig;
        this.postProcessor = postProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toPerson(Person dqPerson, GedcomxConversionResult result) throws IOException {
        if (dqPerson == null) {
            return;
        }
        Marker personContext = ConversionContext.getDetachedMarker(String.format("@%s@ INDI", dqPerson.getId()));
        ConversionContext.addReference(personContext);
        try {
            int cntMedia;
            int cntNotes;
            org.gedcomx.conclusion.Person gedxPerson = new org.gedcomx.conclusion.Person();
            gedxPerson.setId(this.mappingConfig.createId(dqPerson.getId()));
            int index = 0;
            ArrayList<org.gedcomx.conclusion.Name> gedxNames = new ArrayList<org.gedcomx.conclusion.Name>();
            for (Name dqName : dqPerson.getNames()) {
                Marker nameContext = ConversionContext.getDetachedMarker("NAME." + ++index);
                ConversionContext.addReference(nameContext);
                try {
                    int cntNamesBeforeThisNameObj = gedxNames.size();
                    gedxNames.addAll(this.toNameList(dqName, result));
                    if (cntNamesBeforeThisNameObj != 0 || gedxNames.size() <= 0) continue;
                    ((org.gedcomx.conclusion.Name)gedxNames.get(0)).setPreferred(Boolean.TRUE);
                }
                finally {
                    ConversionContext.removeReference(nameContext);
                }
            }
            if (gedxNames.size() > 0) {
                gedxPerson.setNames(gedxNames);
            }
            this.processFacts(gedxPerson, dqPerson.getEventsFacts(), result);
            this.processOrdinances(gedxPerson, dqPerson.getLdsOrdinances());
            List<SourceReference> sources = CommonMapper.toSourcesAndSourceReferences(dqPerson.getSourceCitations(), result);
            gedxPerson.setSources(sources);
            Date lastModified = CommonMapper.toDate(dqPerson.getChange());
            if (dqPerson.getAssociations() != null && dqPerson.getAssociations().size() > 0) {
                logger.warn(ConversionContext.getContext(), "Associations ignored.");
            }
            if (dqPerson.getRecordFileNumber() != null) {
                logger.warn(ConversionContext.getContext(), "Record file number ignored: {}", (Object)dqPerson.getRecordFileNumber());
            }
            if (dqPerson.getReferenceNumbers() != null && dqPerson.getReferenceNumbers().size() > 0) {
                for (String each : dqPerson.getReferenceNumbers()) {
                    gedxPerson.addIdentifier(new Identifier().value(new URI(each)).type(new URI("USER_REFERENCE_NUMBER")));
                }
            }
            if (dqPerson.getAncestorInterestSubmitterRef() != null) {
                logger.warn(ConversionContext.getContext(), "Ancestor interest ignored: {}.", (Object)dqPerson.getAncestorInterestSubmitterRef());
            }
            if (dqPerson.getDescendantInterestSubmitterRef() != null) {
                logger.warn(ConversionContext.getContext(), "Descendant interest ignored: {}.", (Object)dqPerson.getDescendantInterestSubmitterRef());
            }
            if (dqPerson.getAddress() != null) {
                logger.warn(ConversionContext.getContext(), "Address was ignored: {}", (Object)dqPerson.getAddress().getDisplayValue());
            }
            if (dqPerson.getEmail() != null) {
                logger.warn(ConversionContext.getContext(), "e-mail ({}) was ignored.", (Object)dqPerson.getEmail());
            }
            if (dqPerson.getFax() != null) {
                logger.warn(ConversionContext.getContext(), "fax ({}) was ignored.", (Object)dqPerson.getFax());
            }
            if (dqPerson.getPhone() != null) {
                logger.warn(ConversionContext.getContext(), "phone ({}) was ignored.", (Object)dqPerson.getPhone());
            }
            if (dqPerson.getWww() != null) {
                logger.warn(ConversionContext.getContext(), "www ({}) was ignored.", (Object)dqPerson.getWww());
            }
            if (dqPerson.getUid() != null) {
                Marker uidContext = ConversionContext.getDetachedMarker(dqPerson.getUidTag());
                ConversionContext.addReference(uidContext);
                logger.warn(ConversionContext.getContext(), "UID ({}) was ignored.", (Object)dqPerson.getUid());
                ConversionContext.removeReference(uidContext);
            }
            if (dqPerson.getRin() != null) {
                logger.warn(ConversionContext.getContext(), "RIN ({}) was ignored.", (Object)dqPerson.getRin());
            }
            if ((cntNotes = dqPerson.getNotes().size() + dqPerson.getNoteRefs().size()) > 0) {
                logger.warn(ConversionContext.getContext(), "Did not process {} notes or references to notes.", (Object)cntNotes);
            }
            if ((cntMedia = dqPerson.getMedia().size() + dqPerson.getMediaRefs().size()) > 0) {
                logger.warn(ConversionContext.getContext(), "Did not process {} media items or references to media items.", (Object)cntMedia);
            }
            if (dqPerson.getExtensions().size() > 0) {
                for (String extensionCategory : dqPerson.getExtensions().keySet()) {
                    for (GedcomTag tag : (List)dqPerson.getExtension(extensionCategory)) {
                        logger.warn(ConversionContext.getContext(), "Unsupported ({}): {}", (Object)extensionCategory, (Object)tag);
                    }
                }
            }
            if (this.postProcessor != null) {
                this.postProcessor.postProcessPerson(dqPerson, gedxPerson);
            }
            result.addPerson(gedxPerson);
        }
        finally {
            ConversionContext.removeReference(personContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFacts(org.gedcomx.conclusion.Person gedxPerson, List<EventFact> facts, GedcomxConversionResult result) throws IOException {
        if (facts == null) {
            return;
        }
        int index = 0;
        for (EventFact fact : facts) {
            Marker factContext = ConversionContext.getDetachedMarker(fact.getTag() + '.' + ++index);
            ConversionContext.addReference(factContext);
            try {
                Fact gedxFact = FactMapper.toFact(fact, result);
                if (gedxFact == null) {
                    fact.getType();
                    if (fact.getTag() != null && fact.getTag().equalsIgnoreCase("SEX")) {
                        this.processSex(gedxPerson, fact);
                    }
                }
                if (gedxFact == null) continue;
                gedxPerson.addFact(gedxFact);
            }
            finally {
                ConversionContext.removeReference(factContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOrdinances(org.gedcomx.conclusion.Person gedxPerson, List<LdsOrdinance> ordinances) throws IOException {
        if (ordinances == null) {
            return;
        }
        int index = 0;
        for (LdsOrdinance ordinance : ordinances) {
            Marker ordinanceContext = ConversionContext.getDetachedMarker(ordinance.getTag() + '.' + ++index);
            ConversionContext.addReference(ordinanceContext);
            try {
                gedxPerson.addFact(FactMapper.toOrdinance(ordinance));
            }
            finally {
                ConversionContext.removeReference(ordinanceContext);
            }
        }
    }

    private void processSex(org.gedcomx.conclusion.Person gedxPerson, EventFact fact) {
        if (gedxPerson.getGender() != null) {
            logger.warn(ConversionContext.getContext(), "Missing gender designation");
        }
        if (fact.getValue().equalsIgnoreCase("M")) {
            gedxPerson.setGender(new Gender(GenderType.Male));
        } else if (fact.getValue().equalsIgnoreCase("F")) {
            gedxPerson.setGender(new Gender(GenderType.Female));
        } else if (fact.getValue().equalsIgnoreCase("U")) {
            gedxPerson.setGender(new Gender(GenderType.Unknown));
        } else {
            logger.warn(ConversionContext.getContext(), "Unrecognized gender designation ({})", (Object)fact.getValue());
        }
    }

    private List<org.gedcomx.conclusion.Name> toNameList(Name dqName, GedcomxConversionResult result) throws IOException {
        int cntMedia;
        int cntNotes;
        ArrayList<org.gedcomx.conclusion.Name> nameList = new ArrayList<org.gedcomx.conclusion.Name>();
        if (dqName == null) {
            return nameList;
        }
        org.gedcomx.conclusion.Name gedxName = new org.gedcomx.conclusion.Name();
        gedxName.setNameForms(new ArrayList());
        NameForm primaryForm = new NameForm();
        primaryForm.setFullText(this.getNameValue(dqName));
        List<NamePart> parts = this.getNameParts(dqName);
        if (parts != null) {
            primaryForm.setParts(parts);
        }
        gedxName.getNameForms().add(primaryForm);
        if (dqName.getFone() != null) {
            NameForm foneNameForm = new NameForm();
            foneNameForm.setFullText(dqName.getFone());
            gedxName.getNameForms().add(foneNameForm);
        }
        if (dqName.getRomn() != null) {
            NameForm romanNameForm = new NameForm();
            romanNameForm.setFullText(dqName.getRomn());
            gedxName.getNameForms().add(romanNameForm);
        }
        nameList.add(gedxName);
        if (dqName.getNickname() != null) {
            org.gedcomx.conclusion.Name gedxNickname = new org.gedcomx.conclusion.Name();
            gedxNickname.setKnownType(NameType.Nickname);
            NameForm nickname = new NameForm();
            nickname.setFullText(dqName.getNickname());
            gedxNickname.setNameForms(Arrays.asList(nickname));
            nameList.add(gedxNickname);
        }
        if (dqName.getMarriedName() != null) {
            org.gedcomx.conclusion.Name gedxMarriedName = new org.gedcomx.conclusion.Name();
            gedxMarriedName.setKnownType(NameType.MarriedName);
            NameForm marriedName = new NameForm();
            marriedName.setFullText(dqName.getMarriedName());
            gedxMarriedName.setNameForms(Arrays.asList(marriedName));
            nameList.add(gedxMarriedName);
        }
        if (dqName.getAka() != null) {
            org.gedcomx.conclusion.Name gedxAka = new org.gedcomx.conclusion.Name();
            gedxAka.setKnownType(NameType.AlsoKnownAs);
            NameForm alias = new NameForm();
            alias.setFullText(dqName.getMarriedName());
            gedxAka.setNameForms(Arrays.asList(alias));
            nameList.add(gedxAka);
        }
        if (dqName.getSourceCitations() != null && dqName.getSourceCitations().size() > 0) {
            List<SourceReference> sources = CommonMapper.toSourcesAndSourceReferences(dqName.getSourceCitations(), result);
            gedxName.setSources(sources);
        }
        if (dqName.getType() != null && dqName.getType().trim().length() > 0) {
            Marker nameTypeContext = ConversionContext.getDetachedMarker(dqName.getTypeTag() == null ? "Undetermined" : dqName.getTypeTag());
            ConversionContext.addReference(nameTypeContext);
            logger.warn(ConversionContext.getContext(), "Name type ({}) was ignored.", (Object)dqName.getType());
            ConversionContext.removeReference(nameTypeContext);
        }
        if ((cntNotes = dqName.getNotes().size() + dqName.getNoteRefs().size()) > 0) {
            logger.warn(ConversionContext.getContext(), "Did not process {} notes or references to notes.", (Object)cntNotes);
        }
        if ((cntMedia = dqName.getMedia().size() + dqName.getMediaRefs().size()) > 0) {
            logger.warn(ConversionContext.getContext(), "Did not process {} media items or references to media items.", (Object)cntMedia);
        }
        if (dqName.getExtensions().size() > 0) {
            for (String extensionCategory : dqName.getExtensions().keySet()) {
                for (GedcomTag tag : (List)dqName.getExtension(extensionCategory)) {
                    logger.warn(ConversionContext.getContext(), "Unsupported ({}): {}", (Object)extensionCategory, (Object)tag);
                }
            }
        }
        return nameList;
    }

    private String getNameValue(Name dqName) {
        int indexOfSlash;
        String value = dqName.getValue();
        if (value == null) {
            return null;
        }
        while ((indexOfSlash = value.indexOf(47)) >= 0) {
            char c;
            boolean replaceWithSpace = false;
            if (indexOfSlash > 0 && indexOfSlash < value.length() - 1 && (c = value.charAt(indexOfSlash - 1)) != ' ' && (c = value.charAt(indexOfSlash + 1)) != ' ') {
                replaceWithSpace = true;
            }
            if (replaceWithSpace) {
                value = this.replaceCharAt(value, indexOfSlash, ' ');
                continue;
            }
            value = this.deleteCharAt(value, indexOfSlash);
        }
        return value.trim();
    }

    private List<NamePart> getNameParts(Name dqName) {
        ArrayList<NamePart> nameParts = new ArrayList<NamePart>(4);
        nameParts.addAll(this.newNamePartInstances(dqName.getPrefix(), NamePartType.Prefix));
        nameParts.addAll(this.newNamePartInstances(dqName.getGiven(), NamePartType.Given));
        nameParts.addAll(this.newNamePartInstances(this.getSurname(dqName), NamePartType.Surname));
        nameParts.addAll(this.newNamePartInstances(dqName.getSuffix(), NamePartType.Suffix));
        return nameParts.size() > 0 ? nameParts : null;
    }

    private String getSurname(Name dqName) {
        if (dqName == null || dqName.getValue() == null && dqName.getSurname() == null) {
            return null;
        }
        String value = dqName.getSurname();
        if (value == null) {
            value = dqName.getValue();
            int slashIndex = value.indexOf(47);
            if (slashIndex >= 0) {
                StringBuilder builder = new StringBuilder(value);
                builder.replace(0, slashIndex + 1, "");
                value = builder.toString();
                slashIndex = value.indexOf(47);
                if (slashIndex >= 0) {
                    builder.replace(slashIndex, builder.length(), "");
                }
                value = builder.toString().trim();
            } else {
                value = null;
            }
        }
        return value;
    }

    private List<NamePart> newNamePartInstances(String value, NamePartType type) {
        String[] pieces;
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<NamePart> nameParts = new ArrayList<NamePart>();
        for (String piece : pieces = value.split(",\\s*")) {
            if ((piece = piece.trim()).equals("")) continue;
            NamePart namePart = new NamePart();
            namePart.setKnownType(type);
            namePart.setValue(piece);
            nameParts.add(namePart);
        }
        return nameParts;
    }

    private String deleteCharAt(String value, int index) {
        if (value == null || index < 0 || index >= value.length()) {
            return value;
        }
        if (index == value.length() - 1) {
            return value.substring(0, index);
        }
        if (index == 0) {
            return value.substring(index + 1);
        }
        return value.substring(0, index) + value.substring(index + 1);
    }

    private String replaceCharAt(String value, int index, char c) {
        if (value == null || index < 0 || index >= value.length()) {
            return value;
        }
        if (index == value.length() - 1) {
            return value.substring(0, index) + c;
        }
        if (index == 0) {
            return c + value.substring(index + 1);
        }
        return value.substring(0, index) + c + value.substring(index + 1);
    }
}

