/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableProxyConverter
extends ThrowableHandlingConverter {
    int lengthOption;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    int errorCount = 0;

    @Override
    public void start() {
        String lengthStr = this.getFirstOption();
        if (lengthStr == null) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("full".equals(lengthStr = lengthStr.toLowerCase())) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("short".equals(lengthStr)) {
            this.lengthOption = 2;
        } else {
            try {
                this.lengthOption = Integer.parseInt(lengthStr) + 1;
            }
            catch (NumberFormatException nfe) {
                this.addError("Could not parser [" + lengthStr + " as an integer");
                this.lengthOption = Integer.MAX_VALUE;
            }
        }
        List<String> optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            int optionListSize = optionList.size();
            for (int i = 1; i < optionListSize; ++i) {
                String evaluatorStr = optionList.get(i);
                Context context = this.getContext();
                Map evaluatorMap = (Map)context.getObject("EVALUATOR_MAP");
                EventEvaluator ee = (EventEvaluator)evaluatorMap.get(evaluatorStr);
                this.addEvaluator(ee);
            }
        }
        super.start();
    }

    private void addEvaluator(EventEvaluator<ILoggingEvent> ee) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add(ee);
    }

    @Override
    public void stop() {
        this.evaluatorList = null;
        super.stop();
    }

    protected void extraData(StringBuilder builder, StackTraceElementProxy step) {
    }

    @Override
    public String convert(ILoggingEvent event) {
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp == null) {
            return "";
        }
        if (this.evaluatorList != null) {
            boolean printStack = true;
            for (int i = 0; i < this.evaluatorList.size(); ++i) {
                EventEvaluator<ILoggingEvent> ee = this.evaluatorList.get(i);
                try {
                    if (!ee.evaluate(event)) continue;
                    printStack = false;
                    break;
                }
                catch (EvaluationException eex) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + ee.getName() + "]", eex);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + ee.getName() + "].", this, eex);
                    errorStatus.add(new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", this));
                    this.addStatus(errorStatus);
                }
            }
            if (!printStack) {
                return "";
            }
        }
        return this.throwableProxyToString(tp);
    }

    protected String throwableProxyToString(IThrowableProxy tp) {
        StringBuilder buf = new StringBuilder(32);
        for (IThrowableProxy currentThrowable = tp; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            this.subjoinThrowableProxy(buf, currentThrowable);
        }
        return buf.toString();
    }

    void subjoinThrowableProxy(StringBuilder buf, IThrowableProxy tp) {
        int maxIndex;
        ThrowableProxyUtil.subjoinFirstLine(buf, tp);
        buf.append(CoreConstants.LINE_SEPARATOR);
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        int commonFrames = tp.getCommonFrames();
        boolean unrestrictedPrinting = this.lengthOption > stepArray.length;
        int n = maxIndex = unrestrictedPrinting ? stepArray.length : this.lengthOption;
        if (commonFrames > 0 && unrestrictedPrinting) {
            maxIndex -= commonFrames;
        }
        for (int i = 0; i < maxIndex; ++i) {
            String string = stepArray[i].toString();
            buf.append('\t');
            buf.append(string);
            this.extraData(buf, stepArray[i]);
            buf.append(CoreConstants.LINE_SEPARATOR);
        }
        if (commonFrames > 0 && unrestrictedPrinting) {
            buf.append("\t... ").append(tp.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }
}

