/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.model;

import java.util.Collections;
import java.util.Map;
import org.folg.gedcom.model.Extensions;
import org.folg.gedcom.model.Visitable;
import org.folg.gedcom.model.Visitor;

public abstract class ExtensionContainer
implements Visitable {
    private Extensions extensions = null;

    public Map<String, Object> getExtensions() {
        return this.extensions != null ? this.extensions.getExtensions() : Collections.emptyMap();
    }

    public Object getExtension(String key) {
        return this.extensions != null ? this.extensions.get(key) : null;
    }

    public void setExtensions(Map<String, Object> exts) {
        if (exts != null && exts.size() > 0) {
            if (this.extensions == null) {
                this.extensions = new Extensions();
            }
            this.extensions.setExtensions(exts);
        } else {
            this.extensions = null;
        }
    }

    public void putExtension(String id, Object extension) {
        if (this.extensions == null) {
            this.extensions = new Extensions();
        }
        this.extensions.put(id, extension);
    }

    public void visitContainedObjects(Visitor visitor) {
        for (Map.Entry<String, Object> entry : this.getExtensions().entrySet()) {
            visitor.visit(entry.getKey(), entry.getValue());
        }
    }
}

