/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.folg.gedcom.model.ChildRef;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.Person;
import org.folg.gedcom.model.PersonFamilyCommonContainer;
import org.folg.gedcom.model.SpouseRef;
import org.folg.gedcom.model.Visitor;

public class Family
extends PersonFamilyCommonContainer {
    private String id = null;
    private List<SpouseRef> husbandRefs = null;
    private List<SpouseRef> wifeRefs = null;
    private List<ChildRef> childRefs = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private List<Person> getFamilyMembers(Gedcom gedcom, List<? extends SpouseRef> memberRefs, boolean preferredFirst) {
        ArrayList<Person> members = new ArrayList<Person>();
        for (SpouseRef spouseRef : memberRefs) {
            Person member = spouseRef.getPerson(gedcom);
            if (member == null) continue;
            if (preferredFirst && "Y".equals(spouseRef.getPreferred())) {
                members.add(0, member);
                continue;
            }
            members.add(member);
        }
        return members;
    }

    public List<Person> getHusbands(Gedcom gedcom) {
        return this.getFamilyMembers(gedcom, this.getHusbandRefs(), true);
    }

    public List<SpouseRef> getHusbandRefs() {
        return this.husbandRefs != null ? this.husbandRefs : Collections.emptyList();
    }

    public void setHusbandRefs(List<SpouseRef> husbandRefs) {
        this.husbandRefs = husbandRefs;
    }

    public void addHusband(SpouseRef husband) {
        if (this.husbandRefs == null) {
            this.husbandRefs = new ArrayList<SpouseRef>();
        }
        this.husbandRefs.add(husband);
    }

    public List<Person> getWives(Gedcom gedcom) {
        return this.getFamilyMembers(gedcom, this.getWifeRefs(), true);
    }

    public List<SpouseRef> getWifeRefs() {
        return this.wifeRefs != null ? this.wifeRefs : Collections.emptyList();
    }

    public void setWifeRefs(List<SpouseRef> wifeRefs) {
        this.wifeRefs = wifeRefs;
    }

    public void addWife(SpouseRef wife) {
        if (this.wifeRefs == null) {
            this.wifeRefs = new ArrayList<SpouseRef>();
        }
        this.wifeRefs.add(wife);
    }

    public List<Person> getChildren(Gedcom gedcom) {
        return this.getFamilyMembers(gedcom, this.getChildRefs(), false);
    }

    public List<ChildRef> getChildRefs() {
        return this.childRefs != null ? this.childRefs : Collections.emptyList();
    }

    public void setChildRefs(List<ChildRef> childRefs) {
        this.childRefs = childRefs;
    }

    public void addChild(ChildRef childRef) {
        if (this.childRefs == null) {
            this.childRefs = new ArrayList<ChildRef>();
        }
        this.childRefs.add(childRef);
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor.visit(this)) {
            for (SpouseRef husband : this.getHusbandRefs()) {
                husband.accept(visitor, true);
            }
            for (SpouseRef wife : this.getWifeRefs()) {
                wife.accept(visitor, false);
            }
            for (ChildRef childRef : this.getChildRefs()) {
                childRef.accept(visitor);
            }
            super.visitContainedObjects(visitor);
            visitor.endVisit(this);
        }
    }
}

