/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.folg.gedcom.model.ExtensionContainer;
import org.folg.gedcom.model.Family;
import org.folg.gedcom.model.Header;
import org.folg.gedcom.model.Media;
import org.folg.gedcom.model.Note;
import org.folg.gedcom.model.Person;
import org.folg.gedcom.model.Repository;
import org.folg.gedcom.model.Source;
import org.folg.gedcom.model.Submission;
import org.folg.gedcom.model.Submitter;
import org.folg.gedcom.model.Visitor;

public class Gedcom
extends ExtensionContainer {
    private Header head = null;
    private Submitter subm = null;
    private Submission subn = null;
    private List<Person> people = null;
    private List<Family> families = null;
    private List<Media> media = null;
    private List<Note> notes = null;
    private List<Source> sources = null;
    private List<Repository> repositories = null;
    private transient Map<String, Person> personIndex;
    private transient Map<String, Family> familyIndex;
    private transient Map<String, Media> mediaIndex;
    private transient Map<String, Note> noteIndex;
    private transient Map<String, Source> sourceIndex;
    private transient Map<String, Repository> repositoryIndex;

    public Header getHeader() {
        return this.head;
    }

    public void setHeader(Header head) {
        this.head = head;
    }

    public List<Person> getPeople() {
        return this.people != null ? this.people : Collections.emptyList();
    }

    public Person getPerson(String id) {
        return this.personIndex.get(id);
    }

    public void setPeople(List<Person> people) {
        this.people = people;
    }

    public void addPerson(Person person) {
        if (this.people == null) {
            this.people = new ArrayList<Person>();
        }
        this.people.add(person);
        if (this.personIndex != null) {
            this.personIndex.put(person.getId(), person);
        }
    }

    public List<Family> getFamilies() {
        return this.families != null ? this.families : Collections.emptyList();
    }

    public Family getFamily(String id) {
        return this.familyIndex.get(id);
    }

    public void setFamilies(List<Family> families) {
        this.families = families;
    }

    public void addFamily(Family family) {
        if (this.families == null) {
            this.families = new ArrayList<Family>();
        }
        this.families.add(family);
        if (this.familyIndex != null) {
            this.familyIndex.put(family.getId(), family);
        }
    }

    public List<Media> getMedia() {
        return this.media != null ? this.media : Collections.emptyList();
    }

    public Media getMedia(String id) {
        return this.mediaIndex.get(id);
    }

    public void setMedia(List<Media> media) {
        this.media = media;
    }

    public void addMedia(Media m) {
        if (this.media == null) {
            this.media = new ArrayList<Media>();
        }
        this.media.add(m);
        if (this.mediaIndex != null) {
            this.mediaIndex.put(m.getId(), m);
        }
    }

    public List<Note> getNotes() {
        return this.notes != null ? this.notes : Collections.emptyList();
    }

    public Note getNote(String id) {
        return this.noteIndex.get(id);
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public void addNote(Note note) {
        if (this.notes == null) {
            this.notes = new ArrayList<Note>();
        }
        this.notes.add(note);
        if (this.noteIndex != null) {
            this.noteIndex.put(note.getId(), note);
        }
    }

    public List<Source> getSources() {
        return this.sources != null ? this.sources : Collections.emptyList();
    }

    public Source getSource(String id) {
        return this.sourceIndex.get(id);
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public void addSource(Source source) {
        if (this.sources == null) {
            this.sources = new ArrayList<Source>();
        }
        this.sources.add(source);
        if (this.sourceIndex != null) {
            this.sourceIndex.put(source.getId(), source);
        }
    }

    public List<Repository> getRepositories() {
        return this.repositories != null ? this.repositories : Collections.emptyList();
    }

    public Repository getRepository(String id) {
        return this.repositoryIndex.get(id);
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories;
    }

    public void addRepository(Repository repository) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
        }
        this.repositories.add(repository);
        if (this.repositoryIndex != null) {
            this.repositoryIndex.put(repository.getId(), repository);
        }
    }

    public Submitter getSubmitter() {
        if (this.subm != null) {
            return this.subm;
        }
        if (this.head != null) {
            return this.head.getSubmitter();
        }
        return null;
    }

    public void setSubmitter(Submitter subm) {
        this.subm = subm;
    }

    public Submission getSubmission() {
        if (this.subn != null) {
            return this.subn;
        }
        if (this.head != null) {
            return this.head.getSubmission();
        }
        return null;
    }

    public void setSubmission(Submission subn) {
        this.subn = subn;
    }

    public void createIndexes() {
        this.personIndex = new HashMap<String, Person>();
        for (Person person : this.getPeople()) {
            this.personIndex.put(person.getId(), person);
        }
        this.familyIndex = new HashMap<String, Family>();
        for (Family family : this.getFamilies()) {
            this.familyIndex.put(family.getId(), family);
        }
        this.mediaIndex = new HashMap<String, Media>();
        for (Media m : this.getMedia()) {
            this.mediaIndex.put(m.getId(), m);
        }
        this.noteIndex = new HashMap<String, Note>();
        for (Note note : this.getNotes()) {
            this.noteIndex.put(note.getId(), note);
        }
        this.sourceIndex = new HashMap<String, Source>();
        for (Source source : this.getSources()) {
            this.sourceIndex.put(source.getId(), source);
        }
        this.repositoryIndex = new HashMap<String, Repository>();
        for (Repository repository : this.getRepositories()) {
            this.repositoryIndex.put(repository.getId(), repository);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor.visit(this)) {
            if (this.head != null) {
                this.head.accept(visitor);
            }
            if (this.subm != null) {
                this.subm.accept(visitor);
            }
            if (this.subn != null) {
                this.subn.accept(visitor);
            }
            for (Person person : this.getPeople()) {
                person.accept(visitor);
            }
            for (Family family : this.getFamilies()) {
                family.accept(visitor);
            }
            for (Media media : this.getMedia()) {
                media.accept(visitor);
            }
            for (Note note : this.getNotes()) {
                note.accept(visitor);
            }
            for (Source source : this.getSources()) {
                source.accept(visitor);
            }
            for (Repository repository : this.getRepositories()) {
                repository.accept(visitor);
            }
            super.visitContainedObjects(visitor);
            visitor.endVisit(this);
        }
    }
}

