/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GedcomTag
implements Comparable<GedcomTag> {
    private static final Logger logger = LoggerFactory.getLogger("org.folg.gedcom.model");
    private String id;
    private String tag;
    private String ref;
    private String value;
    private String parentTagName;
    private List<GedcomTag> children;

    public GedcomTag(String id, String tag, String ref) {
        this.id = id;
        this.tag = tag;
        this.ref = ref;
        this.value = null;
        this.parentTagName = null;
        this.children = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getParentTagName() {
        return this.parentTagName;
    }

    public void setParentTagName(String parentTagName) {
        this.parentTagName = parentTagName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void appendValue(String value) {
        this.value = this.value == null ? value : this.value + value;
    }

    public List<GedcomTag> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    public void setChildren(List<GedcomTag> children) {
        this.children = children;
    }

    public void addChild(GedcomTag child) {
        if (this.children == null) {
            this.children = new ArrayList<GedcomTag>();
        }
        this.children.add(child);
    }

    private ArrayList<GedcomTag> getSortedChildren(List<GedcomTag> children) {
        ArrayList<GedcomTag> sortedChildren = new ArrayList<GedcomTag>(children.size());
        sortedChildren.addAll(children);
        Collections.sort(sortedChildren);
        return sortedChildren;
    }

    public boolean isEmpty() {
        return !(this.id != null && this.id.length() != 0 || this.ref != null && this.ref.length() != 0 || this.parentTagName != null && this.parentTagName.length() != 0 || this.value != null && this.value.length() != 0 || this.children != null && this.children.size() != 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GedcomTag gt = (GedcomTag)o;
        if (!(this.tag == null ? "" : this.tag).equals(gt.tag == null ? "" : gt.tag)) {
            return false;
        }
        if (!(this.id == null ? "" : this.id).equals(gt.id == null ? "" : gt.id)) {
            return false;
        }
        if (!(this.ref == null ? "" : this.ref).equals(gt.ref == null ? "" : gt.ref)) {
            return false;
        }
        if (!(this.parentTagName == null ? "" : this.parentTagName).equals(gt.parentTagName == null ? "" : gt.parentTagName)) {
            return false;
        }
        if (!(this.value == null ? "" : this.value).equals(gt.value == null ? "" : gt.value)) {
            return false;
        }
        if (this.getChildren().size() != gt.getChildren().size()) {
            return false;
        }
        ArrayList<GedcomTag> sortedChildren = this.getSortedChildren(this.getChildren());
        ArrayList<GedcomTag> compareChildren = this.getSortedChildren(gt.getChildren());
        for (int indx = 0; indx < sortedChildren.size(); ++indx) {
            if (sortedChildren.get(indx).equals(compareChildren.get(indx))) continue;
            logger.info("!tag=" + sortedChildren.get(indx).toString() + "<=>" + compareChildren.get(indx).toString());
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.id != null && this.id.length() > 0 ? this.id.hashCode() : 0;
        result = 31 * result + (this.tag != null && this.tag.length() > 0 ? this.tag.hashCode() : 0);
        result = 31 * result + (this.ref != null && this.ref.length() > 0 ? this.ref.hashCode() : 0);
        result = 31 * result + (this.parentTagName != null && this.parentTagName.length() > 0 ? this.parentTagName.hashCode() : 0);
        result = 31 * result + (this.value != null && this.value.length() > 0 ? this.value.hashCode() : 0);
        if (this.children != null) {
            for (GedcomTag child : this.getSortedChildren(this.children)) {
                result = 31 * result + child.hashCode();
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.tag != null) {
            buf.append(" tag:" + this.tag);
        }
        if (this.id != null) {
            buf.append(" id:" + this.id);
        }
        if (this.ref != null) {
            buf.append(" ref:" + this.ref);
        }
        if (this.parentTagName != null) {
            buf.append(" parentTag:" + this.parentTagName);
        }
        if (this.value != null) {
            buf.append(" value:" + this.value);
        }
        if (this.children != null) {
            buf.append(" [");
            for (GedcomTag child : this.getSortedChildren(this.children)) {
                buf.append(child.toString());
            }
            buf.append(" ]");
        }
        return buf.toString();
    }

    @Override
    public int compareTo(GedcomTag tag) {
        int c = (this.getTag() == null ? "" : this.getTag()).compareTo(tag.getTag() == null ? "" : tag.getTag());
        if (c != 0) {
            return c;
        }
        c = (this.getId() == null ? "" : this.getId()).compareTo(tag.getId() == null ? "" : tag.getId());
        if (c != 0) {
            return c;
        }
        c = (this.getRef() == null ? "" : this.getRef()).compareTo(tag.getRef() == null ? "" : tag.getRef());
        if (c != 0) {
            return c;
        }
        c = (this.getParentTagName() == null ? "" : this.getParentTagName()).compareTo(tag.getParentTagName() == null ? "" : tag.getParentTagName());
        if (c != 0) {
            return c;
        }
        c = (this.getValue() == null ? "" : this.getValue()).compareTo(tag.getValue() == null ? "" : tag.getValue());
        if (c != 0) {
            return c;
        }
        return new Integer(this.hashCode()).compareTo(new Integer(tag.hashCode()));
    }
}

