/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.Media;
import org.folg.gedcom.model.MediaRef;
import org.folg.gedcom.model.NoteContainer;
import org.folg.gedcom.model.Visitor;

public abstract class MediaContainer
extends NoteContainer {
    private List<MediaRef> mediaRefs = null;
    private List<Media> media = null;

    public List<Media> getAllMedia(Gedcom gedcom) {
        ArrayList<Media> media = new ArrayList<Media>();
        for (MediaRef mediaRef : this.getMediaRefs()) {
            Media m = mediaRef.getMedia(gedcom);
            if (m == null) continue;
            media.add(m);
        }
        media.addAll(this.getMedia());
        return media;
    }

    public List<MediaRef> getMediaRefs() {
        return this.mediaRefs != null ? this.mediaRefs : Collections.emptyList();
    }

    public void setMediaRefs(List<MediaRef> mediaRefs) {
        this.mediaRefs = mediaRefs;
    }

    public void addMediaRef(MediaRef mediaRef) {
        if (this.mediaRefs == null) {
            this.mediaRefs = new ArrayList<MediaRef>();
        }
        this.mediaRefs.add(mediaRef);
    }

    public List<Media> getMedia() {
        return this.media != null ? this.media : Collections.emptyList();
    }

    public void setMedia(List<Media> media) {
        this.media = media;
    }

    public void addMedia(Media mediaObject) {
        if (this.media == null) {
            this.media = new ArrayList<Media>();
        }
        this.media.add(mediaObject);
    }

    @Override
    public void visitContainedObjects(Visitor visitor) {
        for (MediaRef mediaRef : this.getMediaRefs()) {
            mediaRef.accept(visitor);
        }
        for (Media m : this.getMedia()) {
            m.accept(visitor);
        }
        super.visitContainedObjects(visitor);
    }
}

