/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.folg.gedcom.model.ExtensionContainer;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.Note;
import org.folg.gedcom.model.NoteRef;
import org.folg.gedcom.model.Visitor;

public abstract class NoteContainer
extends ExtensionContainer {
    private List<NoteRef> noteRefs = null;
    private List<Note> notes = null;

    public List<Note> getAllNotes(Gedcom gedcom) {
        ArrayList<Note> notes = new ArrayList<Note>();
        for (NoteRef noteRef : this.getNoteRefs()) {
            Note note = noteRef.getNote(gedcom);
            if (note == null) continue;
            notes.add(note);
        }
        notes.addAll(this.getNotes());
        return notes;
    }

    public List<NoteRef> getNoteRefs() {
        return this.noteRefs != null ? this.noteRefs : Collections.emptyList();
    }

    public void setNoteRefs(List<NoteRef> noteRefs) {
        this.noteRefs = noteRefs;
    }

    public void addNoteRef(NoteRef noteRef) {
        if (this.noteRefs == null) {
            this.noteRefs = new ArrayList<NoteRef>();
        }
        this.noteRefs.add(noteRef);
    }

    public List<Note> getNotes() {
        return this.notes != null ? this.notes : Collections.emptyList();
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public void addNote(Note note) {
        if (this.notes == null) {
            this.notes = new ArrayList<Note>();
        }
        this.notes.add(note);
    }

    @Override
    public void visitContainedObjects(Visitor visitor) {
        for (NoteRef noteRef : this.getNoteRefs()) {
            noteRef.accept(visitor);
        }
        for (Note note : this.getNotes()) {
            note.accept(visitor);
        }
        super.visitContainedObjects(visitor);
    }
}

