/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.folg.gedcom.model.Address;
import org.folg.gedcom.model.Association;
import org.folg.gedcom.model.Family;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.Name;
import org.folg.gedcom.model.ParentFamilyRef;
import org.folg.gedcom.model.PersonFamilyCommonContainer;
import org.folg.gedcom.model.SpouseFamilyRef;
import org.folg.gedcom.model.Visitor;

public class Person
extends PersonFamilyCommonContainer {
    private String id = null;
    private List<Name> names = null;
    private List<ParentFamilyRef> famc = null;
    private List<SpouseFamilyRef> fams = null;
    private List<Association> assos = null;
    private String anci = null;
    private String desi = null;
    private String rfn = null;
    private Address addr = null;
    private String phon = null;
    private String fax = null;
    private String email = null;
    private String emailTag = null;
    private String _www = null;
    private String wwwTag = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Name> getNames() {
        return this.names != null ? this.names : Collections.emptyList();
    }

    public void setNames(List<Name> names) {
        this.names = names;
    }

    public void addName(Name name) {
        if (this.names == null) {
            this.names = new ArrayList<Name>();
        }
        this.names.add(name);
    }

    private List<Family> getFamilies(Gedcom gedcom, List<? extends SpouseFamilyRef> familyRefs) {
        ArrayList<Family> families = new ArrayList<Family>();
        for (SpouseFamilyRef spouseFamilyRef : familyRefs) {
            Family family = spouseFamilyRef.getFamily(gedcom);
            if (family == null) continue;
            families.add(family);
        }
        return families;
    }

    public List<Family> getParentFamilies(Gedcom gedcom) {
        return this.getFamilies(gedcom, this.getParentFamilyRefs());
    }

    public List<ParentFamilyRef> getParentFamilyRefs() {
        return this.famc != null ? this.famc : Collections.emptyList();
    }

    public void setParentFamilyRefs(List<ParentFamilyRef> famc) {
        this.famc = famc;
    }

    public void addParentFamilyRef(ParentFamilyRef parentFamilyRef) {
        if (this.famc == null) {
            this.famc = new ArrayList<ParentFamilyRef>();
        }
        this.famc.add(parentFamilyRef);
    }

    public List<Family> getSpouseFamilies(Gedcom gedcom) {
        return this.getFamilies(gedcom, this.getSpouseFamilyRefs());
    }

    public List<SpouseFamilyRef> getSpouseFamilyRefs() {
        return this.fams != null ? this.fams : Collections.emptyList();
    }

    public void setSpouseFamilyRefs(List<SpouseFamilyRef> fams) {
        this.fams = fams;
    }

    public void addSpouseFamilyRef(SpouseFamilyRef spouseFamilyRef) {
        if (this.fams == null) {
            this.fams = new ArrayList<SpouseFamilyRef>();
        }
        this.fams.add(spouseFamilyRef);
    }

    public List<Association> getAssociations() {
        return this.assos != null ? this.assos : Collections.emptyList();
    }

    public void setAssociations(List<Association> assos) {
        this.assos = assos;
    }

    public void addAssociation(Association asso) {
        if (this.assos == null) {
            this.assos = new ArrayList<Association>();
        }
        this.assos.add(asso);
    }

    public String getAncestorInterestSubmitterRef() {
        return this.anci;
    }

    public void setAncestorInterestSubmitterRef(String anci) {
        this.anci = anci;
    }

    public String getDescendantInterestSubmitterRef() {
        return this.desi;
    }

    public void setDescendantInterestSubmitterRef(String desi) {
        this.desi = desi;
    }

    public String getRecordFileNumber() {
        return this.rfn;
    }

    public void setRecordFileNumber(String rfn) {
        this.rfn = rfn;
    }

    public Address getAddress() {
        return this.addr;
    }

    public void setAddress(Address addr) {
        this.addr = addr;
    }

    public String getPhone() {
        return this.phon;
    }

    public void setPhone(String phon) {
        this.phon = phon;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmailTag() {
        return this.emailTag;
    }

    public void setEmailTag(String emailTag) {
        this.emailTag = emailTag;
    }

    public String getWww() {
        return this._www;
    }

    public void setWww(String www) {
        this._www = www;
    }

    public String getWwwTag() {
        return this.wwwTag;
    }

    public void setWwwTag(String wwwTag) {
        this.wwwTag = wwwTag;
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor.visit(this)) {
            for (Name name : this.getNames()) {
                name.accept(visitor);
            }
            for (ParentFamilyRef parentFamilyRef : this.getParentFamilyRefs()) {
                parentFamilyRef.accept(visitor);
            }
            for (SpouseFamilyRef spouseFamilyRef : this.getSpouseFamilyRefs()) {
                spouseFamilyRef.accept(visitor);
            }
            for (Association association : this.getAssociations()) {
                association.accept(visitor);
            }
            if (this.addr != null) {
                this.addr.accept(visitor);
            }
            super.visitContainedObjects(visitor);
            visitor.endVisit(this);
        }
    }
}

