/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.parser;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.folg.gedcom.model.Extensions;

public class ExtensionsTypeAdapter
implements JsonSerializer<Extensions>,
JsonDeserializer<Extensions> {
    private Gson gson = new Gson();
    private Map<String, Class> classExtensions = new HashMap<String, Class>();
    private Map<String, Type> typeExtensions = new HashMap<String, Type>();

    public void registerExtension(String extensionKey, Class clazz) {
        this.classExtensions.put(extensionKey, clazz);
    }

    public void registerExtension(String extensionKey, Type type) {
        this.typeExtensions.put(extensionKey, type);
    }

    @Override
    public JsonElement serialize(Extensions src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        for (Map.Entry<String, Object> entry : src.getExtensions().entrySet()) {
            String key = entry.getKey();
            Object extension = entry.getValue();
            JsonElement elm = extension instanceof JsonElement ? (JsonElement)extension : this.gson.toJsonTree(extension);
            o.add(key, elm);
        }
        return o;
    }

    @Override
    public Extensions deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject o = json.getAsJsonObject();
        Extensions extensions = new Extensions();
        for (Map.Entry<String, JsonElement> entry : o.entrySet()) {
            Class clazz;
            String key = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            Type type = this.typeExtensions.get(key);
            Object extension = type != null ? this.gson.fromJson(jsonElement, type) : ((clazz = this.classExtensions.get(key)) != null ? this.gson.fromJson(jsonElement, clazz) : jsonElement);
            extensions.put(key, extension);
        }
        return extensions;
    }
}

