/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.folg.gedcom.model.Extensions;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.parser.ExtensionsTypeAdapter;

public class GedcomTypeAdapter
implements JsonSerializer<Gedcom>,
JsonDeserializer<Gedcom> {
    private Gson gson;
    private ExtensionsTypeAdapter extensionsTypeAdapter = new ExtensionsTypeAdapter();

    public GedcomTypeAdapter() {
        this.extensionsTypeAdapter.registerExtension("folg.more_tags", new TypeToken<List<GedcomTag>>(){}.getType());
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Extensions.class), this.extensionsTypeAdapter).create();
    }

    public void registerExtension(String extensionKey, Class clazz) {
        this.extensionsTypeAdapter.registerExtension(extensionKey, clazz);
    }

    public void registerExtension(String extensionKey, Type type) {
        this.extensionsTypeAdapter.registerExtension(extensionKey, type);
    }

    @Override
    public JsonElement serialize(Gedcom src, Type typeOfSrc, JsonSerializationContext context) {
        return this.gson.toJsonTree(src);
    }

    @Override
    public Gedcom deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gedcom gedcom = this.gson.fromJson(json, Gedcom.class);
        gedcom.createIndexes();
        return gedcom;
    }
}

