/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import org.folg.gedcom.model.Address;
import org.folg.gedcom.model.Association;
import org.folg.gedcom.model.Change;
import org.folg.gedcom.model.CharacterSet;
import org.folg.gedcom.model.ChildRef;
import org.folg.gedcom.model.DateTime;
import org.folg.gedcom.model.EventFact;
import org.folg.gedcom.model.ExtensionContainer;
import org.folg.gedcom.model.Family;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.model.GedcomVersion;
import org.folg.gedcom.model.Generator;
import org.folg.gedcom.model.GeneratorCorporation;
import org.folg.gedcom.model.GeneratorData;
import org.folg.gedcom.model.Header;
import org.folg.gedcom.model.LdsOrdinance;
import org.folg.gedcom.model.Media;
import org.folg.gedcom.model.MediaContainer;
import org.folg.gedcom.model.MediaRef;
import org.folg.gedcom.model.Name;
import org.folg.gedcom.model.Note;
import org.folg.gedcom.model.NoteContainer;
import org.folg.gedcom.model.NoteRef;
import org.folg.gedcom.model.ParentFamilyRef;
import org.folg.gedcom.model.ParentRelationship;
import org.folg.gedcom.model.Person;
import org.folg.gedcom.model.PersonFamilyCommonContainer;
import org.folg.gedcom.model.Repository;
import org.folg.gedcom.model.RepositoryRef;
import org.folg.gedcom.model.Source;
import org.folg.gedcom.model.SourceCitation;
import org.folg.gedcom.model.SourceCitationContainer;
import org.folg.gedcom.model.SpouseFamilyRef;
import org.folg.gedcom.model.SpouseRef;
import org.folg.gedcom.model.Submission;
import org.folg.gedcom.model.Submitter;
import org.folg.gedcom.model.Trailer;
import org.folg.gedcom.parser.ErrorHandler;
import org.folg.gedcom.parser.FieldRef;
import org.gedml.GedcomParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModelParser
implements ContentHandler,
org.xml.sax.ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger("org.folg.gedcom.parser");
    public static final String MORE_TAGS_EXTENSION_KEY = "folg.more_tags";
    private Locator locator;
    private Stack<String> tagStack;
    private Stack<Object> objectStack;
    private Gedcom gedcom;
    private ErrorHandler errorHandler = null;

    private String joinTagStack() {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < this.tagStack.size(); ++i) {
            if (i > 1) {
                buf.append(' ');
            }
            buf.append((String)this.tagStack.get(i));
        }
        return buf.toString();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.gedcom = null;
        this.tagStack = new Stack();
        this.objectStack = new Stack();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String tagName, String qName, Attributes atts) throws SAXException {
        String tagNameUpper = tagName.toUpperCase();
        String id = atts.getValue("ID");
        String ref = atts.getValue("REF");
        Object tos = this.objectStack.size() > 0 ? this.objectStack.peek() : null;
        Object obj = null;
        try {
            Tag tag = Tag.valueOf(tagNameUpper);
            switch (tag) {
                case ABBR: {
                    obj = this.handleAbbr(tos);
                    break;
                }
                case ADDR: {
                    obj = this.handleAddr(tos);
                    break;
                }
                case ADR1: {
                    obj = this.handleAdr1(tos);
                    break;
                }
                case ADR2: {
                    obj = this.handleAdr2(tos);
                    break;
                }
                case ADR3: {
                    obj = this.handleAdr3(tos);
                    break;
                }
                case _AKA: {
                    obj = this.handleAka(tos, tagName);
                    break;
                }
                case ALIA: {
                    obj = this.handleAlia(tos, ref);
                    break;
                }
                case ANCI: {
                    obj = this.handleAnci(tos, ref);
                    break;
                }
                case ASSO: {
                    obj = this.handleAsso(tos, ref);
                    break;
                }
                case AUTH: {
                    obj = this.handleAuth(tos);
                    break;
                }
                case BLOB: {
                    obj = this.handleBlob(tos);
                    break;
                }
                case CALN: {
                    obj = this.handleCaln(tos);
                    break;
                }
                case CHAN: {
                    obj = this.handleChan(tos);
                    break;
                }
                case CHAR: {
                    obj = this.handleChar(tos);
                    break;
                }
                case CHIL: {
                    obj = this.handleChil(tos, ref);
                    break;
                }
                case CITY: {
                    obj = this.handleCity(tos);
                    break;
                }
                case CONC: {
                    obj = this.handleCont(tos, false);
                    break;
                }
                case CONT: {
                    obj = this.handleCont(tos, true);
                    break;
                }
                case COPR: {
                    obj = this.handleCopr(tos);
                    break;
                }
                case CORP: {
                    obj = this.handleCorp(tos);
                    break;
                }
                case CTRY: {
                    obj = this.handleCtry(tos);
                    break;
                }
                case DATA: {
                    obj = this.handleData(tos);
                    break;
                }
                case DATE: {
                    obj = this.handleDate(tos);
                    break;
                }
                case DESC: {
                    obj = this.handleDesc(tos);
                    break;
                }
                case DESI: {
                    obj = this.handleDesi(tos, ref);
                    break;
                }
                case DEST: {
                    obj = this.handleDest(tos);
                    break;
                }
                case EMAIL: 
                case _EMAIL: 
                case _EML: {
                    obj = this.handleEmail(tos, tagName);
                    break;
                }
                case FAM: {
                    obj = this.handleFam(tos, id);
                    break;
                }
                case FAMC: {
                    obj = this.handleFamc(tos, ref);
                    break;
                }
                case FAMS: {
                    obj = this.handleFams(tos, ref);
                    break;
                }
                case FAX: {
                    obj = this.handleFax(tos);
                    break;
                }
                case _FILE: 
                case FILE: {
                    obj = this.handleFile(tos, tagName);
                    break;
                }
                case FORM: {
                    obj = this.handleForm(tos);
                    break;
                }
                case _FREL: {
                    obj = this.handleFRel(tos);
                    break;
                }
                case GED: {
                    obj = this.handleGed();
                    break;
                }
                case GEDC: {
                    obj = this.handleGedc(tos);
                    break;
                }
                case GIVN: {
                    obj = this.handleGivn(tos);
                    break;
                }
                case HEAD: {
                    obj = this.handleHead(tos);
                    break;
                }
                case HUSB: {
                    obj = this.handleHusb(tos, ref);
                    break;
                }
                case INDI: {
                    obj = this.handleIndi(tos, id);
                    break;
                }
                case _ITALIC: {
                    obj = this.handleItalic(tos);
                    break;
                }
                case LANG: {
                    obj = this.handleLang(tos);
                    break;
                }
                case _MARRNM: 
                case _MARNM: 
                case _MAR: {
                    obj = this.handleMarrnm(tos, tagName);
                    break;
                }
                case MEDI: {
                    obj = this.handleMedi(tos);
                    break;
                }
                case _MREL: {
                    obj = this.handleMRel(tos);
                    break;
                }
                case NAME: 
                case _NAME: {
                    obj = this.handleName(tos);
                    break;
                }
                case NICK: {
                    obj = this.handleNick(tos);
                    break;
                }
                case NPFX: {
                    obj = this.handleNpfx(tos);
                    break;
                }
                case NSFX: {
                    obj = this.handleNsfx(tos);
                    break;
                }
                case NOTE: {
                    obj = this.handleNote(tos, id, ref);
                    break;
                }
                case OBJE: {
                    obj = this.handleObje(tos, id, ref);
                    break;
                }
                case ORDI: {
                    obj = this.handleOrdi(tos);
                    break;
                }
                case PAGE: {
                    obj = this.handlePage(tos);
                    break;
                }
                case _PAREN: {
                    obj = this.handleParen(tos);
                    break;
                }
                case PEDI: {
                    obj = this.handlePedi(tos);
                    break;
                }
                case PHON: {
                    obj = this.handlePhon(tos);
                    break;
                }
                case PLAC: {
                    obj = this.handlePlac(tos);
                    break;
                }
                case POST: {
                    obj = this.handlePost(tos);
                    break;
                }
                case _PREF: {
                    obj = this.handlePref(tos);
                    break;
                }
                case _PRIM: 
                case _PRIMARY: {
                    obj = this.handlePrim(tos);
                    break;
                }
                case PUBL: {
                    obj = this.handlePubl(tos);
                    break;
                }
                case QUAY: {
                    obj = this.handleQuay(tos);
                    break;
                }
                case REFN: {
                    obj = this.handleRefn(tos);
                    break;
                }
                case RELA: {
                    obj = this.handleRela(tos);
                    break;
                }
                case REPO: {
                    obj = this.handleRepo(tos, id, ref);
                    break;
                }
                case RFN: {
                    obj = this.handleRfn(tos);
                    break;
                }
                case RIN: {
                    obj = this.handleRin(tos);
                    break;
                }
                case _SCBK: {
                    obj = this.handleScbk(tos);
                    break;
                }
                case SOUR: {
                    obj = this.handleSour(tos, id, ref);
                    break;
                }
                case SPFX: {
                    obj = this.handleSpfx(tos);
                    break;
                }
                case _SSHOW: {
                    obj = this.handleSshow(tos);
                    break;
                }
                case STAE: {
                    obj = this.handleStae(tos);
                    break;
                }
                case STAT: {
                    obj = this.handleStat(tos);
                    break;
                }
                case SUBM: {
                    obj = this.handleSubm(tos, id, ref);
                    break;
                }
                case SUBN: {
                    obj = this.handleSubn(tos, id, ref);
                    break;
                }
                case SURN: {
                    obj = this.handleSurn(tos);
                    break;
                }
                case TEMP: {
                    obj = this.handleTemp(tos);
                    break;
                }
                case TEXT: {
                    obj = this.handleText(tos);
                    break;
                }
                case TIME: {
                    obj = this.handleTime(tos);
                    break;
                }
                case TITL: {
                    obj = this.handleTitl(tos);
                    break;
                }
                case TRLR: {
                    obj = this.handleTrlr(tos);
                    break;
                }
                case TYPE: 
                case _TYPE: {
                    obj = this.handleType(tos, tagName);
                    break;
                }
                case VERS: {
                    obj = this.handleVers(tos);
                    break;
                }
                case _UID: 
                case UID: {
                    obj = this.handleUid(tos, tagName);
                    break;
                }
                case WIFE: {
                    obj = this.handleWife(tos, ref);
                    break;
                }
                case WWW: 
                case _WWW: 
                case _WEB: 
                case _URL: {
                    obj = this.handleWww(tos, tagName);
                    break;
                }
                case BAPL: 
                case CONL: 
                case ENDL: 
                case SLGC: {
                    obj = this.handleLdsOrdinance(tos, true, tagNameUpper);
                    break;
                }
                case SLGS: {
                    obj = this.handleLdsOrdinance(tos, false, tagNameUpper);
                    break;
                }
                default: {
                    throw new SAXParseException("handler not found for tag: " + tag.name(), this.locator);
                }
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (obj == null) {
            obj = this.handleEventFact(tos, tagName, tagNameUpper);
        }
        if (obj == null) {
            obj = new GedcomTag(id, tagName, ref);
            if (tos instanceof ExtensionContainer) {
                this.addGedcomTag((ExtensionContainer)tos, (GedcomTag)obj);
            } else if (tos instanceof GedcomTag) {
                ((GedcomTag)tos).addChild((GedcomTag)obj);
            } else if (tos instanceof FieldRef && ((FieldRef)tos).getTarget() instanceof ExtensionContainer) {
                ((GedcomTag)obj).setParentTagName(this.tagStack.peek());
                ExtensionContainer ec = (ExtensionContainer)((FieldRef)tos).getTarget();
                this.addGedcomTag(ec, (GedcomTag)obj);
            } else {
                this.error(new SAXParseException("Dropped tag: " + this.joinTagStack() + " " + tagName, this.locator));
            }
        }
        this.tagStack.push(tagName);
        this.objectStack.push(obj);
    }

    private void addGedcomTag(ExtensionContainer ec, GedcomTag tag) throws SAXException {
        ArrayList<GedcomTag> moreTags = (ArrayList<GedcomTag>)ec.getExtension(MORE_TAGS_EXTENSION_KEY);
        if (moreTags == null) {
            moreTags = new ArrayList<GedcomTag>();
            ec.putExtension(MORE_TAGS_EXTENSION_KEY, moreTags);
        }
        moreTags.add(tag);
        this.warning(new SAXParseException("Tag added as extension: " + this.joinTagStack() + " " + tag.getTag(), this.locator));
    }

    private Object handleAbbr(Object tos) {
        if (tos instanceof Source && ((Source)tos).getAbbreviation() == null) {
            return new FieldRef(tos, "Abbreviation");
        }
        return null;
    }

    private Object handleAddr(Object tos) {
        if (tos instanceof GeneratorCorporation && ((GeneratorCorporation)tos).getAddress() == null || tos instanceof EventFact && ((EventFact)tos).getAddress() == null || tos instanceof Person && ((Person)tos).getAddress() == null || tos instanceof Repository && ((Repository)tos).getAddress() == null || tos instanceof Submitter && ((Submitter)tos).getAddress() == null) {
            Address address = new Address();
            if (tos instanceof GeneratorCorporation) {
                ((GeneratorCorporation)tos).setAddress(address);
            } else if (tos instanceof EventFact) {
                ((EventFact)tos).setAddress(address);
            } else if (tos instanceof Person) {
                ((Person)tos).setAddress(address);
            } else if (tos instanceof Repository) {
                ((Repository)tos).setAddress(address);
            } else {
                ((Submitter)tos).setAddress(address);
            }
            return address;
        }
        return null;
    }

    private Object handleAdr1(Object tos) {
        if (tos instanceof Address && ((Address)tos).getAddressLine1() == null) {
            return new FieldRef(tos, "AddressLine1");
        }
        return null;
    }

    private Object handleAdr2(Object tos) {
        if (tos instanceof Address && ((Address)tos).getAddressLine2() == null) {
            return new FieldRef(tos, "AddressLine2");
        }
        return null;
    }

    private Object handleAdr3(Object tos) {
        if (tos instanceof Address && ((Address)tos).getAddressLine3() == null) {
            return new FieldRef(tos, "AddressLine3");
        }
        return null;
    }

    private Object handleAka(Object tos, String tagName) {
        if (tos instanceof Name && ((Name)tos).getAka() == null) {
            ((Name)tos).setAkaTag(tagName);
            return new FieldRef(tos, "Aka");
        }
        return null;
    }

    private Object handleAlia(Object tos, String ref) {
        if (tos instanceof Person && ref == null) {
            Name name = new Name();
            name.setType("ALIA");
            ((Person)tos).addName(name);
            return name;
        }
        return null;
    }

    private Object handleAnci(Object tos, String ref) {
        if (tos instanceof Person && ((Person)tos).getAncestorInterestSubmitterRef() == null && ref != null) {
            ((Person)tos).setAncestorInterestSubmitterRef(ref);
            return new FieldRef(tos, "AncestorInterestSubmitterRef");
        }
        return null;
    }

    private Object handleAsso(Object tos, String ref) {
        if (tos instanceof Person) {
            Association association = new Association();
            if (ref != null) {
                association.setRef(ref);
            }
            ((Person)tos).addAssociation(association);
            return association;
        }
        return null;
    }

    private Object handleAuth(Object tos) {
        if (tos instanceof Source && ((Source)tos).getAuthor() == null) {
            return new FieldRef(tos, "Author");
        }
        return null;
    }

    private Object handleBlob(Object tos) {
        if (tos instanceof Media && ((Media)tos).getBlob() == null) {
            return new FieldRef(tos, "Blob");
        }
        return null;
    }

    private Object handleCaln(Object tos) {
        if (tos instanceof RepositoryRef && ((RepositoryRef)tos).getCallNumber() == null || tos instanceof Source && ((Source)tos).getCallNumber() == null) {
            return new FieldRef(tos, "CallNumber");
        }
        return null;
    }

    private Object handleChan(Object tos) {
        if (tos instanceof PersonFamilyCommonContainer && ((PersonFamilyCommonContainer)tos).getChange() == null || tos instanceof Media && ((Media)tos).getChange() == null || tos instanceof Note && ((Note)tos).getChange() == null || tos instanceof Source && ((Source)tos).getChange() == null || tos instanceof Repository && ((Repository)tos).getChange() == null || tos instanceof Submitter && ((Submitter)tos).getChange() == null) {
            Change change = new Change();
            if (tos instanceof PersonFamilyCommonContainer) {
                ((PersonFamilyCommonContainer)tos).setChange(change);
            } else if (tos instanceof Media) {
                ((Media)tos).setChange(change);
            } else if (tos instanceof Note) {
                ((Note)tos).setChange(change);
            } else if (tos instanceof Source) {
                ((Source)tos).setChange(change);
            } else if (tos instanceof Repository) {
                ((Repository)tos).setChange(change);
            } else {
                ((Submitter)tos).setChange(change);
            }
            return change;
        }
        return null;
    }

    private Object handleChar(Object tos) {
        if (tos instanceof Header && ((Header)tos).getCharacterSet() == null) {
            CharacterSet charset = new CharacterSet();
            ((Header)tos).setCharacterSet(charset);
            return charset;
        }
        return null;
    }

    private Object handleChil(Object tos, String ref) {
        if (tos instanceof Family) {
            ChildRef childRef = new ChildRef();
            childRef.setRef(ref);
            ((Family)tos).addChild(childRef);
            return childRef;
        }
        return null;
    }

    private Object handleCity(Object tos) {
        if (tos instanceof Address && ((Address)tos).getCity() == null) {
            return new FieldRef(tos, "City");
        }
        return null;
    }

    private Object handleCont(Object tos, boolean insertNewLine) throws SAXException {
        FieldRef fieldRef = tos instanceof FieldRef ? (FieldRef)tos : new FieldRef(tos, "Value");
        if (insertNewLine) {
            try {
                fieldRef.appendValue("\n");
            }
            catch (NoSuchMethodException e) {
                SAXParseException exception = new SAXParseException("value not stored for: " + this.joinTagStack(), this.locator);
                this.error(exception);
            }
        }
        return fieldRef;
    }

    private Object handleCopr(Object tos) {
        if (tos instanceof Header && ((Header)tos).getCopyright() == null || tos instanceof GeneratorData && ((GeneratorData)tos).getCopyright() == null) {
            return new FieldRef(tos, "Copyright");
        }
        return null;
    }

    private Object handleCorp(Object tos) {
        if (tos instanceof Generator && ((Generator)tos).getGeneratorCorporation() == null) {
            GeneratorCorporation generatorCorporation = new GeneratorCorporation();
            ((Generator)tos).setGeneratorCorporation(generatorCorporation);
            return generatorCorporation;
        }
        return null;
    }

    private Object handleCtry(Object tos) {
        if (tos instanceof Address && ((Address)tos).getCountry() == null) {
            return new FieldRef(tos, "Country");
        }
        return null;
    }

    private Object handleData(Object tos) {
        if (tos instanceof Generator && ((Generator)tos).getGeneratorData() == null) {
            GeneratorData generatorData = new GeneratorData();
            ((Generator)tos).setGeneratorData(generatorData);
            return generatorData;
        }
        if (tos instanceof SourceCitation) {
            if (((SourceCitation)tos).getDataTagContents() == SourceCitation.DataTagContents.DATE || ((SourceCitation)tos).getDataTagContents() == SourceCitation.DataTagContents.TEXT) {
                ((SourceCitation)tos).setDataTagContents(SourceCitation.DataTagContents.SEPARATE);
            }
            return tos;
        }
        return null;
    }

    private void setDataTagContents(Object tos, boolean addDate) {
        if (this.objectStack.size() > 1 && this.objectStack.get(this.objectStack.size() - 2) instanceof SourceCitation) {
            SourceCitation.DataTagContents dataTagContents = ((SourceCitation)tos).getDataTagContents();
            if (dataTagContents == null && addDate) {
                dataTagContents = SourceCitation.DataTagContents.DATE;
            } else if (dataTagContents == null && !addDate) {
                dataTagContents = SourceCitation.DataTagContents.TEXT;
            } else if (dataTagContents == SourceCitation.DataTagContents.TEXT && addDate || dataTagContents == SourceCitation.DataTagContents.DATE && !addDate) {
                dataTagContents = SourceCitation.DataTagContents.COMBINED;
            }
            ((SourceCitation)tos).setDataTagContents(dataTagContents);
        }
    }

    private Object handleDate(Object tos) {
        if (tos instanceof GeneratorData && ((GeneratorData)tos).getDate() == null || tos instanceof Source && ((Source)tos).getDate() == null || tos instanceof EventFact && ((EventFact)tos).getDate() == null) {
            return new FieldRef(tos, "Date");
        }
        if (tos instanceof SourceCitation && ((SourceCitation)tos).getDate() == null) {
            this.setDataTagContents(tos, true);
            return new FieldRef(tos, "Date");
        }
        if (tos instanceof Header && ((Header)tos).getDateTime() == null || tos instanceof Change && ((Change)tos).getDateTime() == null) {
            DateTime dateTime = new DateTime();
            if (tos instanceof Header) {
                ((Header)tos).setDateTime(dateTime);
            } else {
                ((Change)tos).setDateTime(dateTime);
            }
            return dateTime;
        }
        return null;
    }

    private Object handleDesc(Object tos) {
        if (tos instanceof Submission && ((Submission)tos).getDescription() == null) {
            return new FieldRef(tos, "Description");
        }
        return null;
    }

    private Object handleDesi(Object tos, String ref) {
        if (tos instanceof Person && ((Person)tos).getDescendantInterestSubmitterRef() == null && ref != null) {
            ((Person)tos).setDescendantInterestSubmitterRef(ref);
            return new FieldRef(tos, "DescendantInterestSubmitterRef");
        }
        return null;
    }

    private Object handleDest(Object tos) {
        if (tos instanceof Header && ((Header)tos).getDestination() == null) {
            return new FieldRef(tos, "Destination");
        }
        return null;
    }

    private Object handleEmail(Object tos, String tagName) {
        if (tos instanceof Submitter && ((Submitter)tos).getEmail() == null || tos instanceof GeneratorCorporation && ((GeneratorCorporation)tos).getEmail() == null || tos instanceof EventFact && ((EventFact)tos).getEmail() == null || tos instanceof Person && ((Person)tos).getEmail() == null || tos instanceof Repository && ((Repository)tos).getEmail() == null) {
            if (tos instanceof Submitter) {
                ((Submitter)tos).setEmailTag(tagName);
            } else if (tos instanceof GeneratorCorporation) {
                ((GeneratorCorporation)tos).setEmailTag(tagName);
            } else if (tos instanceof EventFact) {
                ((EventFact)tos).setEmailTag(tagName);
            } else if (tos instanceof Person) {
                ((Person)tos).setEmailTag(tagName);
            } else {
                ((Repository)tos).setEmailTag(tagName);
            }
            return new FieldRef(tos, "Email");
        }
        return null;
    }

    private Object handleEventFact(Object tos, String tagName, String tagNameUpper) {
        if (tos instanceof Person && EventFact.PERSONAL_EVENT_FACT_TAGS.contains(tagNameUpper) || tos instanceof Family && EventFact.FAMILY_EVENT_FACT_TAGS.contains(tagNameUpper) || tos instanceof EventFact && "CAUS".equals(tagNameUpper) && ((EventFact)tos).getCause() == null) {
            EventFact eventFact = new EventFact();
            eventFact.setTag(tagName);
            if (tos instanceof EventFact) {
                ((EventFact)tos).setCause(eventFact);
            } else {
                ((PersonFamilyCommonContainer)tos).addEventFact(eventFact);
            }
            return eventFact;
        }
        return null;
    }

    private Object handleFam(Object tos, String id) {
        if (tos instanceof Gedcom) {
            Family family = new Family();
            family.setId(id);
            ((Gedcom)tos).addFamily(family);
            return family;
        }
        return null;
    }

    private Object handleFamc(Object tos, String ref) {
        if (tos instanceof Person) {
            ParentFamilyRef parentFamilyRef = new ParentFamilyRef();
            parentFamilyRef.setRef(ref);
            ((Person)tos).addParentFamilyRef(parentFamilyRef);
            return parentFamilyRef;
        }
        return null;
    }

    private Object handleFams(Object tos, String ref) {
        if (tos instanceof Person) {
            SpouseFamilyRef spouseFamilyRef = new SpouseFamilyRef();
            spouseFamilyRef.setRef(ref);
            ((Person)tos).addSpouseFamilyRef(spouseFamilyRef);
            return spouseFamilyRef;
        }
        return null;
    }

    private Object handleFax(Object tos) {
        if (tos instanceof GeneratorCorporation && ((GeneratorCorporation)tos).getFax() == null || tos instanceof Repository && ((Repository)tos).getFax() == null || tos instanceof EventFact && ((EventFact)tos).getFax() == null || tos instanceof Person && ((Person)tos).getFax() == null || tos instanceof Submitter && ((Submitter)tos).getFax() == null) {
            return new FieldRef(tos, "Fax");
        }
        return null;
    }

    private Object handleFile(Object tos, String tagName) {
        if (tos instanceof Header && ((Header)tos).getFile() == null) {
            return new FieldRef(tos, "File");
        }
        if (tos instanceof Media && ((Media)tos).getFile() == null) {
            ((Media)tos).setFileTag(tagName);
            return new FieldRef(tos, "File");
        }
        return null;
    }

    private Object handleForm(Object tos) {
        if (tos instanceof GedcomVersion && ((GedcomVersion)tos).getForm() == null) {
            return new FieldRef(tos, "Form");
        }
        if (tos instanceof Media && ((Media)tos).getFormat() == null) {
            return new FieldRef(tos, "Format");
        }
        return null;
    }

    private Object handleFRel(Object tos) {
        if (tos instanceof ChildRef && ((ChildRef)tos).getFatherRelationship() == null) {
            ParentRelationship parentRelationship = new ParentRelationship();
            ((ChildRef)tos).setFatherRelationship(parentRelationship);
            return parentRelationship;
        }
        return null;
    }

    private Object handleGed() {
        this.gedcom = new Gedcom();
        return this.gedcom;
    }

    private Object handleGedc(Object tos) {
        if (tos instanceof Header && ((Header)tos).getGedcomVersion() == null) {
            GedcomVersion gedcomVersion = new GedcomVersion();
            ((Header)tos).setGedcomVersion(gedcomVersion);
            return gedcomVersion;
        }
        return null;
    }

    private Object handleGivn(Object tos) {
        if (tos instanceof Name && ((Name)tos).getGiven() == null) {
            return new FieldRef(tos, "Given");
        }
        return null;
    }

    private Object handleHead(Object tos) {
        if (tos instanceof Gedcom && ((Gedcom)tos).getHeader() == null) {
            Header header = new Header();
            ((Gedcom)tos).setHeader(header);
            return header;
        }
        return null;
    }

    private Object handleHusb(Object tos, String ref) {
        if (tos instanceof Family) {
            SpouseRef spouseRef = new SpouseRef();
            spouseRef.setRef(ref);
            ((Family)tos).addHusband(spouseRef);
            return spouseRef;
        }
        return null;
    }

    private Object handleIndi(Object tos, String id) {
        if (tos instanceof Gedcom) {
            Person person = new Person();
            person.setId(id);
            ((Gedcom)tos).addPerson(person);
            return person;
        }
        return null;
    }

    private Object handleItalic(Object tos) {
        if (tos instanceof Source && ((Source)tos).getItalic() == null) {
            return new FieldRef(tos, "Italic");
        }
        return null;
    }

    private Object handleLang(Object tos) {
        if (tos instanceof Submitter && ((Submitter)tos).getLanguage() == null || tos instanceof Header && ((Header)tos).getLanguage() == null) {
            return new FieldRef(tos, "Language");
        }
        return null;
    }

    private Object handleLdsOrdinance(Object tos, boolean isPersonalOrdinance, String tagName) {
        if (tos instanceof Person && isPersonalOrdinance || tos instanceof Family && !isPersonalOrdinance) {
            LdsOrdinance ldsOrdinance = new LdsOrdinance();
            ((PersonFamilyCommonContainer)tos).addLdsOrdinance(ldsOrdinance);
            ldsOrdinance.setTag(tagName);
            return ldsOrdinance;
        }
        return null;
    }

    private Object handleMarrnm(Object tos, String tagName) {
        if (tos instanceof Name && ((Name)tos).getMarriedName() == null) {
            ((Name)tos).setMarriedNameTag(tagName);
            return new FieldRef(tos, "MarriedName");
        }
        return null;
    }

    private Object handleMedi(Object tos) {
        if (tos instanceof Source && ((Source)tos).getMediaType() == null) {
            return new FieldRef(tos, "MediaType");
        }
        if (tos instanceof FieldRef && ((FieldRef)tos).getTarget() instanceof RepositoryRef && ((FieldRef)tos).getFieldName().equals("CallNumber") && ((RepositoryRef)((FieldRef)tos).getTarget()).getMediaType() == null) {
            ((RepositoryRef)((FieldRef)tos).getTarget()).setMediUnderCalnTag(true);
            return new FieldRef(((FieldRef)tos).getTarget(), "MediaType");
        }
        return null;
    }

    private Object handleMRel(Object tos) {
        if (tos instanceof ChildRef && ((ChildRef)tos).getMotherRelationship() == null) {
            ParentRelationship parentRelationship = new ParentRelationship();
            ((ChildRef)tos).setMotherRelationship(parentRelationship);
            return parentRelationship;
        }
        return null;
    }

    private Object handleName(Object tos) {
        if (tos instanceof Generator && ((Generator)tos).getName() == null || tos instanceof Repository && ((Repository)tos).getName() == null || tos instanceof Address && ((Address)tos).getName() == null || tos instanceof Submitter && ((Submitter)tos).getName() == null) {
            return new FieldRef(tos, "Name");
        }
        if (tos instanceof Person) {
            Name name = new Name();
            ((Person)tos).addName(name);
            return name;
        }
        return null;
    }

    private Object handleNick(Object tos) {
        if (tos instanceof Name && ((Name)tos).getNickname() == null) {
            return new FieldRef(tos, "Nickname");
        }
        return null;
    }

    private Object handleNpfx(Object tos) {
        if (tos instanceof Name && ((Name)tos).getPrefix() == null) {
            return new FieldRef(tos, "Prefix");
        }
        return null;
    }

    private Object handleNsfx(Object tos) {
        if (tos instanceof Name && ((Name)tos).getSuffix() == null) {
            return new FieldRef(tos, "Suffix");
        }
        return null;
    }

    private Object handleNote(Object tos, String id, String ref) {
        if (tos instanceof NoteContainer) {
            if (ref == null) {
                Note note = new Note();
                ((NoteContainer)tos).addNote(note);
                return note;
            }
            NoteRef noteRef = new NoteRef();
            noteRef.setRef(ref);
            ((NoteContainer)tos).addNoteRef(noteRef);
            return noteRef;
        }
        if (tos instanceof Gedcom) {
            Note note = new Note();
            if (id != null) {
                note.setId(id);
            }
            if (ref != null) {
                note.setValue("@" + ref + "@");
            }
            ((Gedcom)tos).addNote(note);
            return note;
        }
        return null;
    }

    private Object handleObje(Object tos, String id, String ref) {
        if (tos instanceof MediaContainer) {
            if (ref == null) {
                Media media = new Media();
                ((MediaContainer)tos).addMedia(media);
                return media;
            }
            MediaRef mediaRef = new MediaRef();
            mediaRef.setRef(ref);
            ((MediaContainer)tos).addMediaRef(mediaRef);
            return mediaRef;
        }
        if (tos instanceof Gedcom) {
            Media media = new Media();
            if (id != null) {
                media.setId(id);
            }
            ((Gedcom)tos).addMedia(media);
            return media;
        }
        return null;
    }

    private Object handleOrdi(Object tos) {
        if (tos instanceof Submission && ((Submission)tos).getOrdinanceFlag() == null) {
            return new FieldRef(tos, "OrdinanceFlag");
        }
        return null;
    }

    private Object handlePage(Object tos) {
        if (tos instanceof SourceCitation && ((SourceCitation)tos).getPage() == null) {
            return new FieldRef(tos, "Page");
        }
        return null;
    }

    private Object handleParen(Object tos) {
        if (tos instanceof Source && ((Source)tos).getParen() == null) {
            return new FieldRef(tos, "Paren");
        }
        return null;
    }

    private Object handlePedi(Object tos) {
        if (tos instanceof ParentFamilyRef && ((ParentFamilyRef)tos).getRelationshipType() == null) {
            return new FieldRef(tos, "RelationshipType");
        }
        return null;
    }

    private Object handlePhon(Object tos) {
        if (tos instanceof GeneratorCorporation && ((GeneratorCorporation)tos).getPhone() == null || tos instanceof Repository && ((Repository)tos).getPhone() == null || tos instanceof EventFact && ((EventFact)tos).getPhone() == null || tos instanceof Person && ((Person)tos).getPhone() == null || tos instanceof Submitter && ((Submitter)tos).getPhone() == null) {
            return new FieldRef(tos, "Phone");
        }
        return null;
    }

    private Object handlePlac(Object tos) {
        if (tos instanceof EventFact && ((EventFact)tos).getPlace() == null) {
            return new FieldRef(tos, "Place");
        }
        return null;
    }

    private Object handlePost(Object tos) {
        if (tos instanceof Address && ((Address)tos).getPostalCode() == null) {
            return new FieldRef(tos, "PostalCode");
        }
        return null;
    }

    private Object handlePref(Object tos) {
        if (tos instanceof SpouseRef && ((SpouseRef)tos).getPreferred() == null) {
            return new FieldRef(tos, "Preferred");
        }
        return null;
    }

    private Object handlePrim(Object tos) {
        if (tos instanceof Media && ((Media)tos).getPrimary() == null || tos instanceof ParentFamilyRef && ((ParentFamilyRef)tos).getPrimary() == null) {
            return new FieldRef(tos, "Primary");
        }
        return null;
    }

    private Object handlePubl(Object tos) {
        if (tos instanceof Source && ((Source)tos).getPublicationFacts() == null) {
            return new FieldRef(tos, "PublicationFacts");
        }
        return null;
    }

    private Object handleQuay(Object tos) {
        if (tos instanceof SourceCitation && ((SourceCitation)tos).getQuality() == null) {
            return new FieldRef(tos, "Quality");
        }
        return null;
    }

    private Object handleRefn(Object tos) {
        if (tos instanceof PersonFamilyCommonContainer) {
            return new FieldRef(tos, "ReferenceNumber");
        }
        if (tos instanceof Source && ((Source)tos).getReferenceNumber() == null) {
            return new FieldRef(tos, "ReferenceNumber");
        }
        return null;
    }

    private Object handleRela(Object tos) {
        if (tos instanceof Association && ((Association)tos).getRelation() == null) {
            return new FieldRef(tos, "Relation");
        }
        return null;
    }

    private Object handleRepo(Object tos, String id, String ref) {
        if (tos instanceof Source && ((Source)tos).getRepositoryRef() == null) {
            RepositoryRef repositoryRef = new RepositoryRef();
            if (ref != null) {
                repositoryRef.setRef(ref);
            }
            ((Source)tos).setRepositoryRef(repositoryRef);
            return repositoryRef;
        }
        if (tos instanceof Gedcom) {
            Repository repository = new Repository();
            if (id != null) {
                repository.setId(id);
            }
            ((Gedcom)tos).addRepository(repository);
            return repository;
        }
        return null;
    }

    private Object handleRfn(Object tos) {
        if (tos instanceof Person && ((Person)tos).getRecordFileNumber() == null) {
            return new FieldRef(tos, "RecordFileNumber");
        }
        return null;
    }

    private Object handleRin(Object tos) {
        if (tos instanceof Submitter && ((Submitter)tos).getRin() == null || tos instanceof Note && ((Note)tos).getRin() == null || tos instanceof Repository && ((Repository)tos).getRin() == null || tos instanceof EventFact && ((EventFact)tos).getRin() == null || tos instanceof Source && ((Source)tos).getRin() == null || tos instanceof PersonFamilyCommonContainer && ((PersonFamilyCommonContainer)tos).getRin() == null) {
            return new FieldRef(tos, "Rin");
        }
        return null;
    }

    private Object handleScbk(Object tos) {
        if (tos instanceof Media && ((Media)tos).getScrapbook() == null) {
            return new FieldRef(tos, "Scrapbook");
        }
        return null;
    }

    private Object handleSour(Object tos, String id, String ref) {
        if (tos instanceof Header && ((Header)tos).getGenerator() == null) {
            Generator generator = new Generator();
            ((Header)tos).setGenerator(generator);
            return generator;
        }
        if (tos instanceof SourceCitationContainer || tos instanceof Note || tos instanceof NoteRef || tos instanceof FieldRef && ((FieldRef)tos).getTarget() instanceof Note && ((FieldRef)tos).getFieldName().equals("Value")) {
            SourceCitation sourceCitation = new SourceCitation();
            if (ref != null) {
                sourceCitation.setRef(ref);
            }
            if (tos instanceof SourceCitationContainer) {
                ((SourceCitationContainer)tos).addSourceCitation(sourceCitation);
            } else if (tos instanceof Note) {
                ((Note)tos).addSourceCitation(sourceCitation);
            } else if (tos instanceof NoteRef) {
                ((NoteRef)tos).addSourceCitation(sourceCitation);
            } else {
                Note note = (Note)((FieldRef)tos).getTarget();
                note.addSourceCitation(sourceCitation);
                note.setSourceCitationsUnderValue(true);
            }
            return sourceCitation;
        }
        if (tos instanceof Gedcom) {
            Source source = new Source();
            if (id != null) {
                source.setId(id);
            }
            ((Gedcom)tos).addSource(source);
            return source;
        }
        return null;
    }

    private Object handleSpfx(Object tos) {
        if (tos instanceof Name && ((Name)tos).getSurnamePrefix() == null) {
            return new FieldRef(tos, "SurnamePrefix");
        }
        return null;
    }

    private Object handleSshow(Object tos) {
        if (tos instanceof Media && ((Media)tos).getSlideShow() == null) {
            return new FieldRef(tos, "SlideShow");
        }
        return null;
    }

    private Object handleStae(Object tos) {
        if (tos instanceof Address && ((Address)tos).getState() == null) {
            return new FieldRef(tos, "State");
        }
        return null;
    }

    private Object handleStat(Object tos) {
        if (tos instanceof LdsOrdinance && ((LdsOrdinance)tos).getStatus() == null) {
            return new FieldRef(tos, "Status");
        }
        return null;
    }

    private Object handleSubm(Object tos, String id, String ref) {
        if (tos instanceof Header && ref != null && ((Header)tos).getSubmitterRef() == null) {
            ((Header)tos).setSubmitterRef(ref);
            return new Object();
        }
        if (tos instanceof Header && ref == null && ((Header)tos).getSubmitter() == null) {
            Submitter submitter = new Submitter();
            ((Header)tos).setSubmitter(submitter);
            return submitter;
        }
        if (tos instanceof Gedcom && ((Gedcom)tos).getSubmitter() == null) {
            Submitter submitter = new Submitter();
            if (id != null) {
                submitter.setId(id);
            }
            ((Gedcom)tos).setSubmitter(submitter);
            return submitter;
        }
        return null;
    }

    private Object handleSubn(Object tos, String id, String ref) {
        if (tos instanceof Header && ref != null && ((Header)tos).getSubmissionRef() == null) {
            ((Header)tos).setSubmissionRef(ref);
            return new Object();
        }
        if (tos instanceof Header && ref == null && ((Header)tos).getSubmission() == null) {
            Submission submission = new Submission();
            ((Header)tos).setSubmission(submission);
            return submission;
        }
        if (tos instanceof Gedcom && ((Gedcom)tos).getSubmission() == null) {
            Submission submission = new Submission();
            if (id != null) {
                submission.setId(id);
            }
            ((Gedcom)tos).setSubmission(submission);
            return submission;
        }
        return null;
    }

    private Object handleSurn(Object tos) {
        if (tos instanceof Name && ((Name)tos).getSurname() == null) {
            return new FieldRef(tos, "Surname");
        }
        return null;
    }

    private Object handleTemp(Object tos) {
        if (tos instanceof LdsOrdinance && ((LdsOrdinance)tos).getTemple() == null) {
            return new FieldRef(tos, "Temple");
        }
        return null;
    }

    private Object handleText(Object tos) {
        if (tos instanceof SourceCitation) {
            this.setDataTagContents(tos, false);
            String text = ((SourceCitation)tos).getText();
            if (text != null) {
                ((SourceCitation)tos).setText(text + "\n");
            }
            return new FieldRef(tos, "Text");
        }
        if (tos instanceof Source) {
            String text = ((Source)tos).getText();
            if (text != null) {
                ((Source)tos).setText(text + "\n");
            }
            return new FieldRef(tos, "Text");
        }
        return null;
    }

    private Object handleTime(Object tos) {
        if (tos instanceof DateTime && ((DateTime)tos).getTime() == null) {
            return new FieldRef(tos, "Time");
        }
        return null;
    }

    private Object handleTitl(Object tos) {
        if (tos instanceof Media && ((Media)tos).getTitle() == null || tos instanceof Source && ((Source)tos).getTitle() == null) {
            return new FieldRef(tos, "Title");
        }
        if (tos instanceof Person) {
            Name name = new Name();
            name.setType("TITL");
            ((Person)tos).addName(name);
            return name;
        }
        return null;
    }

    private Object handleTrlr(Object tos) {
        if (tos instanceof Gedcom) {
            return new Trailer();
        }
        return null;
    }

    private Object handleType(Object tos, String tagName) {
        if (tos instanceof Name && ((Name)tos).getType() == null || tos instanceof Media && ((Media)tos).getType() == null || tos instanceof EventFact && ((EventFact)tos).getType() == null || tos instanceof Association && ((Association)tos).getType() == null || tos instanceof Source && ((Source)tos).getType() == null) {
            if (tos instanceof Source) {
                ((Source)tos).setTypeTag(tagName);
            } else if (tos instanceof Name) {
                ((Name)tos).setTypeTag(tagName);
            }
            return new FieldRef(tos, "Type");
        }
        return null;
    }

    private Object handleUid(Object tos, String tagName) {
        if (tos instanceof PersonFamilyCommonContainer && ((PersonFamilyCommonContainer)tos).getUid() == null || tos instanceof EventFact && ((EventFact)tos).getUid() == null || tos instanceof Source && ((Source)tos).getUid() == null) {
            if (tos instanceof PersonFamilyCommonContainer) {
                ((PersonFamilyCommonContainer)tos).setUidTag(tagName);
            } else if (tos instanceof EventFact) {
                ((EventFact)tos).setUidTag(tagName);
            } else {
                ((Source)tos).setUidTag(tagName);
            }
            return new FieldRef(tos, "Uid");
        }
        return null;
    }

    private Object handleVers(Object tos) {
        if (tos instanceof Generator && ((Generator)tos).getVersion() == null || tos instanceof GedcomVersion && ((GedcomVersion)tos).getVersion() == null || tos instanceof CharacterSet && ((CharacterSet)tos).getVersion() == null) {
            return new FieldRef(tos, "Version");
        }
        return null;
    }

    private Object handleWife(Object tos, String ref) {
        if (tos instanceof Family) {
            SpouseRef spouseRef = new SpouseRef();
            spouseRef.setRef(ref);
            ((Family)tos).addWife(spouseRef);
            return spouseRef;
        }
        return null;
    }

    private Object handleWww(Object tos, String tagName) {
        if (tos instanceof GeneratorCorporation && ((GeneratorCorporation)tos).getWww() == null || tos instanceof Repository && ((Repository)tos).getWww() == null || tos instanceof EventFact && ((EventFact)tos).getWww() == null || tos instanceof Person && ((Person)tos).getWww() == null || tos instanceof Submitter && ((Submitter)tos).getWww() == null) {
            if (tos instanceof GeneratorCorporation) {
                ((GeneratorCorporation)tos).setWwwTag(tagName);
            } else if (tos instanceof Repository) {
                ((Repository)tos).setWwwTag(tagName);
            } else if (tos instanceof EventFact) {
                ((EventFact)tos).setWwwTag(tagName);
            } else if (tos instanceof Person) {
                ((Person)tos).setWwwTag(tagName);
            } else {
                ((Submitter)tos).setWwwTag(tagName);
            }
            return new FieldRef(tos, "Www");
        }
        return null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.objectStack.pop();
        this.tagStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        Object tos = this.objectStack.size() > 0 ? this.objectStack.peek() : null;
        FieldRef fieldRef = null;
        try {
            if (tos instanceof GedcomTag) {
                ((GedcomTag)tos).appendValue(value);
            } else if (tos instanceof FieldRef) {
                fieldRef = (FieldRef)tos;
                fieldRef.appendValue(value);
            } else {
                fieldRef = new FieldRef(tos, "Value");
                fieldRef.setValue(value);
            }
        }
        catch (NoSuchMethodException e) {
            if (fieldRef.getFieldName().equals("Value")) {
                SAXParseException exception = new SAXParseException("value not stored for: " + this.joinTagStack(), this.locator);
                this.error(exception);
            }
            SAXParseException exception = new SAXParseException("get method not found for: " + fieldRef.getClassFieldName(), this.locator);
            this.fatalError(exception);
            throw exception;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception.getMessage(), exception.getLineNumber());
        } else {
            logger.info(exception.getMessage() + " @ " + exception.getLineNumber());
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(exception.getMessage(), exception.getLineNumber());
        } else {
            logger.warn(exception.getMessage() + " @ " + exception.getLineNumber());
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception.getMessage(), exception.getLineNumber());
        } else {
            logger.error(exception.getMessage() + " @ " + exception.getLineNumber());
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Gedcom parseGedcom(File gedcomFile) throws SAXParseException, IOException {
        GedcomParser parser = new GedcomParser();
        parser.setContentHandler(this);
        parser.setErrorHandler(this);
        parser.parse(gedcomFile.toURI().toString());
        return this.gedcom;
    }

    public static enum Tag {
        ABBR,
        ADDR,
        ADR1,
        ADR2,
        ADR3,
        _AKA,
        ALIA,
        ANCI,
        ASSO,
        AUTH,
        BLOB,
        CALN,
        CHAN,
        CHAR,
        CHIL,
        CITY,
        CONC,
        CONT,
        COPR,
        CORP,
        CTRY,
        DATA,
        DATE,
        DESC,
        DESI,
        DEST,
        EMAIL,
        _EMAIL,
        _EML,
        FAM,
        FAMC,
        FAMS,
        FAX,
        _FILE,
        FILE,
        FORM,
        _FREL,
        GED,
        GEDC,
        GIVN,
        HEAD,
        HUSB,
        INDI,
        _ITALIC,
        LANG,
        _MARRNM,
        _MAR,
        _MARNM,
        MEDI,
        _MREL,
        NAME,
        _NAME,
        NICK,
        NOTE,
        NPFX,
        NSFX,
        OBJE,
        ORDI,
        PAGE,
        _PAREN,
        PEDI,
        PHON,
        POST,
        PLAC,
        _PREF,
        _PRIM,
        _PRIMARY,
        PUBL,
        QUAY,
        REFN,
        RELA,
        REPO,
        RFN,
        RIN,
        _SCBK,
        SOUR,
        SPFX,
        _SSHOW,
        STAE,
        STAT,
        SUBM,
        SUBN,
        SURN,
        TEMP,
        TEXT,
        TIME,
        TITL,
        TRLR,
        TYPE,
        _TYPE,
        UID,
        _UID,
        _URL,
        VERS,
        WIFE,
        _WEB,
        WWW,
        _WWW,
        BAPL,
        CONL,
        ENDL,
        SLGC,
        SLGS;

    }
}

