/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.parser;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.parser.ErrorHandler;
import org.gedml.GedcomParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TreeParser
implements ContentHandler,
org.xml.sax.ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger("org.folg.gedcom.parser");
    private Locator locator;
    private GedcomTag tree;
    private Stack<GedcomTag> nodeStack;
    private ErrorHandler errorHandler = null;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.tree = null;
        this.nodeStack = new Stack();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        GedcomTag node = new GedcomTag(atts.getValue("ID"), localName, atts.getValue("REF"));
        if (this.tree == null) {
            this.tree = node;
        } else {
            this.nodeStack.peek().addChild(node);
        }
        this.nodeStack.push(node);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.nodeStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        GedcomTag tos = this.nodeStack.peek();
        tos.appendValue(s);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception.getMessage(), exception.getLineNumber());
        } else {
            logger.info(exception.getMessage() + " @ " + exception.getLineNumber());
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(exception.getMessage(), exception.getLineNumber());
        } else {
            logger.warn(exception.getMessage() + " @ " + exception.getLineNumber());
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception.getMessage(), exception.getLineNumber());
        } else {
            logger.error(exception.getMessage() + " @ " + exception.getLineNumber());
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public List<GedcomTag> parseGedcom(File gedcomFile) throws SAXParseException, IOException {
        GedcomParser parser = new GedcomParser();
        parser.setContentHandler(this);
        parser.setErrorHandler(this);
        parser.parse(gedcomFile.toURI().toString());
        return this.tree.getChildren();
    }
}

