/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.parser.ErrorHandler;
import org.folg.gedcom.parser.ModelParser;
import org.folg.gedcom.parser.TreeParser;
import org.folg.gedcom.visitors.GedcomWriter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class CompareGedcom2Gedcom
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger("org.folg.gedcom.tools");
    @Option(name="-i", required=true, usage="file or directory containing gedcom files to convert")
    private File gedcomIn;
    @Option(name="-o", required=false, usage="temporary directory to store generated gedcom in")
    private File gedcomOut;
    private int totalGedcoms = 0;
    private int equalsCount = 0;
    private int expectedNotEqualsCount = 0;
    private int unexpectedNotEqualsCount = 0;
    private boolean hasError;
    private boolean logWarningsErrors;
    private String currentFilename = null;

    @Override
    public void warning(String message, int lineNumber) {
        if (this.logWarningsErrors) {
            logger.warn(message + " @ " + lineNumber);
        }
    }

    @Override
    public void error(String message, int lineNumber) {
        this.hasError = true;
        if (this.logWarningsErrors) {
            logger.error(message + " @ " + lineNumber + " => " + this.currentFilename);
        }
    }

    @Override
    public void fatalError(String message, int lineNumber) {
    }

    public void convertAndCompareGedcom(File file) {
        ModelParser parser = new ModelParser();
        parser.setErrorHandler(this);
        TreeParser treeParser = new TreeParser();
        treeParser.setErrorHandler(this);
        GedcomWriter writer = new GedcomWriter();
        try {
            this.hasError = false;
            this.logWarningsErrors = false;
            Gedcom gedcom = parser.parseGedcom(file);
            File tempFile = this.gedcomOut != null ? new File(this.gedcomOut, file.getName()) : File.createTempFile(file.getName(), "tmp");
            FileOutputStream out = new FileOutputStream(tempFile);
            writer.write(gedcom, out);
            if (out != null) {
                ((OutputStream)out).close();
            }
            ++this.totalGedcoms;
            List<GedcomTag> gedcomTags = treeParser.parseGedcom(file);
            this.logWarningsErrors = true;
            this.currentFilename = tempFile.getName();
            List<GedcomTag> compareGedcomTags = treeParser.parseGedcom(tempFile);
            if (this.equals(gedcomTags, compareGedcomTags)) {
                ++this.equalsCount;
            } else if (this.hasError) {
                ++this.expectedNotEqualsCount;
            } else {
                logger.warn("Unexpected not equal: " + file.getName());
                ++this.unexpectedNotEqualsCount;
            }
        }
        catch (SAXParseException e) {
            logger.error("SaxParseException for file: " + file.getName() + " " + e.getMessage() + " @ " + e.getLineNumber());
        }
        catch (IOException e) {
            logger.error("IOException for file: " + file.getName() + " " + e.getMessage());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            logger.error("Exception for file: " + file.getName() + " " + e.getMessage());
        }
    }

    private boolean equals(List<GedcomTag> gedcomTags, List<GedcomTag> compareGedcomTags) throws SAXParseException, IOException {
        this.mergeContConcTags(gedcomTags);
        this.mergeContConcTags(compareGedcomTags);
        this.removeEmptyTags(gedcomTags);
        this.removeEmptyTags(compareGedcomTags);
        this.convertMultipleTextTags(gedcomTags);
        Collections.sort(gedcomTags);
        Collections.sort(compareGedcomTags);
        if (gedcomTags.size() != compareGedcomTags.size()) {
            return false;
        }
        for (int indx = 0; indx < gedcomTags.size(); ++indx) {
            GedcomTag gedcomTagTwo;
            GedcomTag gedcomTagOne = gedcomTags.get(indx);
            if (gedcomTagOne.equals(gedcomTagTwo = compareGedcomTags.get(indx))) continue;
            logger.info("file=" + this.currentFilename + " !tag=" + gedcomTagOne.toString() + "<=====>" + gedcomTagTwo.toString());
            return false;
        }
        return true;
    }

    private void mergeContConcTags(List<GedcomTag> gedcomTags) {
        for (GedcomTag tag : gedcomTags) {
            this.mergeContConcTags(tag);
        }
    }

    private void mergeContConcTags(GedcomTag tag) {
        List<GedcomTag> children = tag.getChildren();
        if (children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                String concValue;
                GedcomTag child = children.get(i);
                this.mergeContConcTags(child);
                if (!"CONC".equals(child.getTag()) && !"CONT".equals(child.getTag())) continue;
                String string = concValue = child.getValue() == null ? "" : child.getValue();
                if ("CONT".equals(child.getTag())) {
                    concValue = "\n" + concValue;
                }
                GedcomTag target = i == 0 ? tag : children.get(i - 1);
                String value = target.getValue() == null ? "" : target.getValue();
                target.setValue(value + concValue);
                for (GedcomTag tagToMove : child.getChildren()) {
                    target.addChild(tagToMove);
                }
                children.remove(i);
                --i;
            }
            if (tag.getChildren().size() == 0) {
                tag.setChildren(null);
            }
        }
    }

    private void removeEmptyTags(List<GedcomTag> gedcomTags) {
        Iterator<GedcomTag> iter = gedcomTags.iterator();
        while (iter.hasNext()) {
            GedcomTag tag = iter.next();
            this.removeEmptyTags(tag.getChildren());
            if (!tag.isEmpty()) continue;
            iter.remove();
        }
    }

    private void convertMultipleTextTags(List<GedcomTag> gedcomTags) {
        Iterator<GedcomTag> iter = gedcomTags.iterator();
        GedcomTag prevTag = null;
        while (iter.hasNext()) {
            GedcomTag tag = iter.next();
            if ("TEXT".equals(tag.getTag()) && prevTag != null && "TEXT".equals(prevTag.getTag()) && prevTag.getChildren().size() == 0) {
                iter.remove();
                tag.setTag("CONT");
                prevTag.addChild(tag);
            }
            prevTag = tag;
            this.convertMultipleTextTags(tag.getChildren());
        }
    }

    private void doMain() throws FileNotFoundException {
        if (this.gedcomIn.isDirectory()) {
            int cnt = 0;
            for (File file : this.gedcomIn.listFiles()) {
                this.convertAndCompareGedcom(file);
                if (++cnt % 100 != 0) continue;
                System.out.print(".");
            }
        } else if (this.gedcomIn.isFile()) {
            this.convertAndCompareGedcom(this.gedcomIn);
        }
        System.out.println("Total Number of Gedcoms = " + this.totalGedcoms);
        System.out.println("Number of Gedcoms that are Equal = " + this.equalsCount);
        System.out.println("Expected number of Gedcoms that are NOT Equal = " + this.expectedNotEqualsCount);
        System.out.println("UNEXPECTED number of Gedcoms that are NOT Equal = " + this.unexpectedNotEqualsCount);
    }

    public static void main(String[] args) throws FileNotFoundException {
        CompareGedcom2Gedcom self = new CompareGedcom2Gedcom();
        CmdLineParser parser = new CmdLineParser(self);
        try {
            parser.parseArgument(args);
            self.doMain();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage(System.err);
        }
    }
}

