/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.tools;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CountsCollector {
    HashMap<String, Counter> counts = new HashMap();

    public int size() {
        return this.counts.size();
    }

    public void add(String key) {
        this.add(key, 1);
    }

    public void add(String key, int count) {
        if (key != null) {
            Counter c = this.counts.get(key);
            if (c == null) {
                c = new Counter();
                this.counts.put(key, c);
            }
            c.count += count;
        }
    }

    public void remove(String key) {
        this.counts.remove(key);
    }

    public int getCount(String key) {
        Counter c = this.counts.get(key);
        if (c == null) {
            return 0;
        }
        return c.count;
    }

    public Set<String> getKeys() {
        return this.counts.keySet();
    }

    public void addAll(Set<String> keys) {
        Iterator<String> iter = keys.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    public SortedSet<Map.Entry<String, Counter>> getSortedSet(boolean byKey, int minCount) {
        Comparator<Map.Entry<String, Counter>> comp = byKey ? new KeyComparator() : new ValueComparator();
        TreeSet<Map.Entry<String, Counter>> ss = new TreeSet<Map.Entry<String, Counter>>(comp);
        for (Map.Entry<String, Counter> entry : this.counts.entrySet()) {
            if (entry.getValue().count < minCount) continue;
            ss.add(entry);
        }
        return ss;
    }

    public void writeSorted(boolean byKey, int minCount, PrintWriter writer) {
        SortedSet<Map.Entry<String, Counter>> ss = this.getSortedSet(byKey, minCount);
        for (Map.Entry entry : ss) {
            writer.println((String)entry.getKey() + "\t" + entry.getValue());
        }
        writer.flush();
    }

    private class KeyComparator
    implements Comparator<Map.Entry<String, Counter>> {
        private KeyComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Counter> me1, Map.Entry<String, Counter> me2) {
            return me1.getKey().compareTo(me2.getKey());
        }

        public boolean equals(Map.Entry<String, Counter> me1, Map.Entry<String, Counter> me2) {
            return me1.getKey().equals(me2.getKey());
        }
    }

    private class ValueComparator
    implements Comparator<Map.Entry<String, Counter>> {
        private ValueComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Counter> me1, Map.Entry<String, Counter> me2) {
            if (me1.getValue().count < me2.getValue().count || me1.getValue().count == me2.getValue().count && me1.getKey().compareTo(me2.getKey()) < 0) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Map.Entry<String, Counter> me1, Map.Entry<String, Counter> me2) {
            return me1.getValue().count == me2.getValue().count && me1.getKey().equals(me2.getKey());
        }
    }

    public class Counter {
        int count = 0;

        Counter() {
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }
}

