/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.parser.ModelParser;
import org.folg.gedcom.visitors.GedcomWriter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class Gedcom2Gedcom {
    private static final Logger logger = LoggerFactory.getLogger("org.folg.gedcom.tools");
    @Option(name="-i", required=true, usage="file or directory containing gedcom files to convert")
    private File gedcomIn;
    @Option(name="-o", required=false, usage="target directory")
    private File gedcomOut;
    private ModelParser parser = new ModelParser();
    private GedcomWriter writer = new GedcomWriter();

    public void convertGedcom(File file) {
        try {
            Gedcom gedcom = this.parser.parseGedcom(file);
            OutputStream out = this.gedcomOut != null ? new FileOutputStream(new File(this.gedcomOut, file.getName())) : new ByteArrayOutputStream();
            this.writer.write(gedcom, out);
            if (this.gedcomOut != null) {
                out.close();
            } else {
                System.out.println(out.toString());
            }
        }
        catch (SAXParseException e) {
            logger.error("SaxParseException for file: " + file.getName() + " " + e.getMessage() + " @ " + e.getLineNumber());
        }
        catch (IOException e) {
            logger.error("IOException for file: " + file.getName() + " " + e.getMessage());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            logger.error("Exception for file: " + file.getName() + " " + e.getMessage());
        }
    }

    private void doMain() throws FileNotFoundException {
        if (this.gedcomIn.isDirectory()) {
            for (File file : this.gedcomIn.listFiles()) {
                this.convertGedcom(file);
            }
        } else if (this.gedcomIn.isFile()) {
            this.convertGedcom(this.gedcomIn);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        Gedcom2Gedcom self = new Gedcom2Gedcom();
        CmdLineParser parser = new CmdLineParser(self);
        try {
            parser.parseArgument(args);
            self.doMain();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage(System.err);
        }
    }
}

