/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.parser.JsonParser;
import org.folg.gedcom.parser.ModelParser;
import org.folg.gedcom.parser.TreeParser;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXParseException;

public class Gedcom2Json {
    @Option(name="-i", required=true, usage="gedcom file in")
    private File gedcomIn;
    @Option(name="-o", required=false, usage="json file out")
    private File jsonOut;
    @Option(name="-t", required=false, usage="use tree parser (use model parser by default)")
    private boolean useTreeParser = false;

    private void doMain() throws SAXParseException, IOException {
        String json;
        JsonParser jsonParser = new JsonParser();
        if (this.useTreeParser) {
            TreeParser treeParser = new TreeParser();
            List<GedcomTag> gedcomTags = treeParser.parseGedcom(this.gedcomIn);
            json = jsonParser.toJson(gedcomTags);
        } else {
            ModelParser modelParser = new ModelParser();
            Gedcom gedcom = modelParser.parseGedcom(this.gedcomIn);
            json = jsonParser.toJson(gedcom);
        }
        if (this.jsonOut != null) {
            PrintWriter writer = new PrintWriter(this.jsonOut);
            writer.println(json);
            writer.close();
        } else {
            System.out.println(json);
        }
    }

    public static void main(String[] args) throws SAXParseException, IOException {
        Gedcom2Json self = new Gedcom2Json();
        CmdLineParser parser = new CmdLineParser(self);
        try {
            parser.parseArgument(args);
            self.doMain();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage(System.err);
        }
    }
}

