/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.folg.gedcom.parser.ErrorHandler;
import org.folg.gedcom.parser.ModelParser;
import org.folg.gedcom.tools.CountsCollector;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class GedcomAnalyzer
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger("org.folg.gedcom.tools");
    @Option(name="-i", required=true, usage="file or directory containing gedcom files to analyze")
    private File gedcomIn;
    @Option(name="-w", required=false, usage="warnings file out")
    private File warningsOut;
    @Option(name="-e", required=false, usage="errors file out")
    private File errorsOut;
    private ModelParser parser = new ModelParser();
    private Set<String> warnings;
    private Set<String> errors;
    private CountsCollector ccWarnings;
    private CountsCollector ccErrors;
    private int cntWarnings;
    private int cntErrors;
    private int cntTotal;
    private File file;

    public GedcomAnalyzer() {
        this.parser.setErrorHandler(this);
        this.ccWarnings = new CountsCollector();
        this.ccErrors = new CountsCollector();
        this.cntTotal = 0;
        this.cntWarnings = 0;
        this.cntErrors = 0;
    }

    @Override
    public void warning(String message, int lineNumber) {
        logger.info(message + " @ " + lineNumber);
        this.warnings.add(message);
    }

    @Override
    public void error(String message, int lineNumber) {
        logger.warn(message + " @ " + lineNumber);
        this.errors.add(message);
    }

    @Override
    public void fatalError(String message, int lineNumber) {
    }

    public void analyzeGedcom(File gedcomFile) {
        this.warnings = new HashSet<String>();
        this.errors = new HashSet<String>();
        this.file = gedcomFile;
        try {
            this.parser.parseGedcom(gedcomFile);
            if (this.warnings.size() > 0 || this.errors.size() > 0) {
                ++this.cntWarnings;
            }
            if (this.errors.size() > 0) {
                ++this.cntErrors;
            }
            for (String warning : this.warnings) {
                this.ccWarnings.add(warning);
            }
            for (String error : this.errors) {
                this.ccErrors.add(error);
            }
        }
        catch (SAXParseException e) {
            logger.error("SaxParseException for file: " + this.file.getName() + " " + e.getMessage() + " @ " + e.getLineNumber());
        }
        catch (IOException e) {
            logger.error("IOException for file: " + this.file.getName() + " " + e.getMessage());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            logger.error("Exception for file: " + this.file.getName() + " " + e.getMessage());
        }
    }

    public CountsCollector getWarnings() {
        return this.ccWarnings;
    }

    public CountsCollector getErrors() {
        return this.ccErrors;
    }

    private void doMain() throws FileNotFoundException {
        if (this.gedcomIn.isDirectory()) {
            for (File file : this.gedcomIn.listFiles()) {
                this.analyzeGedcom(file);
            }
        } else if (this.gedcomIn.isFile()) {
            this.analyzeGedcom(this.gedcomIn);
        }
        System.out.println("Total=" + this.cntTotal + " with warnings=" + this.cntWarnings + " with errors=" + this.cntErrors);
        this.getWarnings().writeSorted(false, 1, this.warningsOut != null ? new PrintWriter(this.warningsOut) : new PrintWriter(System.out));
        this.getErrors().writeSorted(false, 1, this.errorsOut != null ? new PrintWriter(this.errorsOut) : new PrintWriter(System.out));
    }

    public static void main(String[] args) throws FileNotFoundException {
        GedcomAnalyzer self = new GedcomAnalyzer();
        CmdLineParser parser = new CmdLineParser(self);
        try {
            parser.parseArgument(args);
            self.doMain();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage(System.err);
        }
    }
}

