/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.folg.gedcom.model.EventFact;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.Visitor;
import org.folg.gedcom.parser.ModelParser;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class PlaceWriter
extends Visitor {
    private static final Logger logger = LoggerFactory.getLogger("org.folg.gedcom.tools");
    @Option(name="-i", required=true, usage="file or directory containing gedcom files to process")
    private File gedcomIn;
    @Option(name="-o", required=true, usage="target file for places")
    private File placesOut;
    private ModelParser parser = new ModelParser();
    private PrintWriter out;

    @Override
    public boolean visit(EventFact eventFact) {
        String place = eventFact.getPlace();
        if (place != null && place.length() > 0) {
            this.out.println(place);
        }
        return true;
    }

    public void processGedcom(File file) throws SAXParseException, IOException {
        Gedcom gedcom = this.parser.parseGedcom(file);
        gedcom.accept(this);
    }

    private void doMain() throws IOException, SAXParseException {
        this.out = new PrintWriter(new FileWriter(this.placesOut));
        if (this.gedcomIn.isDirectory()) {
            for (File file : this.gedcomIn.listFiles()) {
                this.processGedcom(file);
            }
        } else if (this.gedcomIn.isFile()) {
            this.processGedcom(this.gedcomIn);
        }
        this.out.close();
    }

    public static void main(String[] args) throws IOException, SAXParseException {
        PlaceWriter self = new PlaceWriter();
        CmdLineParser parser = new CmdLineParser(self);
        try {
            parser.parseArgument(args);
            self.doMain();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage(System.err);
        }
    }
}

