/*
 * Decompiled with CFR 0.152.
 */
package org.folg.gedcom.visitors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Stack;
import org.folg.gedcom.model.Address;
import org.folg.gedcom.model.Association;
import org.folg.gedcom.model.Change;
import org.folg.gedcom.model.CharacterSet;
import org.folg.gedcom.model.ChildRef;
import org.folg.gedcom.model.DateTime;
import org.folg.gedcom.model.EventFact;
import org.folg.gedcom.model.ExtensionContainer;
import org.folg.gedcom.model.Family;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.model.GedcomVersion;
import org.folg.gedcom.model.Generator;
import org.folg.gedcom.model.GeneratorCorporation;
import org.folg.gedcom.model.GeneratorData;
import org.folg.gedcom.model.Header;
import org.folg.gedcom.model.LdsOrdinance;
import org.folg.gedcom.model.Media;
import org.folg.gedcom.model.MediaRef;
import org.folg.gedcom.model.Name;
import org.folg.gedcom.model.Note;
import org.folg.gedcom.model.NoteRef;
import org.folg.gedcom.model.ParentFamilyRef;
import org.folg.gedcom.model.ParentRelationship;
import org.folg.gedcom.model.Person;
import org.folg.gedcom.model.PersonFamilyCommonContainer;
import org.folg.gedcom.model.Repository;
import org.folg.gedcom.model.RepositoryRef;
import org.folg.gedcom.model.Source;
import org.folg.gedcom.model.SourceCitation;
import org.folg.gedcom.model.SpouseFamilyRef;
import org.folg.gedcom.model.SpouseRef;
import org.folg.gedcom.model.Submission;
import org.folg.gedcom.model.Submitter;
import org.folg.gedcom.model.Visitor;
import org.gedml.AnselOutputStreamWriter;
import org.gedml.GedcomParser;

public class GedcomWriter
extends Visitor {
    private Writer out = null;
    private String eol = "";
    private Stack<Object> stack;
    private IOException nestedException;

    public void write(Gedcom gedcom, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.write(gedcom, out);
        ((OutputStream)out).close();
    }

    public void write(Gedcom gedcom, OutputStream out) throws IOException {
        this.stack = new Stack();
        this.nestedException = null;
        String charset = this.getCharsetName(gedcom);
        this.eol = charset.equals("x-MacRoman") ? "\r" : "\n";
        OutputStreamWriter writer = "ANSEL".equals(charset) ? new AnselOutputStreamWriter(out) : new OutputStreamWriter(out, charset);
        this.out = new BufferedWriter(writer);
        gedcom.accept(this);
        this.out.write("0 TRLR" + this.eol);
        this.out.flush();
        if (this.nestedException != null) {
            throw this.nestedException;
        }
    }

    private String getCharsetName(Gedcom gedcom) {
        Header header = gedcom.getHeader();
        String generator = header != null && header.getGenerator() != null ? header.getGenerator().getValue() : null;
        String charset = header != null && header.getCharacterSet() != null ? header.getCharacterSet().getValue() : null;
        String version = header != null && header.getCharacterSet() != null ? header.getCharacterSet().getVersion() : null;
        if ((charset = GedcomParser.getCorrectedCharsetName(generator, charset, version)).length() == 0) {
            charset = "UTF-8";
        }
        return charset;
    }

    private void write(String tag, String id, String ref, String value, boolean forceValueOnSeparateLine) {
        try {
            int level = this.stack.size();
            this.out.write(level + " ");
            if (id != null && id.length() > 0) {
                this.out.write("@" + id + "@ ");
            }
            this.out.write(tag);
            if (ref != null && ref.length() > 0) {
                this.out.write(" @" + ref + "@");
            }
            if (value != null && value.length() > 0) {
                if (forceValueOnSeparateLine && !value.startsWith("\n")) {
                    this.out.write(this.eol + (level + 1) + " CONC ");
                } else {
                    this.out.write(" ");
                }
                StringBuilder buf = new StringBuilder(value);
                int cnt = 0;
                boolean lastLine = false;
                while (!lastLine) {
                    String line;
                    int nlPos = buf.indexOf("\n");
                    if (nlPos >= 0) {
                        line = buf.substring(0, nlPos);
                        buf.delete(0, nlPos + 1);
                    } else {
                        line = buf.toString();
                        lastLine = true;
                    }
                    if (cnt > 0) {
                        this.out.write(this.eol + (level + 1) + " CONT ");
                    }
                    while (line.length() > 200) {
                        this.out.write(line.substring(0, 200));
                        line = line.substring(200);
                        this.out.write(this.eol + (level + 1) + " CONC ");
                    }
                    this.out.write(line);
                    ++cnt;
                }
            }
            this.out.write(this.eol);
        }
        catch (IOException e) {
            this.nestedException = e;
        }
    }

    private void write(String tag, String id, String ref, String value) {
        this.write(tag, id, ref, value, false);
    }

    private void write(String tag) {
        this.write(tag, null, null, null);
    }

    private void write(String tag, String value) {
        this.write(tag, null, null, value);
    }

    private void writeFieldExtensions(String fieldName, ExtensionContainer ec) {
        List moreTags = (List)ec.getExtension("folg.more_tags");
        if (moreTags != null) {
            for (GedcomTag tag : moreTags) {
                if (!fieldName.equals(tag.getParentTagName())) continue;
                this.stack.push(new Object());
                this.writeGedcomTag(tag);
                this.stack.pop();
            }
        }
    }

    private void writeString(String tag, ExtensionContainer ec, String value) {
        if (value != null && value.length() > 0) {
            this.write(tag, value);
            this.writeFieldExtensions(tag, ec);
        }
    }

    private void writeRef(String tag, ExtensionContainer ec, String ref) {
        if (ref != null && ref.length() > 0) {
            this.write(tag, null, ref, null);
            this.writeFieldExtensions(tag, ec);
        }
    }

    @Override
    public boolean visit(Address address) {
        this.write("ADDR", address.getValue());
        this.stack.push(address);
        this.writeString("ADR1", address, address.getAddressLine1());
        this.writeString("ADR2", address, address.getAddressLine2());
        this.writeString("CITY", address, address.getCity());
        this.writeString("STAE", address, address.getState());
        this.writeString("POST", address, address.getPostalCode());
        this.writeString("CTRY", address, address.getCountry());
        this.writeString("_NAME", address, address.getName());
        return true;
    }

    @Override
    public boolean visit(Association association) {
        this.write("ASSO", null, association.getRef(), null);
        this.stack.push(association);
        this.writeString("TYPE", association, association.getType());
        this.writeString("RELA", association, association.getRelation());
        return true;
    }

    @Override
    public boolean visit(Change change) {
        this.write("CHAN");
        this.stack.push(change);
        return true;
    }

    @Override
    public boolean visit(CharacterSet characterSet) {
        this.write("CHAR", characterSet.getValue());
        this.stack.push(characterSet);
        this.writeString("VERS", characterSet, characterSet.getVersion());
        return true;
    }

    @Override
    public boolean visit(ChildRef childRef) {
        this.write("CHIL", null, childRef.getRef(), null);
        this.stack.push(childRef);
        this.writeSpouseRefStrings(childRef);
        return true;
    }

    @Override
    public boolean visit(DateTime dateTime) {
        this.write("DATE", dateTime.getValue());
        this.stack.push(dateTime);
        this.writeString("TIME", dateTime, dateTime.getTime());
        return true;
    }

    private void writeEventFactStrings(EventFact eventFact) {
        this.writeString("TYPE", eventFact, eventFact.getType());
        this.writeString("DATE", eventFact, eventFact.getDate());
        this.writeString("PLAC", eventFact, eventFact.getPlace());
        this.writeString("RIN", eventFact, eventFact.getRin());
        this.writeString(eventFact.getUidTag(), eventFact, eventFact.getUid());
    }

    @Override
    public boolean visit(EventFact eventFact) {
        this.write(eventFact.getTag(), eventFact.getValue());
        this.stack.push(eventFact);
        this.writeEventFactStrings(eventFact);
        return true;
    }

    private void writeGedcomTag(GedcomTag tag) {
        this.write(tag.getTag(), tag.getId(), tag.getRef(), tag.getValue());
        this.stack.push(tag);
        for (GedcomTag child : tag.getChildren()) {
            this.writeGedcomTag(child);
        }
        this.stack.pop();
    }

    @Override
    public boolean visit(String extensionKey, Object extension) {
        if ("folg.more_tags".equals(extensionKey)) {
            List moreTags = (List)extension;
            for (GedcomTag tag : moreTags) {
                if (tag.getParentTagName() != null) continue;
                this.writeGedcomTag(tag);
            }
        }
        return true;
    }

    private void writePersonFamilyCommonContainerStrings(PersonFamilyCommonContainer pf) {
        for (String refn : pf.getReferenceNumbers()) {
            this.writeString("REFN", pf, refn);
        }
        this.writeString("RIN", pf, pf.getRin());
        this.writeString(pf.getUidTag(), pf, pf.getUid());
    }

    @Override
    public boolean visit(Family family) {
        this.write("FAM", family.getId(), null, null);
        this.stack.push(family);
        this.writePersonFamilyCommonContainerStrings(family);
        return true;
    }

    @Override
    public boolean visit(Gedcom gedcom) {
        return true;
    }

    @Override
    public boolean visit(GedcomVersion gedcomVersion) {
        this.write("GEDC");
        this.stack.push(gedcomVersion);
        this.writeString("VERS", gedcomVersion, gedcomVersion.getVersion());
        this.writeString("FORM", gedcomVersion, gedcomVersion.getForm());
        return true;
    }

    @Override
    public boolean visit(Generator generator) {
        this.write("SOUR", generator.getValue());
        this.stack.push(generator);
        this.writeString("NAME", generator, generator.getName());
        this.writeString("VERS", generator, generator.getVersion());
        return true;
    }

    @Override
    public boolean visit(GeneratorCorporation generatorCorporation) {
        this.write("CORP", generatorCorporation.getValue());
        this.stack.push(generatorCorporation);
        this.writeString("PHON", generatorCorporation, generatorCorporation.getPhone());
        this.writeString(generatorCorporation.getWwwTag(), generatorCorporation, generatorCorporation.getWww());
        return true;
    }

    @Override
    public boolean visit(GeneratorData generatorData) {
        this.write("DATA", generatorData.getValue());
        this.stack.push(generatorData);
        this.writeString("DATE", generatorData, generatorData.getDate());
        this.writeString("COPR", generatorData, generatorData.getCopyright());
        return true;
    }

    @Override
    public boolean visit(Header header) {
        this.write("HEAD");
        this.stack.push(header);
        this.writeString("DEST", header, header.getDestination());
        this.writeString("FILE", header, header.getFile());
        this.writeString("COPR", header, header.getCopyright());
        this.writeString("LANG", header, header.getLanguage());
        this.writeRef("SUBM", header, header.getSubmitterRef());
        this.writeRef("SUBN", header, header.getSubmissionRef());
        return true;
    }

    @Override
    public boolean visit(LdsOrdinance ldsOrdinance) {
        this.write(ldsOrdinance.getTag(), ldsOrdinance.getValue());
        this.stack.push(ldsOrdinance);
        this.writeEventFactStrings(ldsOrdinance);
        this.writeString("STAT", ldsOrdinance, ldsOrdinance.getStatus());
        this.writeString("TEMP", ldsOrdinance, ldsOrdinance.getTemple());
        return true;
    }

    @Override
    public boolean visit(Media media) {
        this.write("OBJE", media.getId(), null, null);
        this.stack.push(media);
        this.writeString("FORM", media, media.getFormat());
        this.writeString("TITL", media, media.getTitle());
        this.writeString("BLOB", media, media.getBlob());
        this.writeString(media.getFileTag(), media, media.getFile());
        this.writeString("_PRIM", media, media.getPrimary());
        this.writeString("_TYPE", media, media.getType());
        this.writeString("_SCBK", media, media.getScrapbook());
        this.writeString("_SSHOW", media, media.getSlideShow());
        return true;
    }

    @Override
    public boolean visit(MediaRef mediaRef) {
        this.write("OBJE", null, mediaRef.getRef(), null);
        this.stack.push(mediaRef);
        return true;
    }

    @Override
    public boolean visit(Name name) {
        String tag;
        String type = name.getType();
        if ("ALIA".equals(type) || "TITL".equals(type)) {
            tag = type;
            type = null;
        } else {
            tag = "NAME";
        }
        this.write(tag, name.getValue());
        this.stack.push(name);
        this.writeString("GIVN", name, name.getGiven());
        this.writeString("SURN", name, name.getSurname());
        this.writeString("NPFX", name, name.getPrefix());
        this.writeString("NSFX", name, name.getSuffix());
        this.writeString("SPFX", name, name.getSurnamePrefix());
        this.writeString("NICK", name, name.getNickname());
        this.writeString(name.getTypeTag(), name, type);
        this.writeString(name.getAkaTag(), name, name.getAka());
        this.writeString(name.getMarriedNameTag(), name, name.getMarriedName());
        return true;
    }

    @Override
    public boolean visit(Note note) {
        boolean visitChildren = false;
        if (note.isSourceCitationsUnderValue() && note.getSourceCitations().size() > 0 && note.getValue() != null && note.getValue().length() > 0) {
            this.write("NOTE", note.getId(), null, note.getValue(), true);
            this.stack.push(note);
            this.stack.push(new Object());
            for (SourceCitation sc : note.getSourceCitations()) {
                sc.accept(this);
            }
            this.stack.pop();
            visitChildren = true;
        } else {
            this.write("NOTE", note.getId(), null, note.getValue());
            this.stack.push(note);
        }
        this.writeString("RIN", note, note.getRin());
        if (visitChildren) {
            note.visitContainedObjects(this, false);
            this.stack.pop();
        }
        return !visitChildren;
    }

    @Override
    public boolean visit(NoteRef noteRef) {
        this.write("NOTE", null, noteRef.getRef(), null);
        this.stack.push(noteRef);
        return true;
    }

    @Override
    public boolean visit(ParentFamilyRef parentFamilyRef) {
        this.write("FAMC", null, parentFamilyRef.getRef(), null);
        this.stack.push(parentFamilyRef);
        this.writeSpouseFamilyRefStrings(parentFamilyRef);
        this.writeString("PEDI", parentFamilyRef, parentFamilyRef.getRelationshipType());
        this.writeString("_PRIMARY", parentFamilyRef, parentFamilyRef.getPrimary());
        return true;
    }

    @Override
    public boolean visit(ParentRelationship parentRelationship, boolean isFather) {
        this.write(isFather ? "_FREL" : "_MREL", parentRelationship.getValue());
        this.stack.push(parentRelationship);
        return true;
    }

    @Override
    public boolean visit(Person person) {
        this.write("INDI", person.getId(), null, null);
        this.stack.push(person);
        this.writeRef("ANCI", person, person.getAncestorInterestSubmitterRef());
        this.writeRef("DESI", person, person.getDescendantInterestSubmitterRef());
        this.writeString("RFN", person, person.getRecordFileNumber());
        this.writeString("PHON", person, person.getPhone());
        this.writeString(person.getEmailTag(), person, person.getEmail());
        this.writePersonFamilyCommonContainerStrings(person);
        return true;
    }

    @Override
    public boolean visit(Repository repository) {
        this.write("REPO", repository.getId(), null, repository.getValue());
        this.stack.push(repository);
        this.writeString("NAME", repository, repository.getName());
        this.writeString("PHON", repository, repository.getPhone());
        this.writeString("RIN", repository, repository.getRin());
        this.writeString(repository.getEmailTag(), repository, repository.getEmail());
        this.writeString(repository.getWwwTag(), repository, repository.getWww());
        return true;
    }

    @Override
    public boolean visit(RepositoryRef repositoryRef) {
        this.write("REPO", null, repositoryRef.getRef(), repositoryRef.getValue());
        this.stack.push(repositoryRef);
        if (repositoryRef.isMediUnderCalnTag() || repositoryRef.getCallNumber() != null && repositoryRef.getCallNumber().length() > 0) {
            this.write("CALN", repositoryRef.getCallNumber());
        }
        if (repositoryRef.isMediUnderCalnTag()) {
            this.stack.push(new Object());
        }
        this.writeString("MEDI", repositoryRef, repositoryRef.getMediaType());
        if (repositoryRef.isMediUnderCalnTag()) {
            this.stack.pop();
        }
        return true;
    }

    @Override
    public boolean visit(Source source) {
        this.write("SOUR", source.getId(), null, null);
        this.stack.push(source);
        this.writeString("AUTH", source, source.getAuthor());
        this.writeString("TITL", source, source.getTitle());
        this.writeString("ABBR", source, source.getAbbreviation());
        this.writeString("PUBL", source, source.getPublicationFacts());
        this.writeString("TEXT", source, source.getText());
        this.writeString("REFN", source, source.getReferenceNumber());
        this.writeString("RIN", source, source.getRin());
        this.writeString("MEDI", source, source.getMediaType());
        this.writeString("CALN", source, source.getCallNumber());
        this.writeString(source.getTypeTag(), source, source.getType());
        this.writeString(source.getUidTag(), source, source.getUid());
        this.writeString("_PAREN", source, source.getParen());
        this.writeString("_ITALIC", source, source.getItalic());
        this.writeString("DATE", source, source.getDate());
        return true;
    }

    private void writeUnderData(String tag, SourceCitation sourceCitation, String value) {
        if (value != null && value.length() > 0) {
            this.write("DATA");
            this.stack.push(new Object());
            this.writeString(tag, sourceCitation, value);
            this.stack.pop();
        }
    }

    @Override
    public boolean visit(SourceCitation sourceCitation) {
        this.write("SOUR", null, sourceCitation.getRef(), sourceCitation.getValue());
        this.stack.push(sourceCitation);
        this.writeString("PAGE", sourceCitation, sourceCitation.getPage());
        this.writeString("QUAY", sourceCitation, sourceCitation.getQuality());
        if (sourceCitation.getDataTagContents() == SourceCitation.DataTagContents.COMBINED && (sourceCitation.getDate() != null && sourceCitation.getDate().length() > 0 || sourceCitation.getText() != null && sourceCitation.getText().length() > 0)) {
            this.write("DATA");
            this.stack.push(new Object());
            this.writeString("DATE", sourceCitation, sourceCitation.getDate());
            this.writeString("TEXT", sourceCitation, sourceCitation.getText());
            this.stack.pop();
        } else if (sourceCitation.getDataTagContents() == SourceCitation.DataTagContents.DATE) {
            this.writeUnderData("DATE", sourceCitation, sourceCitation.getDate());
            this.writeString("TEXT", sourceCitation, sourceCitation.getText());
        } else if (sourceCitation.getDataTagContents() == SourceCitation.DataTagContents.TEXT) {
            this.writeUnderData("TEXT", sourceCitation, sourceCitation.getText());
            this.writeString("DATE", sourceCitation, sourceCitation.getDate());
        } else if (sourceCitation.getDataTagContents() == SourceCitation.DataTagContents.SEPARATE) {
            this.writeUnderData("DATE", sourceCitation, sourceCitation.getDate());
            this.writeUnderData("TEXT", sourceCitation, sourceCitation.getText());
        } else if (sourceCitation.getDataTagContents() == null) {
            this.writeString("DATE", sourceCitation, sourceCitation.getDate());
            this.writeString("TEXT", sourceCitation, sourceCitation.getText());
        }
        return true;
    }

    private void writeSpouseRefStrings(SpouseRef spouseRef) {
        this.writeString("_PREF", spouseRef, spouseRef.getPreferred());
    }

    @Override
    public boolean visit(SpouseRef spouseRef, boolean isHusband) {
        this.write(isHusband ? "HUSB" : "WIFE", null, spouseRef.getRef(), null);
        this.stack.push(spouseRef);
        this.writeSpouseRefStrings(spouseRef);
        return true;
    }

    private void writeSpouseFamilyRefStrings(SpouseFamilyRef spouseFamilyRef) {
    }

    @Override
    public boolean visit(SpouseFamilyRef spouseFamilyRef) {
        this.write("FAMS", null, spouseFamilyRef.getRef(), null);
        this.stack.push(spouseFamilyRef);
        this.writeSpouseFamilyRefStrings(spouseFamilyRef);
        return true;
    }

    @Override
    public boolean visit(Submission submission) {
        this.write("SUBN", submission.getId(), null, null);
        this.stack.push(submission);
        this.writeString("DESC", submission, submission.getDescription());
        this.writeString("ORDI", submission, submission.getOrdinanceFlag());
        return true;
    }

    @Override
    public boolean visit(Submitter submitter) {
        this.write("SUBM", submitter.getId(), null, submitter.getValue());
        this.stack.push(submitter);
        this.writeString("PHON", submitter, submitter.getPhone());
        this.writeString("NAME", submitter, submitter.getName());
        this.writeString("RIN", submitter, submitter.getRin());
        this.writeString("LANG", submitter, submitter.getLanguage());
        this.writeString(submitter.getWwwTag(), submitter, submitter.getWww());
        this.writeString(submitter.getEmailTag(), submitter, submitter.getEmail());
        return true;
    }

    @Override
    public void endVisit(ExtensionContainer obj) {
        if (!(obj instanceof Gedcom)) {
            this.stack.pop();
        }
    }
}

