/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.atom;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.json.JsonName;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.atom.Category;
import org.gedcomx.atom.Content;
import org.gedcomx.atom.ExtensibleElement;
import org.gedcomx.atom.Person;
import org.gedcomx.atom.rt.AtomModelVisitor;
import org.gedcomx.common.URI;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.search.ResultConfidence;

@XmlRootElement
@XmlType(name="Entry")
@JsonElementWrapper(name="entries")
@Facet(name="http://rs.gedcomx.org/")
public class Entry
extends ExtensibleElement
implements SupportsLinks {
    private List<Person> authors;
    private List<Category> categories;
    private Content content;
    private List<Person> contributors;
    private URI id;
    private Float score;
    private ResultConfidence confidence;
    private List<Link> links;
    private Date published;
    private String rights;
    private String title;
    private Date updated;
    private Map<QName, String> extensionAttributes;

    @XmlElement(name="author")
    @JsonName(value="authors")
    @JsonProperty(value="authors")
    public List<Person> getAuthors() {
        return this.authors;
    }

    @JsonProperty(value="authors")
    public void setAuthors(List<Person> authors) {
        this.authors = authors;
    }

    @XmlElement(name="category")
    @JsonName(value="categories")
    @JsonProperty(value="categories")
    public List<Category> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="categories")
    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    @XmlElement(name="contributor")
    @JsonName(value="contributors")
    @JsonProperty(value="contributors")
    public List<Person> getContributors() {
        return this.contributors;
    }

    @JsonProperty(value="contributors")
    public void setContributors(List<Person> contributors) {
        this.contributors = contributors;
    }

    @XmlSchemaType(name="anyURI", namespace="http://www.w3.org/2001/XMLSchema")
    public URI getId() {
        return this.id;
    }

    public void setId(URI id) {
        this.id = id;
    }

    @XmlElement(namespace="http://gedcomx.org/v1/")
    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    @XmlElement(namespace="http://gedcomx.org/v1/")
    public ResultConfidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(ResultConfidence confidence) {
        this.confidence = confidence;
    }

    @Override
    @XmlElement(name="link")
    @JsonName(value="links")
    @JsonProperty(value="links")
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    @Override
    public void addLink(Link link) {
        if (this.links == null) {
            this.setLinks(new ArrayList<Link>());
        }
        this.links.add(link);
    }

    @Override
    public void addLink(String rel, URI href) {
        this.addLink(new Link(rel, href));
    }

    @Override
    public void addTemplatedLink(String rel, String template) {
        Link link = new Link();
        link.setRel(rel);
        link.setTemplate(template);
        this.addLink(link);
    }

    @Override
    public Link getLink(String rel) {
        if (this.links != null) {
            for (Link link : this.getLinks()) {
                if (!rel.equals(link.getRel())) continue;
                return link;
            }
        }
        return null;
    }

    @Override
    public List<Link> getLinks(String rel) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (this.links != null) {
            for (Link link : this.getLinks()) {
                if (!rel.equals(link.getRel())) continue;
                links.add(link);
            }
        }
        return links;
    }

    public Date getPublished() {
        return this.published;
    }

    public void setPublished(Date published) {
        this.published = published;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @XmlAnyAttribute
    public Map<QName, String> getExtensionAttributes() {
        return this.extensionAttributes;
    }

    public void setExtensionAttributes(Map<QName, String> extensionAttributes) {
        this.extensionAttributes = extensionAttributes;
    }

    public void accept(AtomModelVisitor visitor) {
        visitor.visitEntry(this);
    }
}

