/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.atom;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.json.JsonName;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.atom.Entry;
import org.gedcomx.atom.ExtensibleElement;
import org.gedcomx.atom.Generator;
import org.gedcomx.atom.Person;
import org.gedcomx.atom.rt.AtomModelVisitor;
import org.gedcomx.common.URI;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.records.Field;
import org.gedcomx.rt.MediaTypeDefinition;
import org.gedcomx.rt.Model;

@MediaTypeDefinition(id="atom", name="Atom", description="The Atom data formats provide a format for web content and metadata syndication.", version="1.0", xmlMediaType="application/atom+xml", jsonMediaType="application/x-gedcomx-atom+json", projectId="gedcomx-rs", models={@Model(id="atom", namespace="http://www.w3.org/2005/Atom", label="Atom Model", description="The Atom model supplied the types and elements defined by the Atom syndication format.")})
@XmlRootElement
@XmlType(name="Feed", propOrder={"authors", "contributors", "generator", "icon", "id", "results", "index", "links", "logo", "rights", "subtitle", "title", "updated", "entries", "facets"})
@Facet(name="http://rs.gedcomx.org/")
public class Feed
extends ExtensibleElement
implements SupportsLinks {
    private List<Person> authors;
    private List<Person> contributors;
    private Generator generator;
    private URI icon;
    private URI id;
    private Integer results;
    private Integer index;
    private List<Link> links;
    private URI logo;
    private String rights;
    private String subtitle;
    private String title;
    private Date updated;
    private List<Entry> entries;
    private List<Field> facets;

    @XmlElement(name="author")
    @JsonName(value="authors")
    @JsonProperty(value="authors")
    public List<Person> getAuthors() {
        return this.authors;
    }

    @JsonProperty(value="authors")
    public void setAuthors(List<Person> authors) {
        this.authors = authors;
    }

    @XmlElement(name="contributor")
    @JsonName(value="contributors")
    @JsonProperty(value="contributors")
    public List<Person> getContributors() {
        return this.contributors;
    }

    @JsonProperty(value="contributors")
    public void setContributors(List<Person> contributors) {
        this.contributors = contributors;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    @XmlSchemaType(name="anyURI", namespace="http://www.w3.org/2001/XMLSchema")
    public URI getIcon() {
        return this.icon;
    }

    public void setIcon(URI icon) {
        this.icon = icon;
    }

    @XmlSchemaType(name="anyURI", namespace="http://www.w3.org/2001/XMLSchema")
    public URI getId() {
        return this.id;
    }

    public void setId(URI id) {
        this.id = id;
    }

    @XmlElement(namespace="http://gedcomx.org/v1/")
    public Integer getResults() {
        return this.results;
    }

    public void setResults(Integer results) {
        this.results = results;
    }

    @XmlElement(namespace="http://gedcomx.org/v1/")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    @XmlElement(name="link")
    @JsonName(value="links")
    @JsonProperty(value="links")
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    @Override
    public void addLink(Link link) {
        if (this.links == null) {
            this.setLinks(new ArrayList<Link>());
        }
        this.links.add(link);
    }

    @Override
    public void addLink(String rel, URI href) {
        this.addLink(new Link(rel, href));
    }

    @Override
    public void addTemplatedLink(String rel, String template) {
        Link link = new Link();
        link.setRel(rel);
        link.setTemplate(template);
        this.addLink(link);
    }

    @Override
    public Link getLink(String rel) {
        if (this.links != null) {
            for (Link link : this.getLinks()) {
                if (!rel.equals(link.getRel())) continue;
                return link;
            }
        }
        return null;
    }

    @Override
    public List<Link> getLinks(String rel) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (this.links != null) {
            for (Link link : this.getLinks()) {
                if (!rel.equals(link.getRel())) continue;
                links.add(link);
            }
        }
        return links;
    }

    @XmlSchemaType(name="anyURI", namespace="http://www.w3.org/2001/XMLSchema")
    public URI getLogo() {
        return this.logo;
    }

    public void setLogo(URI logo) {
        this.logo = logo;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @XmlElement(name="entry")
    @JsonName(value="entries")
    @JsonProperty(value="entries")
    public List<Entry> getEntries() {
        return this.entries;
    }

    @JsonProperty(value="entries")
    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @XmlElement(name="facet")
    @JsonName(value="facets")
    @JsonProperty(value="facets")
    public List<Field> getFacets() {
        return this.facets;
    }

    @JsonProperty(value="facets")
    public void setFacets(List<Field> facets) {
        this.facets = facets;
    }

    public void accept(AtomModelVisitor visitor) {
        visitor.visitFeed(this);
    }
}

