/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.atom.rt;

import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.gedcomx.Gedcomx;
import org.gedcomx.atom.Content;
import org.gedcomx.atom.Entry;
import org.gedcomx.atom.Feed;
import org.gedcomx.atom.Person;
import org.gedcomx.atom.rt.AtomModelVisitor;
import org.gedcomx.records.Field;
import org.gedcomx.rt.GedcomxModelVisitorBase;

@XmlTransient
public class AtomModelVisitorBase
extends GedcomxModelVisitorBase
implements AtomModelVisitor {
    @Override
    public void visitFeed(Feed feed) {
        List<Field> facets;
        List<Person> contributors;
        List<Person> authors;
        this.contextStack.push(feed);
        List<Entry> entries = feed.getEntries();
        if (entries != null) {
            for (Entry entry : entries) {
                if (entry == null) continue;
                entry.accept(this);
            }
        }
        if ((authors = feed.getAuthors()) != null) {
            for (Person author : authors) {
                if (author == null) continue;
                author.accept(this);
            }
        }
        if ((contributors = feed.getContributors()) != null) {
            for (Person contributor : contributors) {
                if (contributor == null) continue;
                contributor.accept(this);
            }
        }
        if ((facets = feed.getFacets()) != null) {
            for (Field facet : facets) {
                if (facet == null) continue;
                facet.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitAtomPerson(Person author) {
    }

    @Override
    public void visitEntry(Entry entry) {
        List<Person> contributors;
        List<Person> authors;
        this.contextStack.push(entry);
        Content content = entry.getContent();
        if (content != null) {
            content.accept(this);
        }
        if ((authors = entry.getAuthors()) != null) {
            for (Person author : authors) {
                if (author == null) continue;
                author.accept(this);
            }
        }
        if ((contributors = entry.getContributors()) != null) {
            for (Person contributor : contributors) {
                if (contributor == null) continue;
                contributor.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitAtomContent(Content content) {
        this.contextStack.push(content);
        Gedcomx gedcomx = content.getGedcomx();
        if (gedcomx != null) {
            gedcomx.accept(this);
        }
        this.contextStack.pop();
    }
}

