/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.common;

import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.gedcomx.agent.Agent;
import org.gedcomx.common.ExtensibleData;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.rt.RDFRange;
import org.gedcomx.rt.RDFSubPropertyOf;
import org.gedcomx.rt.json.JsonElementWrapper;

@XmlRootElement
@JsonElementWrapper(name="attribution")
@XmlType(name="Attribution", propOrder={"contributor", "modified", "changeMessage", "creator", "created"})
public final class Attribution
extends ExtensibleData {
    private ResourceReference contributor;
    private ResourceReference creator;
    private Date modified;
    private Date created;
    private String changeMessage;

    @Override
    public Attribution id(String id) {
        return (Attribution)super.id(id);
    }

    @Override
    public Attribution extensionElement(Object element) {
        return (Attribution)super.extensionElement(element);
    }

    @RDFRange(value={})
    @RDFSubPropertyOf(value={"http://purl.org/dc/terms/contributor"})
    @Facet(name="https://familysearch.org/tree#READ_ONLY")
    public ResourceReference getContributor() {
        return this.contributor;
    }

    public void setContributor(ResourceReference contributor) {
        this.contributor = contributor;
    }

    public Attribution contributor(ResourceReference contributor) {
        this.contributor = contributor;
        return this;
    }

    public Attribution contributor(URI contributor) {
        return this.contributor(new ResourceReference(contributor));
    }

    public Attribution contributor(Agent agent) {
        if (agent.getId() == null) {
            throw new IllegalArgumentException("Can't reference agent as a contributor: no id.");
        }
        return this.contributor(URI.create("#" + agent.getId()));
    }

    @RDFRange(value={})
    @RDFSubPropertyOf(value={"http://purl.org/dc/terms/creator"})
    @Facet(name="https://familysearch.org/tree#READ_ONLY")
    public ResourceReference getCreator() {
        return this.creator;
    }

    public void setCreator(ResourceReference creator) {
        this.creator = creator;
    }

    public Attribution creator(ResourceReference creator) {
        this.creator = creator;
        return this;
    }

    public Attribution creator(URI creator) {
        return this.creator(new ResourceReference(creator));
    }

    public Attribution creator(Agent agent) {
        if (agent.getId() == null) {
            throw new IllegalArgumentException("Can't reference agent as a creator: no id.");
        }
        return this.creator(URI.create("#" + agent.getId()));
    }

    @RDFSubPropertyOf(value={"http://purl.org/dc/terms/modified"})
    @Facet(name="https://familysearch.org/tree#READ_ONLY")
    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Attribution modified(Date modified) {
        this.modified = modified;
        return this;
    }

    @RDFSubPropertyOf(value={"http://purl.org/dc/terms/created"})
    @Facet(name="https://familysearch.org/tree#READ_ONLY")
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Attribution created(Date created) {
        this.created = created;
        return this;
    }

    @RDFSubPropertyOf(value={"http://purl.org/dc/terms/description"})
    public String getChangeMessage() {
        return this.changeMessage;
    }

    public void setChangeMessage(String changeMessage) {
        this.changeMessage = changeMessage;
    }

    public Attribution changeMessage(String changeMessage) {
        this.changeMessage = changeMessage;
        return this;
    }

    @Override
    public String toString() {
        return this.contributor == null ? "" : this.contributor.toString();
    }
}

