/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.json.JsonIgnore;
import org.codehaus.enunciate.qname.XmlQNameEnumRef;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.HasText;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Conclusion;
import org.gedcomx.links.Link;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.ConfidenceLevel;
import org.gedcomx.types.DocumentType;

@XmlRootElement
@JsonElementWrapper(name="documents")
@XmlType(name="Document", propOrder={"text"})
@Facet(name="https://familysearch.org/tree#UNSUPPORTED")
public class Document
extends Conclusion
implements HasText,
Attributable {
    public static final String TEXT_TYPE_PLAIN = "plain";
    public static final String TEXT_TYPE_XHTML = "xhtml";
    private Boolean extracted;
    private URI type;
    private String textType;
    private String text;

    @Override
    public Document id(String id) {
        return (Document)super.id(id);
    }

    @Override
    public Document extensionElement(Object element) {
        return (Document)super.extensionElement(element);
    }

    @Override
    public Document link(String rel, URI href) {
        return (Document)super.link(rel, href);
    }

    @Override
    public Document link(Link link) {
        return (Document)super.link(link);
    }

    @Override
    public Document lang(String lang) {
        return (Document)super.lang(lang);
    }

    @Override
    public Document confidence(URI confidence) {
        return (Document)super.confidence(confidence);
    }

    @Override
    public Document confidence(ConfidenceLevel confidence) {
        return (Document)super.confidence(confidence);
    }

    @Override
    public Document source(SourceReference sourceReference) {
        return (Document)super.source(sourceReference);
    }

    @Override
    public Document source(SourceDescription source) {
        return (Document)super.source(source);
    }

    @Override
    public Document note(Note note) {
        return (Document)super.note(note);
    }

    @Override
    public Document attribution(Attribution attribution) {
        return (Document)super.attribution(attribution);
    }

    @Override
    public Document analysis(ResourceReference analysis) {
        return (Document)super.analysis(analysis);
    }

    @Override
    public Document analysis(Document analysis) {
        return (Document)super.analysis(analysis);
    }

    @Override
    public Document analysis(URI analysis) {
        return (Document)super.analysis(analysis);
    }

    @Override
    public Document sortKey(String sortKey) {
        return (Document)super.sortKey(sortKey);
    }

    @XmlAttribute
    public Boolean getExtracted() {
        return this.extracted;
    }

    public void setExtracted(Boolean extracted) {
        this.extracted = extracted;
    }

    public Document extracted(Boolean extracted) {
        this.setExtracted(extracted);
        return this;
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=DocumentType.class)
    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public Document type(URI type) {
        this.setType(type);
        return this;
    }

    public Document type(DocumentType type) {
        this.setKnownType(type);
        return this;
    }

    @XmlTransient
    @org.codehaus.jackson.annotate.JsonIgnore
    @JsonIgnore
    public boolean isPlainText() {
        return this.textType == null || TEXT_TYPE_PLAIN.equals(this.textType);
    }

    @XmlTransient
    @org.codehaus.jackson.annotate.JsonIgnore
    @JsonIgnore
    public boolean isXhtmlText() {
        return TEXT_TYPE_XHTML.equals(this.textType);
    }

    @XmlAttribute
    public String getTextType() {
        return this.textType;
    }

    public void setTextType(String textType) {
        this.textType = textType;
    }

    public Document textType(String textType) {
        this.setTextType(textType);
        return this;
    }

    @XmlTransient
    @org.codehaus.jackson.annotate.JsonIgnore
    public DocumentType getKnownType() {
        return this.getType() == null ? null : DocumentType.fromQNameURI(this.getType());
    }

    @org.codehaus.jackson.annotate.JsonIgnore
    public void setKnownType(DocumentType knownType) {
        this.setType(knownType == null ? null : knownType.toQNameURI());
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public Document text(String text) {
        this.setText(text);
        return this;
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitDocument(this);
    }

    public void embed(Document document) {
        this.extracted = this.extracted == null ? document.extracted : this.extracted;
        this.type = this.type == null ? document.type : this.type;
        this.textType = this.textType == null ? document.textType : this.textType;
        this.text = this.text == null ? document.text : this.text;
        super.embed(document);
    }
}

