/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conversion.gedcom.dq55;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.folg.gedcom.model.ChildRef;
import org.folg.gedcom.model.EventFact;
import org.folg.gedcom.model.Family;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.model.ParentFamilyRef;
import org.folg.gedcom.model.Person;
import org.folg.gedcom.model.SpouseRef;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.conversion.GedcomxConversionResult;
import org.gedcomx.conversion.gedcom.dq55.CommonMapper;
import org.gedcomx.conversion.gedcom.dq55.ConversionContext;
import org.gedcomx.conversion.gedcom.dq55.FactMapper;
import org.gedcomx.types.FactType;
import org.gedcomx.types.RelationshipType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class FamilyMapper {
    private static final Logger logger = LoggerFactory.getLogger(CommonMapper.class);

    public void toRelationship(Family dqFamily, Gedcom dqGedcom, GedcomxConversionResult result) throws IOException {
        int cntMedia;
        int cntNotes;
        String familyId = dqFamily.getId();
        Marker familyContext = ConversionContext.getDetachedMarker(String.format("@%s@ FAM", familyId));
        ConversionContext.addReference(familyContext);
        List<SpouseRef> husbands = dqFamily.getHusbandRefs();
        String husbandId = husbands.size() > 0 ? husbands.get(0).getRef() : null;
        List<SpouseRef> wives = dqFamily.getWifeRefs();
        String wifeId = wives.size() > 0 ? wives.get(0).getRef() : null;
        Relationship coupleRelationship = null;
        Date lastModified = CommonMapper.toDate(dqFamily.getChange());
        if (husbandId != null && wifeId != null) {
            coupleRelationship = CommonMapper.toRelationship(familyId, husbandId, wifeId, RelationshipType.Couple);
            result.addRelationship(coupleRelationship);
        }
        for (ChildRef child : dqFamily.getChildRefs()) {
            Relationship gedxRelationship;
            List<ParentFamilyRef> childToFamilyLinks;
            Person dqChild;
            String childId = child.getRef();
            Person person = dqChild = dqGedcom == null ? null : dqGedcom.getPerson(childId);
            if (dqChild != null) {
                childToFamilyLinks = dqChild.getParentFamilyRefs();
            } else {
                logger.warn(ConversionContext.getContext(), "Could not find referenced child (@{}@ INDI).", (Object)childId);
                childToFamilyLinks = Collections.emptyList();
            }
            if (husbandId != null) {
                gedxRelationship = CommonMapper.toRelationship(familyId, husbandId, childId, RelationshipType.ParentChild);
                this.addFacts(gedxRelationship, familyId, childToFamilyLinks);
                result.addRelationship(gedxRelationship);
            }
            if (wifeId == null) continue;
            gedxRelationship = CommonMapper.toRelationship(familyId, wifeId, childId, RelationshipType.ParentChild);
            this.addFacts(gedxRelationship, familyId, childToFamilyLinks);
            result.addRelationship(gedxRelationship);
        }
        int index = 0;
        for (EventFact eventFact : dqFamily.getEventsFacts()) {
            Marker factContext = ConversionContext.getDetachedMarker(eventFact.getTag() + '.' + ++index);
            ConversionContext.addReference(factContext);
            if (coupleRelationship != null) {
                Fact fact = FactMapper.toFact(eventFact, result);
                coupleRelationship.addFact(fact);
            } else {
                logger.warn(ConversionContext.getContext(), "The GEDCOM X converter only supports the {} fact in the presence of a couple relationship.", (Object)eventFact.getTag());
            }
            ConversionContext.removeReference(factContext);
        }
        if (coupleRelationship != null) {
            coupleRelationship.setSources(CommonMapper.toSourcesAndSourceReferences(dqFamily.getSourceCitations(), result));
        } else {
            int size = dqFamily.getSourceCitations().size();
            if (size > 0) {
                logger.warn(ConversionContext.getContext(), "The GEDCOM X converter only supports a source citation(s) in the presence of a couple relationship; {} source citation(s) ignored.", (Object)size);
            }
        }
        int cntLdsOrdinances = dqFamily.getLdsOrdinances().size();
        if (cntLdsOrdinances > 0) {
            logger.warn(ConversionContext.getContext(), "Did not convert information for {} LDS ordinances.", (Object)cntLdsOrdinances);
        }
        if ((cntNotes = dqFamily.getNotes().size() + dqFamily.getNoteRefs().size()) > 0) {
            logger.warn(ConversionContext.getContext(), "Did not process {} notes or references to notes.", (Object)cntNotes);
        }
        if ((cntMedia = dqFamily.getMedia().size() + dqFamily.getMediaRefs().size()) > 0) {
            logger.warn(ConversionContext.getContext(), "Did not process {} media items or references to media items.", (Object)cntMedia);
        }
        for (String refNum : dqFamily.getReferenceNumbers()) {
            Marker refnContext = ConversionContext.getDetachedMarker("REFN");
            ConversionContext.addReference(refnContext);
            logger.warn(ConversionContext.getContext(), "User reference number ({}) was ignored.", (Object)refNum);
            ConversionContext.removeReference(refnContext);
        }
        if (dqFamily.getRin() != null) {
            logger.warn(ConversionContext.getContext(), "RIN ({}) was ignored.", (Object)dqFamily.getRin());
        }
        if (dqFamily.getUid() != null) {
            Marker uidContext = ConversionContext.getDetachedMarker(dqFamily.getUidTag());
            ConversionContext.addReference(uidContext);
            logger.warn(ConversionContext.getContext(), "UID ({}) was ignored.", (Object)dqFamily.getUid());
            ConversionContext.removeReference(uidContext);
        }
        if (dqFamily.getExtensions().size() > 0) {
            for (String extensionCategory : dqFamily.getExtensions().keySet()) {
                for (GedcomTag tag : (List)dqFamily.getExtension(extensionCategory)) {
                    logger.warn(ConversionContext.getContext(), "Unsupported ({}): {}", extensionCategory, tag);
                }
            }
        }
        ConversionContext.removeReference(familyContext);
    }

    private void addFacts(Relationship gedxRelationship, String ged5FamilyId, List<ParentFamilyRef> childToFamilyLinks) {
        for (ParentFamilyRef ref : childToFamilyLinks) {
            Fact fact;
            String relationshipType;
            if (!ref.getRef().equals(ged5FamilyId) || (relationshipType = ref.getRelationshipType()) == null) continue;
            if ((relationshipType = relationshipType.toLowerCase().trim()).equalsIgnoreCase("adopted")) {
                fact = new Fact();
                fact.setKnownType(FactType.AdoptiveParent);
                gedxRelationship.addFact(fact);
                continue;
            }
            if (relationshipType.equalsIgnoreCase("birth")) {
                fact = new Fact();
                fact.setKnownType(FactType.BiologicalParent);
                gedxRelationship.addFact(fact);
                continue;
            }
            if (relationshipType.equalsIgnoreCase("foster")) {
                fact = new Fact();
                fact.setKnownType(FactType.FosterParent);
                gedxRelationship.addFact(fact);
                continue;
            }
            logger.warn(ConversionContext.getContext(), "Information designating this relationship as \"{}\" was dropped.", (Object)ref.getRelationshipType());
        }
    }
}

