/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conversion.gedcom.dq55;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.model.NoteRef;
import org.folg.gedcom.model.Repository;
import org.folg.gedcom.model.RepositoryRef;
import org.folg.gedcom.model.Source;
import org.gedcomx.agent.Agent;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.conversion.GedcomxConversionResult;
import org.gedcomx.conversion.gedcom.dq55.CommonMapper;
import org.gedcomx.conversion.gedcom.dq55.ConversionContext;
import org.gedcomx.source.CitationField;
import org.gedcomx.source.SourceCitation;
import org.gedcomx.source.SourceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class SourceDescriptionMapper {
    private static final Logger logger = LoggerFactory.getLogger(CommonMapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toSourceDescription(Source dqSource, GedcomxConversionResult result) throws IOException {
        Marker sourceContext = ConversionContext.getDetachedMarker(String.format("@%s@ SOUR", dqSource.getId()));
        ConversionContext.addReference(sourceContext);
        try {
            int cntMedia;
            int cntNotes;
            CitationField field;
            SourceDescription gedxSourceDescription = new SourceDescription();
            gedxSourceDescription.setId(dqSource.getId());
            if (dqSource.getAbbreviation() != null) {
                gedxSourceDescription.setTitles(Arrays.asList(new TextValue(dqSource.getAbbreviation())));
            } else if (dqSource.getTitle() != null) {
                gedxSourceDescription.setTitles(Arrays.asList(new TextValue(dqSource.getTitle())));
            }
            SourceCitation citation = new SourceCitation();
            citation.setCitationTemplate(new ResourceReference(URI.create("gedcom5:citation-template")));
            citation.setFields(new ArrayList<CitationField>());
            citation.setValue("");
            if (dqSource.getAuthor() != null) {
                field = new CitationField();
                field.setName(URI.create("gedcom5:citation-template/author"));
                field.setValue(dqSource.getAuthor());
                citation.getFields().add(field);
                citation.setValue(citation.getValue() + (citation.getValue().length() > 0 ? ", " + dqSource.getAuthor() : dqSource.getAuthor()));
            }
            if (dqSource.getTitle() != null) {
                field = new CitationField();
                field.setName(URI.create("gedcom5:citation-template/title"));
                field.setValue(dqSource.getTitle());
                citation.getFields().add(field);
                citation.setValue(citation.getValue() + (citation.getValue().length() > 0 ? ", " + dqSource.getTitle() : dqSource.getTitle()));
            }
            if (dqSource.getPublicationFacts() != null) {
                field = new CitationField();
                field.setName(URI.create("gedcom5:citation-template/publication-facts"));
                field.setValue(dqSource.getPublicationFacts());
                citation.getFields().add(field);
                citation.setValue(citation.getValue() + (citation.getValue().length() > 0 ? ", " + dqSource.getPublicationFacts() : dqSource.getPublicationFacts()));
            }
            if (dqSource.getText() != null) {
                logger.warn(ConversionContext.getContext(), "GEDCOM X does not currently support text extracted from a source.");
            }
            if (dqSource.getRepositoryRef() != null) {
                Marker repoContext = ConversionContext.getDetachedMarker("REPO");
                ConversionContext.addReference(repoContext);
                try {
                    RepositoryRef dqRepositoryRef = dqSource.getRepositoryRef();
                    if (dqRepositoryRef.getRef() != null) {
                        gedxSourceDescription.setMediator(new ResourceReference(URI.create(CommonMapper.getOrganizationReference(dqRepositoryRef.getRef()))));
                    } else {
                        String inlineRepoId = dqSource.getId() + ".REPO";
                        Agent gedxOrganization = new Agent();
                        gedxOrganization.setId(inlineRepoId);
                        for (org.folg.gedcom.model.Note dqNote : dqRepositoryRef.getNotes()) {
                            Note gedxNote = new Note();
                            gedxNote.setText(dqNote.getValue());
                            gedxOrganization.addExtensionElement(gedxNote);
                        }
                        for (NoteRef dqNoteRef : dqRepositoryRef.getNoteRefs()) {
                            logger.warn(ConversionContext.getContext(), "Unable to associate a note ({}) with the inline-defined organization ({})", dqNoteRef.getRef(), inlineRepoId);
                        }
                        result.addOrganization(gedxOrganization);
                        gedxSourceDescription.setMediator(new ResourceReference(URI.create(CommonMapper.getOrganizationReference(inlineRepoId))));
                    }
                    if (dqRepositoryRef.getCallNumber() != null) {
                        CitationField field2 = new CitationField();
                        field2.setName(URI.create("gedcom5:citation-template/call-number"));
                        field2.setValue(dqRepositoryRef.getCallNumber());
                        citation.getFields().add(field2);
                        citation.setValue(citation.getValue() + (citation.getValue().length() > 0 ? ", " + dqRepositoryRef.getCallNumber() : dqRepositoryRef.getCallNumber()));
                    }
                }
                finally {
                    ConversionContext.removeReference(repoContext);
                }
            }
            if (dqSource.getCallNumber() != null) {
                field = new CitationField();
                field.setName(URI.create("gedcom5:citation-template/call-number"));
                field.setValue(dqSource.getCallNumber());
                citation.getFields().add(field);
                citation.setValue(citation.getValue() + (citation.getValue().length() > 0 ? ", " + dqSource.getCallNumber() : dqSource.getCallNumber()));
            }
            if (citation.getValue().length() > 0) {
                citation.setValue(citation.getValue() + '.');
                gedxSourceDescription.setCitations(Arrays.asList(citation));
            }
            if ((cntNotes = dqSource.getNotes().size() + dqSource.getNoteRefs().size()) > 0) {
                logger.warn(ConversionContext.getContext(), "Did not process {} notes or references to notes.", (Object)cntNotes);
            }
            if ((cntMedia = dqSource.getMedia().size() + dqSource.getMediaRefs().size()) > 0) {
                logger.warn(ConversionContext.getContext(), "Did not process {} media items or references to media items.", (Object)cntMedia);
            }
            if (dqSource.getType() != null) {
                Marker nameTypeContext = ConversionContext.getDetachedMarker(dqSource.getTypeTag());
                ConversionContext.addReference(nameTypeContext);
                logger.warn(ConversionContext.getContext(), "Source type ({}) was ignored.", (Object)dqSource.getType());
                ConversionContext.removeReference(nameTypeContext);
            }
            if (dqSource.getDate() != null) {
                Marker dateContext = ConversionContext.getDetachedMarker("DATE");
                ConversionContext.addReference(dateContext);
                logger.warn(ConversionContext.getContext(), "Specificaton does not define the meaning of DATE in this context; value ({}) was ignored.", (Object)dqSource.getDate());
                ConversionContext.removeReference(dateContext);
            }
            if (dqSource.getReferenceNumber() != null) {
                Marker refnContext = ConversionContext.getDetachedMarker("REFN");
                ConversionContext.addReference(refnContext);
                logger.warn(ConversionContext.getContext(), "User reference number ({}) was ignored.", (Object)dqSource.getReferenceNumber());
                ConversionContext.removeReference(refnContext);
            }
            if (dqSource.getRin() != null) {
                logger.warn(ConversionContext.getContext(), "RIN ({}) was ignored.", (Object)dqSource.getRin());
            }
            if (dqSource.getUid() != null) {
                Marker uidContext = ConversionContext.getDetachedMarker(dqSource.getUidTag());
                ConversionContext.addReference(uidContext);
                logger.warn(ConversionContext.getContext(), "UID ({}) was ignored.", (Object)dqSource.getUid());
                ConversionContext.removeReference(uidContext);
            }
            if (dqSource.getExtensions().size() > 0) {
                for (String extensionCategory : dqSource.getExtensions().keySet()) {
                    for (GedcomTag tag : (List)dqSource.getExtension(extensionCategory)) {
                        logger.warn(ConversionContext.getContext(), "Unsupported ({}): {}", extensionCategory, tag);
                    }
                }
            }
            result.addSourceDescription(gedxSourceDescription);
        }
        finally {
            ConversionContext.removeReference(sourceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toOrganization(Repository dqRepository, GedcomxConversionResult result) throws IOException {
        Marker repositoryContext = ConversionContext.getDetachedMarker(String.format("@%s@ REPO", dqRepository.getId()));
        ConversionContext.addReference(repositoryContext);
        try {
            Agent gedxOrganization = new Agent();
            CommonMapper.populateAgent(gedxOrganization, dqRepository.getId(), dqRepository.getName(), dqRepository.getAddress(), dqRepository.getPhone(), dqRepository.getFax(), dqRepository.getEmail(), dqRepository.getWww());
            int cntNotes = dqRepository.getNotes().size() + dqRepository.getNoteRefs().size();
            if (cntNotes > 0) {
                logger.warn(ConversionContext.getContext(), "Did not process {} notes or references to notes.", (Object)cntNotes);
            }
            if (dqRepository.getRin() != null) {
                logger.warn(ConversionContext.getContext(), "RIN ({}) was ignored.", (Object)dqRepository.getRin());
            }
            if (dqRepository.getValue() != null) {
                logger.warn(ConversionContext.getContext(), "Unexpected repository value ({}) was ignored.", (Object)dqRepository.getValue());
            }
            if (dqRepository.getExtensions().size() > 0) {
                for (String extensionCategory : dqRepository.getExtensions().keySet()) {
                    for (GedcomTag tag : (List)dqRepository.getExtension(extensionCategory)) {
                        logger.warn(ConversionContext.getContext(), "Unsupported ({}): {}", extensionCategory, tag);
                    }
                }
            }
            result.addOrganization(gedxOrganization);
        }
        finally {
            ConversionContext.removeReference(repositoryContext);
        }
    }
}

