/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.fileformat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.gedcomx.Gedcomx;
import org.gedcomx.fileformat.GedcomxEntryDeserializer;
import org.gedcomx.fileformat.GedcomxEntrySerializer;
import org.gedcomx.rt.GedcomNamespaceManager;

public class DefaultXMLSerialization
implements GedcomxEntrySerializer,
GedcomxEntryDeserializer {
    private final Unmarshaller unmarshaller;
    private final Marshaller marshaller;
    private Set<String> knownContentTypes = new HashSet<String>(Arrays.asList("application/x-gedcomx-v1+xml"));

    public DefaultXMLSerialization(Class<?> ... classes) {
        this(true, classes);
    }

    public DefaultXMLSerialization(boolean pretty, Class<?> ... classes) {
        try {
            JAXBContext context = DefaultXMLSerialization.newContext(classes);
            this.unmarshaller = context.createUnmarshaller();
            this.marshaller = context.createMarshaller();
            this.marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new GedcomNamespaceManager(Gedcomx.class));
            if (pretty) {
                this.marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            }
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Object deserialize(InputStream in) throws IOException {
        try {
            return this.unmarshaller.unmarshal(in);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void serialize(Object resource, OutputStream out) throws IOException {
        try {
            this.marshaller.marshal(resource, out);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isKnownContentType(String contentType) {
        return this.knownContentTypes.contains(contentType);
    }

    public Set<String> getKnownContentTypes() {
        return this.knownContentTypes;
    }

    public void setKnownContentTypes(Set<String> knownContentTypes) {
        this.knownContentTypes = knownContentTypes;
    }

    private static JAXBContext newContext(Class<?> ... classes) throws JAXBException {
        HashSet contextClasses = new HashSet();
        contextClasses.add(Gedcomx.class);
        contextClasses.addAll(Arrays.asList(classes));
        return JAXBContext.newInstance(contextClasses.toArray(new Class[contextClasses.size()]));
    }
}

