/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.fileformat;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gedcomx.fileformat.DefaultXMLSerialization;
import org.gedcomx.fileformat.GedcomxEntryDeserializer;
import org.gedcomx.fileformat.GedcomxFileEntry;

public class GedcomxFile {
    private final JarFile gedxFile;
    private final GedcomxEntryDeserializer deserializer;

    public GedcomxFile(JarFile gedxFile, GedcomxEntryDeserializer deserializer) {
        this.gedxFile = gedxFile;
        this.deserializer = deserializer;
    }

    public GedcomxFile(JarFile jarFile, Class<?> ... classes) throws IOException {
        this(jarFile, new DefaultXMLSerialization(classes));
    }

    public String getAttribute(String name) throws IOException {
        return this.gedxFile.getManifest().getMainAttributes().getValue(name);
    }

    public Map<String, String> getAttributes() throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.gedxFile.getManifest().getMainAttributes().entrySet()) {
            String key = entry.getKey().toString();
            String value = (String)entry.getValue();
            attributes.put(key, value);
        }
        return attributes;
    }

    public Iterable<GedcomxFileEntry> getEntries() {
        final Enumeration<JarEntry> jarEntries = this.gedxFile.entries();
        return new Iterable<GedcomxFileEntry>(){

            @Override
            public Iterator<GedcomxFileEntry> iterator() {
                return new Iterator<GedcomxFileEntry>(){

                    @Override
                    public boolean hasNext() {
                        return jarEntries.hasMoreElements();
                    }

                    @Override
                    public GedcomxFileEntry next() {
                        return new GedcomxFileEntry((JarEntry)jarEntries.nextElement());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public InputStream getResourceStream(GedcomxFileEntry gedxEntry) throws IOException {
        return this.gedxFile.getInputStream(gedxEntry.getJarEntry());
    }

    public Object readResource(GedcomxFileEntry gedxEntry) throws IOException {
        return this.deserializer.deserialize(this.getResourceStream(gedxEntry));
    }

    public void close() throws IOException {
        this.gedxFile.close();
    }
}

